package com.netacom.base.chat.coroutine

import androidx.annotation.Keep
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.FlowPreview
import kotlinx.coroutines.Job
import kotlinx.coroutines.ObsoleteCoroutinesApi
import kotlinx.coroutines.channels.BroadcastChannel
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.consumeAsFlow
import kotlinx.coroutines.flow.filter
import kotlinx.coroutines.flow.map
import kotlinx.coroutines.launch
import javax.inject.Singleton
import kotlin.coroutines.CoroutineContext

/**
 * You can use like this.
 * val channel = EventBus().asChannel<ItemChangeAction>()
 * launch (UI){
 *   for(action in channel){
 *     // You can use item
 *     action.item
 *   }
 * }
 */

@Keep
@Singleton
class NetAloEvent : CoroutineScope {
    private val job = Job()

    override val coroutineContext: CoroutineContext
        get() = job + Dispatchers.Main

    @ObsoleteCoroutinesApi
    @ExperimentalCoroutinesApi
    val bus = BroadcastChannel<Any>(1)

    @ExperimentalCoroutinesApi
    fun send(event: Any?): Boolean {
        event?.let { eventSend ->
            launch {
                bus.send(eventSend)
            }
        }
        return false
    }

    @ObsoleteCoroutinesApi
    @FlowPreview
    @ExperimentalCoroutinesApi
    inline fun <reified T> receive(): Flow<T> {
        return bus.openSubscription().consumeAsFlow().filter { it is T }.map { it as T }
    }
}
