/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.json

import androidx.annotation.Keep
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types
import java.lang.reflect.Type

@Keep
class JsonSerializerImpl(private val moShi: Moshi) : JsonSerializer {
    override fun <T> asJson(data: T?, clazz: Class<T>): String? = if (data == null) {
        null
    } else {
        moShi.adapter(clazz).nullSafe().lenient().toJson(data)
    }

    override fun <T> asJson(data: List<T>?, clazz: Class<T>): String? = if (data == null) {
        null
    } else {
        moShi.adapter<List<T>>(type(clazz)).nullSafe().lenient().toJson(data)
    }

    override fun <T> asObject(json: String?, clazz: Class<T>): T? = if (json.isNullOrBlank()) {
        null
    } else {
        try {
            moShi.adapter(clazz).nullSafe().lenient().fromJson(json)
        } catch (e: Exception) {
            null
        }
    }

    override fun <T> asList(json: String?, clazz: Class<T>): List<T>? = if (json.isNullOrBlank()) {
        null
    } else {
        moShi.adapter<List<T>>(type(clazz)).nullSafe().lenient().fromJson(json)
    }

    private fun <T> type(clazz: Class<T>): Type = Types.newParameterizedType(MutableList::class.java, clazz)
}
