/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.base.chat.library.mention.common

import android.text.SpannableString
import android.text.Spanned
import android.text.TextPaint
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.util.Log
import android.view.View
import com.netacom.base.chat.util.getThemeColor

/**
 * Create on 8/4/20
 * @author duonghd
 */

class MentionSpan(
    private val input: String
) : ClickableSpan() {
    companion object {
        fun build(input: String, color: Int? = null): SpannableString {
            val output = SpannableString(input)
            color?.let {
                output.setSpan(
                    ForegroundColorSpan(getThemeColor(it)),
                    0,
                    input.length,
                    Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
                )
            } ?: kotlin.run {
                output.setSpan(
                    MentionSpan(input = input),
                    0,
                    input.length,
                    Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
                )
            }

            return output
        }
    }

    override fun onClick(view: View) {
        Log.e("test", input)
    }

    override fun updateDrawState(tp: TextPaint) {
        tp.color = MentionSpanConfig.NORMAL_TEXT_COLOR
        tp.bgColor = MentionSpanConfig.NORMAL_TEXT_BACKGROUND_COLOR

        tp.isUnderlineText = false
    }
}
