/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.base.chat.library.mention.common

import android.graphics.Color
import androidx.annotation.ColorInt

/**
 * Create on 8/4/20
 * @author duonghd
 */

object MentionSpanConfig {
    @ColorInt
    var NORMAL_TEXT_COLOR = Color.parseColor("#00a0dc")

    @ColorInt
    var NORMAL_TEXT_BACKGROUND_COLOR = Color.TRANSPARENT

    @ColorInt
    var SELECTED_TEXT_COLOR = Color.WHITE

    @ColorInt
    var SELECTED_TEXT_BACKGROUND_COLOR = Color.parseColor("#0077b5")

    fun initColor(
        normalTextColor: Int?,
        normalTextBackgroundColor: Int?,
        selectTextColor: Int?,
        selectTextBackgroundColor: Int?
    ) {
        normalTextColor?.let {
            NORMAL_TEXT_COLOR = it
        }
        normalTextBackgroundColor?.let {
            NORMAL_TEXT_BACKGROUND_COLOR = it
        }
        selectTextColor?.let {
            SELECTED_TEXT_COLOR = it
        }
        selectTextBackgroundColor?.let {
            SELECTED_TEXT_BACKGROUND_COLOR = it
        }
    }
}
