package com.netacom.base.chat.livedata

import androidx.lifecycle.Observer

/**
 * Created by Tam Nguyen on 11/1/20.
 */

/**
 * An [Observer] for [EventLiveData]s, simplifying the pattern of checking if the [EventLiveData]'s content has
 * already been handled.
 *
 * [onEventUnhandledContent] is *only* called if the [EventLiveData]'s contents has not been handled.
 */
class EventObserver<T>(private val onEventUnhandledContent: (T) -> Unit) : Observer<EventLiveData<T>> {
    override fun onChanged(event: EventLiveData<T>?) {
        event?.getContentIfNotHandled()?.let { value ->
            onEventUnhandledContent(value)
        }
    }
}
