/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.logger

import androidx.annotation.NonNull
import androidx.annotation.Nullable

/**
 * Android terminal log output implementation for [LogAdapter].
 *
 * Prints output to LogCat with pretty borders.
 *
 * <pre>
 * ┌──────────────────────────
 * │ Method stack history
 * ├┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄┄
 * │ Log message
 * └──────────────────────────
</pre> *
 */
open class AndroidLogAdapter : LogAdapter {
    @NonNull
    private val formatStrategy: FormatStrategy

    constructor() {
        formatStrategy = PrettyFormatStrategy.newBuilder().build()
    }

    constructor(@NonNull formatStrategy: FormatStrategy?) {
        this.formatStrategy = Utils.checkNotNull(formatStrategy)
    }

    override fun isLoggable(priority: Int, @Nullable tag: String?): Boolean {
        return true
    }

    override fun log(priority: Int, @Nullable tag: String?, @NonNull message: String?) {
        formatStrategy.log(priority, tag, message)
    }
}
