/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.logger

import androidx.annotation.NonNull
import androidx.annotation.Nullable
import com.netacom.base.chat.logger.CsvFormatStrategy.Companion.newBuilder

/**
 * This is used to saves log messages to the disk.
 * By default it uses [CsvFormatStrategy] to translates text message into CSV format.
 */
class DiskLogAdapter : LogAdapter {
    @NonNull
    private val formatStrategy: FormatStrategy

    constructor() {
        formatStrategy = newBuilder().build()
    }

    constructor(@NonNull formatStrategy: FormatStrategy?) {
        this.formatStrategy = Utils.checkNotNull(formatStrategy)
    }

    override fun isLoggable(priority: Int, @Nullable tag: String?): Boolean {
        return true
    }

    override fun log(priority: Int, @Nullable tag: String?, @NonNull message: String?) {
        formatStrategy.log(priority, tag, message)
    }
}
