/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.logger

import android.util.Log
import androidx.annotation.NonNull
import androidx.annotation.Nullable
import com.netacom.base.chat.logger.Utils.checkNotNull

/**
 * LogCat implementation for [LogStrategy]
 *
 * This simply prints out all logs to Logcat by using standard [Log] class.
 */
class LogcatLogStrategy : LogStrategy {
    override fun log(priority: Int, @Nullable tag: String?, @NonNull message: String?) {
        var tag = tag
        checkNotNull(message)
        if (tag == null) {
            tag = DEFAULT_TAG
        }
        Log.println(priority, tag, message!!)
    }

    companion object {
        const val DEFAULT_TAG = "NO_TAG"
    }
}
