/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.logger

import androidx.annotation.Keep
import androidx.annotation.NonNull
import androidx.annotation.Nullable

/**
 * A proxy interface to enable additional operations.
 * Contains all possible Log message usages.
 */
@Keep
interface Printer {
    fun addAdapter(@NonNull adapter: LogAdapter?)
    fun t(@Nullable tag: String?): Printer?
    fun d(@NonNull message: String?, @Nullable vararg args: Any?)
    fun d(@Nullable `object`: Any?)
    fun e(@NonNull message: String?, @Nullable vararg args: Any?)
    fun e(@Nullable throwable: Throwable?, @NonNull message: String?, @Nullable vararg args: Any?)
    fun w(@NonNull message: String?, @Nullable vararg args: Any?)
    fun i(@NonNull message: String?, @Nullable vararg args: Any?)
    fun v(@NonNull message: String?, @Nullable vararg args: Any?)
    fun wtf(@NonNull message: String?, @Nullable vararg args: Any?)

    /**
     * Formats the given json content and print it
     */
    fun json(@Nullable json: String?)

    /**
     * Formats the given xml content and print it
     */
    fun xml(@Nullable xml: String?)
    fun log(
        priority: Int,
        @Nullable tag: String?,
        @Nullable message: String?,
        @Nullable throwable: Throwable?
    )
    fun clearLogAdapters()
}
