/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.mapper

import androidx.annotation.Keep

@Keep
interface EntityMapper<E, D> {

    fun mapFromEntity(entity: E): D

    fun mapToEntity(domain: D): E

    fun mapFromEntityList(entities: List<E>): List<D> = entities.mapTo(
        mutableListOf(),
        ::mapFromEntity
    )

    fun mapFromDomainList(domainModels: List<D>): List<E> = domainModels.mapTo(
        mutableListOf(),
        ::mapToEntity
    )
}
