/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.model

import com.netacom.base.chat.R
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.base.ActionData
import com.netacom.base.chat.component.EventBus
import com.netacom.base.chat.network.ApiResponse
import com.netacom.base.chat.type.RequestStatus
import com.netacom.base.chat.type.ScreenState

data class ScreenStateObj(
    val state: ScreenState,
    val message: Any? = null,
    val func: (() -> Unit)? = null
) {
    companion object {
        fun INIT() = ScreenStateObj(state = ScreenState.INIT)
        fun DATA() = ScreenStateObj(state = ScreenState.DATA)
        fun EMPTY_FILTER() = ScreenStateObj(state = ScreenState.EMPTY_FILTER)
        fun <T> ERROR(response: ApiResponse<T>, callback: (() -> Unit)? = null): ScreenStateObj =
            when (response.errorCode) {
                RequestStatus.NO_INTERNET_CONNECTION.value -> {
                    ScreenStateObj(
                        message = StringUtils.getString(
                            R.string.not_have_internet_please_check_your_connection
                        ),
                        state = ScreenState.NO_INTERNET,
                        func = callback
                    )
                }
                RequestStatus.ERROR_CLIENT.value -> {
                    ScreenStateObj(
                        message = StringUtils.getString(R.string.common_error_unknown),
                        state = ScreenState.ERROR,
                        func = callback
                    )
                }
                RequestStatus.NO_PERMISSION.value, RequestStatus.FORBIDDEN.value -> {
                    ScreenStateObj(
                        message = StringUtils.getString(R.string.no_permission_error),
                        state = ScreenState.NO_PERMISSION,
                        func = callback
                    )
                }
                RequestStatus.CANCEL_REQUEST.value -> {
                    ScreenStateObj(
                        message = null,
                        state = ScreenState.ERROR,
                        func = callback
                    )
                }
                RequestStatus.UNAUTHORIZED.value -> {
                    // AppAuthentication.logOut()
                    EventBus.sendEvent(
                        ActionData(
                            errorCode = RequestStatus.UNAUTHORIZED
                        )
                    )

                    ScreenStateObj(
                        message = StringUtils.getString(R.string.common_error_unknown),
                        state = ScreenState.ERROR,
                        func = callback
                    )
                }
                else -> {
                    val messages = response.message
                    ScreenStateObj(
                        message = if (messages.isNullOrEmpty()) StringUtils.getString(
                            R.string.common_error_unknown
                        ) else messages,
                        state = ScreenState.ERROR,
                        func = callback
                    )
                }
            }
    }

    fun isDisplayData() =
        (
            state == ScreenState.DATA ||
                state == ScreenState.REFRESH ||
                state == ScreenState.LOAD_MORE ||
                state == ScreenState.LOAD_MORE_EMPTY ||
                state == ScreenState.LOAD_MORE_ERROR ||
                state == ScreenState.REFRESH_ERROR ||
                state == ScreenState.REFRESH_EMPTY
            )
}
