/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.network

abstract class ApiResponse<T>(
    var data: T? = null,
    var message: String? = null,
    var error: ErrorResponse? = null,
    var code: Int? = null,
    var errorCode: Int? = null
) {
    override fun toString(): String {
        return "ApiResponse(data=$data, message=$message, error=$error, code=$code, errorCode=$errorCode)"
    }
}
class ApiResponseSuccess<T>(data: T?, code: Int? = null) : ApiResponse<T>(data = data, code = code)
class ApiResponseError<T>(
    errorCode: Int? = null,
    message: String? = null,
    error: ErrorResponse? = null
) : ApiResponse<T>(errorCode = errorCode, message = message, error = error)
