package com.netacom.base.chat.network

import androidx.annotation.Keep
import okhttp3.MediaType
import okhttp3.RequestBody
import okio.Buffer
import okio.BufferedSink
import okio.ForwardingSink
import okio.Sink
import okio.buffer
import java.io.IOException

class CountingFileRequestBody(var delegate: RequestBody, var listener: Listener) : RequestBody() {
    private lateinit var countingSink: CountingSink
    override fun contentType(): MediaType? {
        return delegate.contentType()
    }

    override fun contentLength(): Long {
        try {
            return delegate.contentLength()
        } catch (e: IOException) {
            e.printStackTrace()
        }
        return -1
    }

    @Throws(IOException::class)
    override fun writeTo(sink: BufferedSink) {
        countingSink = CountingSink(sink)
        val bufferedSink: BufferedSink = countingSink.buffer()
        delegate.writeTo(bufferedSink)
        bufferedSink.flush()
    }

    inner class CountingSink(delegate: Sink) : ForwardingSink(delegate) {
        private var bytesWritten: Long = 0

        @Throws(IOException::class)
        override fun write(source: Buffer, byteCount: Long) {
            super.write(source, byteCount)
            bytesWritten += byteCount
//            listener.onRequestProgress(bytesWritten, contentLength())
            listener.onRequestProgress(bytesWritten)
        }
    }

    @Keep
    interface Listener {
        fun onRequestProgress(bytesWritten: Long)
    }
}
