package com.netacom.base.chat.util

import android.os.Handler
import android.view.View
import android.view.animation.AlphaAnimation

class Animation {
    // what_to_call_you_text.fadeIn(haltTime = 2 * default_fade_in_duration)
    fun View.fadeIn(
        haltTime: Long = 0L,
        fadeDuration: Long = 500
    ) {
        this.visibility = View.INVISIBLE
        Handler().postDelayed(
            {
                this.startAnimation(
                    AlphaAnimation(0F, 1F).apply {
                        duration = fadeDuration
                        fillAfter = true
                    }
                )
                this.visibility = View.VISIBLE
            },
            haltTime
        )
    }
}
