/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.util

import android.app.Activity
import android.widget.TextView
import android.widget.Toast
import androidx.annotation.ColorRes
import androidx.annotation.StringRes
import androidx.core.content.ContextCompat
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.Observer
import com.netacom.base.chat.R
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.base.ActionData
import com.netacom.base.chat.base.ActionLiveData
import com.netacom.base.chat.library.progressbutton.attachTextChangeAnimator
import com.netacom.base.chat.library.progressbutton.bindProgressButton
import com.netacom.base.chat.library.progressbutton.hideProgress
import com.netacom.base.chat.library.progressbutton.showDrawable
import com.netacom.base.chat.library.progressbutton.showProgress
import com.netacom.base.chat.type.Result
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class ButtonUtil {
    companion object {

        @JvmStatic
        fun <T> setupButtonProgress(
            button: TextView,
            activity: Activity? = null,
            lifecycle: LifecycleOwner = (activity as LifecycleOwner),
            actionLiveData: ActionLiveData<ActionData<T>>,
            @StringRes successMsgRes: Int? = null,
            @ColorRes colorRes: Int = R.color.color_white,
            listener: ((Result, T?) -> Unit)? = null
        ) {
            val label = button.text.toString()
            lifecycle.bindProgressButton(button)
            button.attachTextChangeAnimator()
            actionLiveData.observe(
                lifecycle,
                {
                    it.isDoing?.let { isDoing ->
                        if (isDoing) {
                            listener?.invoke(Result.DOING, it.data)
                            button.showProgress { progressColorRes = colorRes }
                            ScreenUtil.lockScreen(activity, true)
                        } else {
                            ScreenUtil.lockScreen(activity, false)
                            if (it.isSuccess == null) {
                                button.hideProgress(label)
                            }
                        }
                    }

                    /*it.message?.let { msg ->
                        ToastUtils.showShort(msg)
                    }*/

                    it.isSuccess?.let { success ->
                        if (success) {
                            successMsgRes?.let { msgRes ->
                                val animatedDrawable =
                                    ContextCompat.getDrawable(
                                        button.context,
                                        R.drawable.ic_animated_check
                                    )
                                animatedDrawable?.setBounds(0, 0, 40, 40)
                                animatedDrawable?.let { drawable ->
                                    button.showDrawable(drawable) {
                                        buttonTextRes = msgRes
                                    }
                                }
                                MainScope().launch {
                                    delay(500)
                                    listener?.invoke(Result.SUCCESS, it.data)
                                    button.hideProgress(label)
                                }
                            } ?: run {
                                listener?.invoke(Result.SUCCESS, it.data)
                                button.hideProgress(label)
                            }
                        } else {
                            listener?.invoke(Result.FAIL, it.data)
                            button.hideProgress(label)
                        }
                    }
                }
            )
        }

        // Button with new label
        @JvmStatic
        fun <T> setupButtonProgress(
            button: TextView,
            activity: Activity? = null,
            lifecycle: LifecycleOwner = (activity as LifecycleOwner),
            actionLiveData: ActionLiveData<ActionData<T>>,
            @StringRes successMsgRes: Int? = null,
            @StringRes newLabelRes: Int? = null,
            @ColorRes colorRes: Int = R.color.color_white,
            listener: ((Result, T?) -> Unit)? = null
        ) {
            val newLabel = newLabelRes?.let { labelRes ->
                StringUtils.getString(labelRes)
            }
            lifecycle.bindProgressButton(button)
            button.attachTextChangeAnimator()
            actionLiveData.observe(
                lifecycle,
                Observer {
                    it.isDoing?.let { isDoing ->
                        if (isDoing) {
                            listener?.invoke(Result.DOING, it.data)
                            button.showProgress { progressColorRes = colorRes }
                            ScreenUtil.lockScreen(activity, true)
                        } else {
                            ScreenUtil.lockScreen(activity, false)
                            if (it.isSuccess == null) {
                                button.hideProgress(newLabel)
                            }
                        }
                    }

                    it.message?.let { msg ->
                        Toast.makeText(button.context, msg, Toast.LENGTH_LONG).show()
                    }

                    it.isSuccess?.let { success ->
                        if (success) {
                            successMsgRes?.let { msgRes ->
                                val animatedDrawable =
                                    ContextCompat.getDrawable(
                                        button.context,
                                        R.drawable.ic_animated_check
                                    )
                                animatedDrawable?.setBounds(0, 0, 40, 40)
                                animatedDrawable?.let { drawable ->
                                    button.showDrawable(drawable) {
                                        buttonTextRes = msgRes
                                    }
                                }
                                CoroutineScope(Dispatchers.Main).launch {
                                    delay(500)
                                    button.hideProgress(newLabel)
                                    listener?.invoke(Result.SUCCESS, it.data)
                                }
                            } ?: run {
                                button.hideProgress(newLabel)
                                listener?.invoke(Result.SUCCESS, it.data)
                            }
                        } else {
                            button.hideProgress(newLabel)
                            listener?.invoke(Result.FAIL, it.data)
                        }
                    }
                }
            )
        }
    }
}
