/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.util

import com.netacom.base.chat.android_utils.LanguageUtils
import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Date
import java.util.Locale

/**
Created by vantoan on 26/Aug/2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

object DateTimeUtils {
    const val JUST_TIME_FORMAT_PATTERN = "HH:mm"
    const val JUST_DATE_FORMAT_PATTERN = "dd/MM/yyyy"
    const val DATE_TIME_FORMAT_PATTERN = "HH:mm dd/MM/yyyy"
    const val FULL_DATE_TIME_FORMAT_PATTERN = "EEEE, dd/MM/yyyy HH:mm"

    @JvmStatic
    fun convertCountTimeToString(count: Long): String {
        val h = count / 3600
        val m = (count - h * 3600) / 60
        val s = count % 60
        val ms = String.format("%02d:%02d", m, s)
        return if (h > 0) String.format("%02d:%s", h, ms) else ms
    }

    fun getMillisFromNano(nanoTime: Long): Long {
        return if (nanoTime.toString().length > 13) {
            nanoTime.toString().substring(0, 13).toLong()
        } else {
            if (nanoTime.toString().length == 13) {
                nanoTime
            } else {
                nanoTime * 1000
            }
        }
    }

    fun getMillisecondFromString(timeString: String): Long {
        return getMillisFromNano(timeString.toLongOrNull() ?: 0)
    }

    fun parseCalenderFromString(dateTime: Long): Calendar? {
        if (dateTime <= 0) {
            return null
        }

        val milliseconds = getMillisFromNano(dateTime)

        if (milliseconds <= 0) {
            return null
        }

        val calendar = Calendar.getInstance()
        calendar.timeInMillis = milliseconds

        return calendar
    }

    object ParseDateTimeToString {
        const val JUST_TIME_FORMAT_PATTERN = "HH:mm"
        const val JUST_DATE_FORMAT_PATTERN = "dd/MM/yyyy"
        const val DATE_TIME_FORMAT_PATTERN = "HH:mm dd/MM/yyyy"
        const val FULL_DATE_TIME_FORMAT_PATTERN = "EEEE, dd/MM/yyyy HH:mm"
        const val FULL_DATE_TIME_FORMAT_PATTERN_NO_GET_HOUR_MIN = "EEEE, dd/MM/yyyy"
        fun parseJustTime(millis: Long): String {
            return parse(getMillisFromNano(millis), JUST_TIME_FORMAT_PATTERN)
        }

        fun parseJustDate(millis: Long): String {
            return parse(getMillisFromNano(millis), JUST_DATE_FORMAT_PATTERN)
        }

        fun parseDateTime(millis: Long): String {
            return parse(getMillisFromNano(millis), DATE_TIME_FORMAT_PATTERN)
        }

        fun parse(millis: Long, format: String): String {
            return if (LanguageUtils.isAppliedLanguage(Locale.ENGLISH)) {
                val parser = SimpleDateFormat(format, Locale.US)
                parser.format(Date(getMillisFromNano(millis)))
            } else {
                val locale = Locale("vi", "VN")
                val parser = SimpleDateFormat(format, locale)
                parser.format(Date(getMillisFromNano(millis)))
            }
        }

        fun parseDurationFromMilliSecond(milliSecond: Long): String {
            return if (milliSecond > 0) {
                val duration = milliSecond / 1000
                val hour = duration / 3600
                val min = (duration - hour * 3600) / 60
                val second = duration % 60
                "${if (hour > 0) String.format("%02d:", hour) else ""}${
                String.format("%02d", min)}:${String.format("%02d", second)}"
            } else {
                ""
            }
        }

        fun parseDurationFromSecond(duration: Long): String {
            return if (duration > 0) {
                val hour = duration / 3600
                val min = (duration - hour * 3600) / 60
                val second = duration % 60
                "${if (hour > 0) String.format("%02d:", hour) else ""}${
                String.format("%02d", min)}:${String.format("%02d", second)}"
            } else {
                ""
            }
        }
    }
}
