/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.util

import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.android_utils.TimeUtils
import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import java.util.Date

class IsoDateJsonAdapter : JsonAdapter<Date?>() {
    @Synchronized
    override fun fromJson(reader: JsonReader): Date? {
        val dateString = reader.nextString()
        return try {
            TimeUtils.string2Date(
                dateString,
                TimeUtils.getSafeDateFormat(DateTimeUtils.FULL_DATE_TIME_FORMAT_PATTERN)
            )
        } catch (e: Exception) {
            print("Unsupported format date: $dateString")
            FirebaseCrashlytics.getInstance().recordException(e)
            TimeUtils.getNowDate()
        }
    }

    @Synchronized
    override fun toJson(writer: JsonWriter, value: Date?) {
        try {
            val string = value?.let { TimeUtils.date2String(value).toString() }
            writer.value(string)
        } catch (e: Exception) {
            FirebaseCrashlytics.getInstance().recordException(e)
            e.printStackTrace()
        }
    }
}
