/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.util

import android.text.Editable
import android.text.TextWatcher
import android.widget.EditText

class OtpUtil {
    companion object {
        fun setup(vararg ets: EditText, onChange: ((view: EditText) -> Unit)?) {
            ets.forEachIndexed { index, editText ->
                editText.addTextChangedListener(
                    object : TextWatcher {
                        var newChar: String? = null
                        override fun afterTextChanged(s: Editable?) {
                            s?.let {
                                when (s.length) {
                                    0 -> if (index > 0) ets[index - 1].requestFocus()
                                    1 -> if ((index < ets.size - 1) && ets[index + 1].text.isNullOrBlank()) ets[index + 1].requestFocus()
                                    else -> {
                                        editText.removeTextChangedListener(this)
                                        editText.setText(newChar)
                                        editText.addTextChangedListener(this)
                                    }
                                }
                            } ?: run {
                                if (index > 0) ets[index - 1].requestFocus()
                            }
                            onChange?.invoke(editText)
                        }

                        override fun beforeTextChanged(
                            s: CharSequence?,
                            start: Int,
                            count: Int,
                            after: Int
                        ) {
                        }

                        override fun onTextChanged(
                            s: CharSequence?,
                            start: Int,
                            before: Int,
                            count: Int
                        ) {
                            s?.let {
                                if (count >= 1) {
                                    newChar = it[start].toString()
                                } else {
                                    newChar = ""
                                }
                            } ?: run {
                                newChar = ""
                            }
                        }
                    }
                )
            }
        }
    }
}
