/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.util

import android.app.Activity
import android.graphics.Color
import android.os.Build
import android.view.WindowManager
import androidx.core.content.ContextCompat

class ScreenUtil {
    companion object {
        @JvmStatic
        fun lockScreen(activity: Activity?, isLock: Boolean) {
            if (isLock) {
                activity?.window?.setFlags(
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE,
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE
                )
            } else {
                activity?.window?.clearFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
            }
        }

        @JvmStatic
        fun setStatusBarColor(activity: Activity?, color: Int? = null, colorRes: Int? = null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                activity?.window?.let { window ->
                    window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS)
                    window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS)
                    val c = color ?: colorRes?.let { ContextCompat.getColor(activity, colorRes) } ?: Color.WHITE
                    window.statusBarColor = c
                }
            }
        }
    }
}
