/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.util

import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.android_utils.LanguageUtils
import com.netacom.base.chat.type.Language
import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Date
import java.util.Locale
import java.util.TimeZone

object TimeUtils {

    const val DATE_FORMAT = "dd/MM/yyyy"
    const val PATTERN_ISO_INSTANT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"

    @JvmStatic
    fun toDate(timestamp: Long, pattern: String = DATE_FORMAT): String {
        val dateFormat = SimpleDateFormat(pattern, Locale.getDefault())
        return dateFormat.format(Date(timestamp)).toString()
    }

    @JvmStatic
    fun toUTCDate(timestamp: Long, pattern: String = PATTERN_ISO_INSTANT): String {
        val dateFormat = SimpleDateFormat(pattern, Locale.getDefault())
        dateFormat.timeZone = timeZoneGMT()
        return dateFormat.format(Date(timestamp)).toString()
    }

    @JvmStatic
    fun timeZoneGMT(): TimeZone = TimeZone.getTimeZone("GMT")

    @JvmStatic
    fun timeZoneDefault(): TimeZone = TimeZone.getDefault()

    @JvmStatic
    fun getDateByUTC(dateInString: String, pattern: String = PATTERN_ISO_INSTANT): Date? {
        val dateFormat = SimpleDateFormat(pattern, Locale.getDefault())
        dateFormat.timeZone = timeZoneGMT()
        return try {
            dateFormat.parse(dateInString)
        } catch (e: Exception) {
            FirebaseCrashlytics.getInstance().recordException(e)
            null
        }
    }

    @JvmStatic
    fun getTimeStamp(): Long = Calendar.getInstance().timeInMillis

    fun distanceTime(time: Long): ArrayList<Int> {
        val results = arrayListOf(0, 0, 0, 0)
        val currentMillis = System.currentTimeMillis() / 1000
        val distanceTime = currentMillis - time

        if (distanceTime < 0) return results
        val distanceTimeInt = distanceTime.toInt()
        results[0] = distanceTimeInt / 86400
        results[1] = (distanceTimeInt % 86400) / 3600
        results[2] = (distanceTimeInt % 3600) / 60
        results[3] = distanceTimeInt % 60

        return results
    }

    fun parseTimeAgo(time: Long): String {
        if (time == 0L) return ""

        val timeMillis = kotlin.run {
            if (time.toString().length > 10) time.toString().substring(0, 10).toLong()
            else time
        }

        var resultTime = ""

        if (timeMillis > 0L) {
            val new: String
            val labels = if (LanguageUtils.getLanguage() == Language.ENGLISH.value) {
                new = "now"
                mutableListOf("day", "hour", "min", "second")
            } else {
                new = "mới đây"
                mutableListOf("ngày", "giờ", "phút", "giây")
            }

            val times = distanceTime(timeMillis)

            for (index in 0 until times.count()) {
                if (times[index] > 0) {
                    resultTime = if (index == 0 && times[index] > 7) {
                        toDate(time * 1000)
                    } else if (index == 3) {
                        new
                    } else {
                        if (times[index] < 2) {
                            "${times[index]} ${labels[index]}"
                        } else {
                            if (LanguageUtils.getLanguage() == Language.ENGLISH.value) "${times[index]} ${labels[index]}s ago"
                            else "${times[index]} ${labels[index]} trước"
                        }
                    }
                    break
                } else {
                    if (index == times.count() - 1) {
                        resultTime = new
                    }
                }
            }
        }

        return resultTime
    }
}
