/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.util

import android.app.Activity
import android.widget.EditText
import android.widget.TextView
import androidx.annotation.ColorRes
import androidx.annotation.StringRes
import androidx.lifecycle.LifecycleOwner
import com.netacom.base.chat.R
import com.netacom.base.chat.base.ActionData
import com.netacom.base.chat.base.ActionLiveData
import com.netacom.base.chat.type.Result

fun EditText.getContent(): String = text.toString().trim()

fun <T> TextView.setup(
    activity: Activity?,
    actionLiveData: ActionLiveData<ActionData<T>>,
    @StringRes successMsgRes: Int? = null,
    @ColorRes colorRes: Int = R.color.color_white,
    listener: ((Result, T?) -> Unit)? = null
) =
    ButtonUtil.setupButtonProgress(
        button = this,
        activity = activity,
        actionLiveData = actionLiveData,
        successMsgRes = successMsgRes,
        colorRes = colorRes,
        listener = listener
    )

fun <T> TextView.setup(
    activity: Activity?,
    lifecycle: LifecycleOwner,
    actionLiveData: ActionLiveData<ActionData<T>>,
    @StringRes successMsgRes: Int? = null,
    @ColorRes colorRes: Int = R.color.color_white,
    listener: ((Result, T?) -> Unit)? = null
) =
    ButtonUtil.setupButtonProgress(
        button = this,
        activity = activity,
        lifecycle = lifecycle,
        actionLiveData = actionLiveData,
        successMsgRes = successMsgRes,
        colorRes = colorRes,
        listener = listener
    )

// set up with new label
fun <T> TextView.setup(
    activity: Activity?,
    actionLiveData: ActionLiveData<ActionData<T>>,
    @StringRes successMsgRes: Int? = null,
    @StringRes newLabelRes: Int? = null,
    @ColorRes colorRes: Int = R.color.color_white,
    listener: ((Result, T?) -> Unit)? = null
) =
    ButtonUtil.setupButtonProgress(
        button = this,
        activity = activity,
        actionLiveData = actionLiveData,
        successMsgRes = successMsgRes,
        newLabelRes = newLabelRes,
        colorRes = colorRes,
        listener = listener
    )
