/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.util

import android.content.Context
import android.graphics.PorterDuff
import android.graphics.PorterDuffColorFilter
import android.text.Spannable
import android.text.SpannableString
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.method.LinkMovementMethod
import android.text.style.ForegroundColorSpan
import android.view.View
import android.widget.TextView
import androidx.annotation.ColorRes
import androidx.annotation.StringRes
import androidx.core.content.ContextCompat
import androidx.swiperefreshlayout.widget.CircularProgressDrawable
import com.google.android.material.appbar.AppBarLayout
import com.google.android.material.appbar.CollapsingToolbarLayout
import com.netacom.base.chat.R

class ViewUtil {
    companion object {
        @JvmStatic
        fun getCircleProgressDrawable(
            context: Context,
            strokeWidthValue: Float = context.resources.getDimensionPixelOffset(R.dimen.dp_1).toFloat(),
            centerRadiusValue: Float = context.resources.getDimensionPixelOffset(R.dimen.dp_10).toFloat(),
            @ColorRes color: Int = R.color.colorPrimaryDark
        ): CircularProgressDrawable = CircularProgressDrawable(context).apply {
            strokeWidth = strokeWidthValue
            centerRadius = centerRadiusValue
            colorFilter = PorterDuffColorFilter(
                getThemeColor(color),
                PorterDuff.Mode.SRC_IN
            )
        }

        @JvmStatic
        fun setTextClickable(
            view: TextView,
            textRes: Int,
            clickableTextRes: Int,
            callback: (() -> Unit)?
        ) {
            val clickableText = view.context.getString(clickableTextRes)

            val ss = SpannableString(view.context.getString(textRes))
            view.text = ss

            val start = ss.indexOf(clickableText)
            if (start < 0 || start + clickableText.length >= ss.length) return

            ss.setSpan(
                object : MyClickableSpan() {
                    override fun onClick(view: View) {
                        callback?.invoke()
                    }
                },
                start,
                start + clickableText.length,
                Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
            )

            view.text = ss
            view.movementMethod = LinkMovementMethod.getInstance()
        }

        @JvmStatic
        fun setTextClickable(
            view: TextView,
            @StringRes textRes: Int,
            @StringRes clickableTextRes: Int,
            @StringRes clickableTextRes2: Int,
            callback: (() -> Unit)?,
            callback2: (() -> Unit)?
        ) {
            setTextClickable(
                view,
                view.context.getString(textRes),
                view.context.getString(clickableTextRes),
                view.context.getString(clickableTextRes2),
                callback,
                callback2
            )
        }

        @JvmStatic
        fun setTextClickable(
            view: TextView,
            text: String,
            clickableText: String,
            clickableText2: String,
            callback: (() -> Unit)?,
            callback2: (() -> Unit)?
        ) {
            val spannableString = SpannableStringBuilder(text)
            val length = spannableString.length
            val start = spannableString.indexOf(clickableText)
            if (start < 0 || start + clickableText.length > length) return
            spannableString.setSpan(
                object : MyClickableSpan() {
                    override fun onClick(view: View) {
                        callback?.invoke()
                    }
                },
                start,
                start + clickableText.length,
                Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
            )

            val start2 = spannableString.indexOf(clickableText2)
            if (start2 < 0 || start2 + clickableText2.length > length) return
            spannableString.setSpan(
                object : MyClickableSpan() {
                    override fun onClick(view: View) {
                        callback2?.invoke()
                    }
                },
                start2,
                start2 + clickableText2.length,
                Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
            )

            view.text = spannableString
            view.movementMethod = LinkMovementMethod.getInstance()
        }

        @JvmStatic
        fun formatTextValue(
            view: TextView,
            @StringRes labelRes: Int,
            value: String?,
            @ColorRes colorRes: Int
        ) {
            if (value.isNullOrEmpty()) {
                view.text = view.context.getString(labelRes, "")
            } else {
                val text = view.context.getString(labelRes, value)
                val spannable = SpannableString(text)
                val color = ContextCompat.getColor(view.context, colorRes)
                val index = text.length - value.length
                if (index > 0) {
                    spannable.setSpan(
                        ForegroundColorSpan(color),
                        index,
                        text.length,
                        Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                    )

                    view.setText(spannable, TextView.BufferType.SPANNABLE)
                }
            }
        }

        @JvmStatic
        fun disableCollapseToolbar(ctlCollapse: CollapsingToolbarLayout, isDisable: Boolean) {
            val params = ctlCollapse.layoutParams as AppBarLayout.LayoutParams
            if (isDisable) {
                params.scrollFlags = 0
            } else {
                params.scrollFlags =
                    AppBarLayout.LayoutParams.SCROLL_FLAG_SCROLL or AppBarLayout.LayoutParams.SCROLL_FLAG_EXIT_UNTIL_COLLAPSED
            }
            ctlCollapse.layoutParams = params
        }
    }
}
