/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.app

import android.content.Context
import android.content.Intent
import androidx.annotation.Keep
import androidx.hilt.work.HiltWorkerFactory
import androidx.work.Configuration
import com.google.android.gms.common.GoogleApiAvailability
import com.google.android.gms.security.ProviderInstaller
import com.netacom.base.chat.android_utils.AppUtils
import com.netacom.base.chat.app.BaseApplication
import com.netacom.base.chat.app.isProduction
import com.netacom.full.BuildConfig
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.ThemeUtils
import io.realm.Realm
import io.sentry.android.core.SentryAndroid
import io.sentry.android.core.SentryAndroidOptions
import javax.inject.Inject

/**Created by vantoan on 23,July,2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

@Keep
open class SDKApplication : BaseApplication(), Configuration.Provider/*, ImageLoaderFactory*/ {

    @Inject
    lateinit var themeHelperImpl: ThemeHelperImpl

    @Inject
    lateinit var workerFactory: HiltWorkerFactory

    override fun getWorkManagerConfiguration() =
        Configuration.Builder()
            .setWorkerFactory(workerFactory)
            .build()

    override fun attachBaseContext(base: Context?) {
        super.attachBaseContext(base)
        Realm.init(this)
    }

    override fun onCreate() {
        super.onCreate()
        initData()
        initTheme()
    }

    private fun initData() {
        initSentry()
        upgradeSecurityProvider()
    }

    private fun initTheme() {
        ThemeUtils.isDarkModeInSystem = ThemeUtils.isOsDarkTheme(this)
        ThemeUtils.enableDisplayMode(themeHelperImpl.displayMode)
    }

    private fun upgradeSecurityProvider() {
        ProviderInstaller.installIfNeededAsync(
            this,
            object : ProviderInstaller.ProviderInstallListener {
                override fun onProviderInstalled() {
                }

                override fun onProviderInstallFailed(errorCode: Int, recoveryIntent: Intent?) {
                    GoogleApiAvailability.getInstance().showErrorNotification(applicationContext, errorCode)
                }
            }
        )
    }

    private fun initSentry() {
        if (isProduction) {
            SentryAndroid.init(this) { options: SentryAndroidOptions ->
                options.dsn = "http://26d10fdab3674b20a8d54650b2777599@sentry.netalo.vn:9000/5"
                options.isEnableSessionTracking = isProduction
                options.isAnrReportInDebug = isProduction
                options.release = AppUtils.getAppVersionName()
                options.environment = BuildConfig.FLAVOR
            }
        }
    }

    /* override fun newImageLoader(): ImageLoader {
         return ImageLoader.Builder(this)
             *//*.availableMemoryPercentage(0.25)
            .crossfade(true)*//*
            .componentRegistry {
                add(VideoFrameFileFetcher(this@SDKApplication))
                add(VideoFrameUriFetcher(this@SDKApplication))
            }
            .build()
    }*/
}
