package com.netacom.full.basechat

import android.Manifest
import androidx.activity.result.contract.ActivityResultContracts
import androidx.databinding.ViewDataBinding
import com.fondesa.kpermissions.allGranted
import com.fondesa.kpermissions.anyPermanentlyDenied
import com.fondesa.kpermissions.extension.permissionsBuilder
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.android_utils.AppUtils
import com.netacom.base.chat.base.BaseDialogBottomFragment
import com.netacom.base.chat.base.BaseViewModel
import com.netacom.full.R
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.local.prefs.PreferencesHelperImpl
import javax.inject.Inject

abstract class BaseSDKBottomDialog<DB : ViewDataBinding, VM : BaseViewModel>(
    layoutID: Int,
    viewModelClass: Class<VM>
) : BaseDialogBottomFragment<DB, VM>(viewModelClass = viewModelClass, layoutID = layoutID) {

    @Inject
    lateinit var themeHelperImpl: ThemeHelperImpl

    @Inject
    lateinit var preferencesHelperImpl: PreferencesHelperImpl

    private val requestCamera by lazy {
        permissionsBuilder(Manifest.permission.CAMERA).build()
    }

    private val requestRecord by lazy {
        permissionsBuilder(Manifest.permission.RECORD_AUDIO).build()
    }

    private val requestCall by lazy {
        permissionsBuilder(Manifest.permission.CAMERA, Manifest.permission.RECORD_AUDIO).build()
    }

    private val requestStorage by lazy {
        permissionsBuilder(Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.WRITE_EXTERNAL_STORAGE).build()
    }

    private val requestContact by lazy {
        permissionsBuilder(Manifest.permission.READ_CONTACTS, Manifest.permission.WRITE_CONTACTS).build()
    }

    private val requestStorageAndroidR = registerForActivityResult(ActivityResultContracts.StartActivityForResult()) {
    }

    fun checkPermissionContact(callbackSuccess: () -> Unit, callbackDenied: () -> Unit) {
        try {
            requestContact.addListener {
                when {
                    it.allGranted() -> {
                        callbackSuccess()
                    }
                    it.anyPermanentlyDenied() -> {
                        showSnackBar(
                            R.string.permission_contact_denied, R.string.permission_open_setting,
                            {
                                AppUtils.launchAppDetailsSettings()
                            }
                        )
                    }
                    else -> {
                        showSnackBar(R.string.permission_contact_denied)
                        callbackDenied()
                    }
                }
            }
            requestContact.send()
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }

    fun checkPermissionCamera(callbackSuccess: () -> Unit, callbackDenied: () -> Unit) {
        try {
            requestCamera.addListener {
                when {
                    it.allGranted() -> {
                        callbackSuccess()
                    }
                    it.anyPermanentlyDenied() -> {
                        showSnackBar(
                            R.string.permission_camera_denied, R.string.permission_open_setting,
                            {
                                AppUtils.launchAppDetailsSettings()
                            }
                        )
                    }
                    else -> {
                        showSnackBar(R.string.permission_camera_denied)
                        callbackDenied()
                    }
                }
            }
            requestCamera.send()
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }

    fun checkPermissionRecordAudio(callbackSuccess: () -> Unit, callbackDenied: () -> Unit) {
        try {
            requestRecord.addListener {
                when {
                    it.allGranted() -> {
                        callbackSuccess()
                    }
                    it.anyPermanentlyDenied() -> {
                        showSnackBar(
                            R.string.permission_record_denied, R.string.permission_open_setting,
                            {
                                AppUtils.launchAppDetailsSettings()
                            }
                        )
                    }
                    else -> {
                        showSnackBar(R.string.permission_record_denied)
                        callbackDenied()
                    }
                }
            }
            requestRecord.send()
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }

    fun checkPermissionCall(callbackSuccess: () -> Unit, callbackDenied: () -> Unit) {
        try {
            requestCall.addListener {
                when {
                    it.allGranted() -> {
                        callbackSuccess()
                    }
                    it.anyPermanentlyDenied() -> {
                        showSnackBar(
                            R.string.permission_camera_denied, R.string.permission_open_setting,
                            {
                                AppUtils.launchAppDetailsSettings()
                            }
                        )
                    }
                    else -> {
                        showSnackBar(R.string.permission_camera_denied)
                        callbackDenied()
                    }
                }
            }
            requestCall.send()
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }

    fun checkPermissionStorage(callbackSuccess: () -> Unit, callbackDenied: () -> Unit) {
        try {
           /* if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
                if (!Environment.isExternalStorageManager()) {
                    DialogUtil.show(
                        context = requireContext(),
                        titleStr = getString(R.string.permission_storage_title),
                        messageStr = getString(R.string.permission_storage_desc),
                        cancelLabel = R.string.str_cancel,
                        okLabel = R.string.popup_confirm_logout_ok,
                        okFunc = {
                            try {
                                val intent = Intent(Settings.ACTION_MANAGE_APP_ALL_FILES_ACCESS_PERMISSION)
                                intent.addCategory("android.intent.category.DEFAULT")
                                intent.data = Uri.parse("package:${AppUtils.getAppPackageName()}")
                                requestStorageAndroidR.launch(intent)
                            } catch (e: java.lang.Exception) {
                                val intent = Intent()
                                intent.action = Settings.ACTION_MANAGE_ALL_FILES_ACCESS_PERMISSION
                                requestStorageAndroidR.launch(intent)
                            }
                        },
                        themeHelperImpl = themeHelperImpl
                    )
                } else {
                    callbackSuccess()
                }
            } else {
                requestStorage.addListener {
                    when {
                        it.allGranted() -> {
                            callbackSuccess()
                        }
                        it.anyPermanentlyDenied() -> {
                            showSnackBar(
                                R.string.permission_storage_denied, R.string.permission_open_setting,
                                {
                                    AppUtils.launchAppDetailsSettings()
                                }
                            )
                        }
                        else -> {
                            showSnackBar(R.string.permission_storage_denied)
                            callbackDenied()
                        }
                    }
                }
                requestStorage.send()
            }*/
            requestStorage.addListener {
                when {
                    it.allGranted() -> {
                        callbackSuccess()
                    }
                    it.anyPermanentlyDenied() -> {
                        showSnackBar(
                            R.string.permission_storage_denied, R.string.permission_open_setting,
                            {
                                AppUtils.launchAppDetailsSettings()
                            }
                        )
                    }
                    else -> {
                        showSnackBar(R.string.permission_storage_denied)
                        callbackDenied()
                    }
                }
            }
            requestStorage.send()
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }
}
