/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.databinding

import androidx.databinding.BindingAdapter
import androidx.recyclerview.widget.RecyclerView
import com.netacom.full.ui.main.contact.ContactUtils
import com.netacom.full.ui.main.contact.adapter.ContactAdapter
import com.netacom.full.ui.main.contact.adapter.RecentContactAdapter
import com.netacom.full.ui.main.group.adapter.ListGroupAdapter
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.entity.ui.user.NeUser

@BindingAdapter("adapterListGroup")
fun bindAdapterListGroup(view: RecyclerView, listNeGroup: List<NeGroup>?) {
    listNeGroup?.let {
        (view.adapter as? ListGroupAdapter)?.display(it)
    }
}

@BindingAdapter("adapterListContact")
fun bindAdapterListContact(view: RecyclerView, listNeContact: List<NeUser>?) {
    listNeContact?.let {
        (view.adapter as? ContactAdapter)?.display(
            ContactUtils.sortContacts(sortBy = ContactUtils.SORT_BY_NAME, listContacts = it)
        )
    }
}

@BindingAdapter("adapterRecentContact")
fun bindAdapterListRecentContact(view: RecyclerView, listNeUser: List<NeUser>?) {
    listNeUser?.let {
        (view.adapter as? RecentContactAdapter)?.display(listNeUser)
    }
}
