/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.databinding

import android.view.View
import android.widget.TextView
import androidx.annotation.ColorRes
import androidx.annotation.DrawableRes
import androidx.appcompat.widget.AppCompatImageView
import androidx.core.content.ContextCompat
import androidx.databinding.BindingAdapter
import com.netacom.base.chat.imageloader.loadAvatar
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.util.getThemeColor
import com.netacom.full.R
import com.netacom.full.define.MessagePosition
import com.netacom.full.widget.avatar.AvatarView
import kotlin.math.truncate

val bgColors = arrayOf(
    R.color.color_pink_ed6494,
    R.color.color_blue_65d5d1,
    R.color.color_blue_1ba8d6,
    R.color.color_orange_efae62,
    R.color.color_green_5bbc43,
    R.color.color_red_ef5b54,
    R.color.color_purple_b27cd3,
    R.color.color_orange_fa944a
)

@BindingAdapter(value = ["receiverNameColor", "avatarPosition"], requireAll = false)
fun TextView.receiverNameColor(color: Int, messagePosition: MessagePosition? = null) {
    /*messagePosition?.let { _messagePosition ->
        isVisible = _messagePosition == MessagePosition.TOP
        if (isGone)
            return
    }*/
    if (color >= 0 && color < bgColors.size) {
        setTextColor(ContextCompat.getColor(context, bgColors[color]))
    }
}

@BindingAdapter(value = ["imgAvatar", "imgText", "imgTextSize", "isOnline", "avatarBorderColor", "avatarPosition", "applyRoundCorner", "isAvaHolder"], requireAll = false)
fun AvatarView.loadImageAvatar(
    imgUrl: Any?,
    name: String?,
    imgTextSize: Float?,
    isOnline: Boolean = false,
    index: Int? = null,
    messagePosition: MessagePosition? = null,
    applyRoundCorner: Boolean = false,
    isAvaHolder: Boolean = false
) {
    messagePosition?.let { _messagePosition ->
        visibility = if (_messagePosition == MessagePosition.SINGLE || _messagePosition == MessagePosition.BOTTOM) {
            View.VISIBLE
        } else {
            View.INVISIBLE
        }
    }
    imgTextSize?.let {
        textSize = it
    }
    index?.let {
        if (index < 0) {
            isBorder = true
            ContextCompat.getColor(context, bgColors[0])
        }
        if (index >= 0 && index <= bgColors.size) {
            isBorder = true
            borderColor = ContextCompat.getColor(context, bgColors[index])
        } else if (index > bgColors.size) {
            isBorder = true
            borderColor = ContextCompat.getColor(context, index)
        }
    }
    showBadge = isOnline
    if (imgUrl != null) {
        this.loadAvatar(imgUrl)
    } else if (!name.isNullOrEmpty()) {
        if (isAvaHolder) {
            this.loadImage(R.drawable.ic_avatar_default)
        } else {
            text = name
            val b = text.toString().first().toByte()
            val len = bgColors.size
            val d = b / len.toDouble()
            val colorIndex = ((d - truncate(d)) * len).toInt()
            if (colorIndex >= 0 && colorIndex <= bgColors.size) {
                avatarBackgroundColor = ContextCompat.getColor(context, bgColors[colorIndex])
            } else if (colorIndex > bgColors.size) {
                avatarBackgroundColor = ContextCompat.getColor(context, bgColors[colorIndex])
            }
        }
    }
    setup()
}

@BindingAdapter(value = ["isPin", "pinColor"])
fun View.pinBackground(isPin: Boolean, @ColorRes pinColor: Int) {
    setBackgroundColor(if (isPin) getThemeColor(pinColor) else ContextCompat.getColor(context, R.color.color_background))
}

@BindingAdapter("srcCompat")
fun AppCompatImageView.srcCompat(@DrawableRes resId: Int = -1) {
    if (resId != -1) loadImage(resId)
}
