/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.dispatchers

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import javax.inject.Inject

class MainDispatcher<T>
@Inject constructor() : Dispatcher<T> {

    private val _event: MutableLiveData<OneTimeEvent<T>> = MutableLiveData()
    override val event: LiveData<OneTimeEvent<T>>
        get() = _event

    override fun emit(event: T) {
        _event.postValue(OneTimeEvent(event))
    }
}
