/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.extensions

import android.content.Context
import android.database.Cursor
import android.provider.ContactsContract
import com.netacom.lite.entity.ui.contact.LocalContactInfo
import java.util.regex.Pattern

const val PHONE_REGEX_NORMAL = "^[0-9]{10,13}\$"
const val PHONE_REGEX_GLOBAL_FULL = "^([\\+]?84)?[0-9]{9}\$"
const val PHONE_REGEX_GLOBAL = "^([8]4)?[0-9]{9}\$"

fun String.convertPhoneNumber(): String? {
    val first: String = this.substring(0, 1)
    return if (this.checkPhone() && this.length >= 10) {
        when (first) {
            "0" -> {
                val stringSplit = this.substringAfter("0")
                "+84$stringSplit"
            }
            "8" -> "+$this"
            else -> this
        }
    } else return null
}

fun String.checkPhone(): Boolean {
    if (this.isEmpty()) return false
    else {
        return when (this.substring(0, 1)) {
            "0" -> {
                val pattern = Pattern.compile(PHONE_REGEX_NORMAL)
                pattern.matcher(this).matches()
            }
            "+" -> {
                val pattern = Pattern.compile(PHONE_REGEX_GLOBAL_FULL)
                pattern.matcher(this).matches()
            }
            "8" -> {
                val pattern = Pattern.compile(PHONE_REGEX_GLOBAL)
                pattern.matcher(this).matches()
            }
            else -> false
        }
    }
}

fun Context.getContactName(): ArrayList<LocalContactInfo> {
    val startTime = System.currentTimeMillis()
    val contactsList = ArrayList<LocalContactInfo>()
    val contactsCursor = this.contentResolver?.query(
        ContactsContract.Contacts.CONTENT_URI,
        null,
        null,
        null,
        ContactsContract.CommonDataKinds.Phone.DISPLAY_NAME + " ASC"
    )
    if (contactsCursor != null && contactsCursor.count > 0) {
        while (contactsCursor.moveToNext()) {
            val hasPhoneNumber =
                contactsCursor.getString(
                    contactsCursor.getColumnIndex(ContactsContract.Contacts.HAS_PHONE_NUMBER)
                )
                    .toInt()
            if (hasPhoneNumber > 0) {
                val idIndex = contactsCursor.getColumnIndex(ContactsContract.Contacts._ID)
                val nameIndex =
                    contactsCursor.getColumnIndex(ContactsContract.Contacts.DISPLAY_NAME)
                val id = contactsCursor.getString(idIndex)
                val name = contactsCursor.getString(nameIndex)
                name?.let {
                    contactsList.add(LocalContactInfo(id = id, contactName = it))
                }
            }
        }
        contactsCursor.close()
    }
    return contactsList
}

fun Context.getContactNumbers(): HashMap<String, ArrayList<String>> {
    val startTime = System.currentTimeMillis()
    val contactNumbers = HashMap<String, ArrayList<String>>()
    val phoneCursor: Cursor? = this.contentResolver.query(
        ContactsContract.CommonDataKinds.Phone.CONTENT_URI,
        null,
        null,
        null,
        null
    )
    if (phoneCursor != null && phoneCursor.count > 0) {
        val contactIdIndex =
            phoneCursor.getColumnIndex(ContactsContract.CommonDataKinds.Phone.CONTACT_ID)
        val numberIndex =
            phoneCursor.getColumnIndex(ContactsContract.CommonDataKinds.Phone.NUMBER)
        while (phoneCursor.moveToNext()) {
            val contactId = phoneCursor.getString(contactIdIndex)
            val number: String = phoneCursor.getString(numberIndex)
            // check if the map contains key or not, if not then create a new array list with number
            if (contactNumbers.containsKey(contactId)) {
                contactNumbers[contactId]?.add(number)
            } else {
                contactNumbers[contactId] = arrayListOf(number)
            }
        }
        // contact contains all the number of a particular contactß
        phoneCursor.close()
    }
    return contactNumbers
}
