/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.hilt

import androidx.navigation.NavController
import com.netacom.full.dispatchers.Dispatcher
import com.netacom.full.dispatchers.MainDispatcher
import dagger.Binds
import dagger.Module
import dagger.hilt.InstallIn
import dagger.hilt.android.components.ActivityRetainedComponent
import dagger.hilt.android.scopes.ActivityRetainedScoped

@Module
@InstallIn(ActivityRetainedComponent::class)
abstract class NavigationModule {
    @ActivityRetainedScoped
    @Binds
    abstract fun bindNavigationDispatcher(mainDispatcher: MainDispatcher<(NavController) -> Unit>): Dispatcher<(NavController) -> Unit>
}
