/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.login

import androidx.navigation.NavController
import androidx.navigation.findNavController
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKActivity
import com.netacom.full.databinding.ActivityAuthBinding
import com.netacom.full.dispatchers.Dispatcher
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.ObsoleteCoroutinesApi
import javax.inject.Inject

/**
Created by vantoan on 28,July,2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

@AndroidEntryPoint
class LoginActivity : BaseSDKActivity<ActivityAuthBinding, LoginViewModel>(R.layout.activity_auth, LoginViewModel::class.java) {
    @Inject
    lateinit var navigationDispatcher: Dispatcher<(NavController) -> Unit>

    override fun setViewModel(): Int = BR.viewModel

    private val navController by lazy {
        findNavController(R.id.nav_auth)
    }

    override fun initViews() {
        navigationDispatcher.event.observe { event ->
            event.consume { command ->
                command(navController)
            }
        }
    }

    override fun initData() {
    }

    override fun onSupportNavigateUp(): Boolean = navController.navigateUp()

    @ObsoleteCoroutinesApi
    override fun onBackPressed() {
        when (navController.currentDestination?.id) {
            R.id.loginFragment -> finish()
            R.id.profileUpdateFragment -> finish()
            R.id.otpFragment -> moveTaskToBack(true)
            else -> super.onBackPressed()
        }
    }
}
