/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.login

import androidx.core.view.isVisible
import androidx.core.widget.doAfterTextChanged
import com.netacom.base.chat.android_utils.KeyboardUtils
import com.netacom.base.chat.android_utils.RegexUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.setup
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKDataFragment
import com.netacom.full.databinding.FragmentLoginBinding
import com.netacom.full.extensions.setFocusable
import dagger.hilt.android.AndroidEntryPoint

/**
Created by vantoan on 03/Aug/2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

@AndroidEntryPoint
class LoginFragment : BaseSDKDataFragment<FragmentLoginBinding, LoginViewModel>(
    R.layout.fragment_login,
    LoginViewModel::class.java
) {

    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        with(binding) {
            editPhoneNumber.setFocusable()
            view?.apply {
                KeyboardUtils.showSoftInput(this)
            }
            editPhoneNumber.doAfterTextChanged {
                it ?: return@doAfterTextChanged
                imgClear.isVisible = it.isNotEmpty()
                btnContinue.isEnabled = it.length > 9 && RegexUtils.isTel(it.toString())
            }

            imgClear.clickDebounce {
                editPhoneNumber.setText("")
            }
            btnContinue.setup(
                activity = activity,
                actionLiveData = this@LoginFragment.viewModel.loginAction,
                successMsgRes = R.string.phone_success
            ) { result, _ ->
                when (result) {
                    com.netacom.base.chat.type.Result.DOING -> { }
                    com.netacom.base.chat.type.Result.SUCCESS -> this@LoginFragment.viewModel.openMain()
                    com.netacom.base.chat.type.Result.FAIL -> view?.apply {
                        val message = if (this@LoginFragment.viewModel.loginAction.value?.isSuccess == false) {
                            this@LoginFragment.viewModel.loginAction.value?.message.toString()
                        } else {
                            getString(R.string.popup_confirm_your_phone)
                        }
                        showSnackBar(message)
                    }
                }
            }
        }
    }

    override fun initData() {
        viewModel.getSession()
    }

    override fun syncEvent() {
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(editPhoneNumber)
            themeHelperImpl.setThemeStateListForButtonAction(btnContinue)
        }
    }
}
