/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.login

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.navigation.NavController
import com.netacom.base.chat.base.ActionData
import com.netacom.base.chat.base.ActionLiveData
import com.netacom.base.chat.base.BaseViewModel
import com.netacom.base.chat.model.ScreenStateObj
import com.netacom.base.chat.network.ApiResponseSuccess
import com.netacom.full.dispatchers.Dispatcher
import com.netacom.full.extensions.navigateIfSafe
import com.netacom.lite.hilt.executor.PostExecutionThread
import com.netacom.lite.repository.AuthRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.collect
import javax.inject.Inject

/**
Created by vantoan on 28,July,2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/
@HiltViewModel
class LoginViewModel @Inject constructor(
    private val authRepository: AuthRepository,
    private val postExecutionThread: PostExecutionThread,
    private val navigationDispatcher: Dispatcher<(NavController) -> Unit>
) : BaseViewModel() {
    val screenState: LiveData<ScreenStateObj> = MutableLiveData()
    val loginAction: ActionLiveData<ActionData<String>> = ActionLiveData()

    fun getSession() {
        launchOnViewModelScope(postExecutionThread.io) {
            authRepository.getAppToken().collect()
        }
    }

    fun clickOpenOTP(phoneNumber: String) {
        loginAction.setDoing()
        launchOnViewModelScope(postExecutionThread.io) {
            authRepository.login(phoneNumber).collect {
                if (it is ApiResponseSuccess) {
                    loginAction.postSuccess()
                } else {
                    loginAction.postErrorMsg(it.message)
                }
            }
        }
    }

    fun openMain() {
        navigationDispatcher.emit {
            it.navigateIfSafe(LoginFragmentDirections.openOtp())
        }
    }
}
