/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.login.otp

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.navigation.NavController
import com.netacom.base.chat.base.BaseViewModel
import com.netacom.base.chat.livedata.EventLiveData
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.model.ScreenStateObj
import com.netacom.base.chat.network.ApiResponseSuccess
import com.netacom.base.chat.type.OtpStatusCode
import com.netacom.base.chat.type.ScreenState
import com.netacom.full.dispatchers.Dispatcher
import com.netacom.full.extensions.navigateIfSafe
import com.netacom.lite.hilt.executor.PostExecutionThread
import com.netacom.lite.local.prefs.PreferencesHelperImpl
import com.netacom.lite.repository.AuthRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.collect
import javax.inject.Inject

/**
Created by vantoan on 03/Aug/2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/
@HiltViewModel
class OtpViewModel @Inject constructor(
    private val authRepository: AuthRepository,
    private val preferencesHelperImpl: PreferencesHelperImpl,
    private val postExecutionThread: PostExecutionThread,
    private val navigationDispatcher: Dispatcher<(NavController) -> Unit>
) : BaseViewModel() {
    val screenState: LiveData<ScreenStateObj> = MutableLiveData()

    private val _enableRetry = MutableLiveData<EventLiveData<Boolean>>()
    val enableRetry: LiveData<EventLiveData<Boolean>> = _enableRetry

    private val _timeOutOtp = MutableLiveData<EventLiveData<Unit>>()
    var timeOutOtp: LiveData<EventLiveData<Unit>> = _timeOutOtp

    private val _errorOtp = MutableLiveData<EventLiveData<Unit>>()
    val errorOtp: LiveData<EventLiveData<Unit>> = _errorOtp
    val otps = CharArray(6)
    val RESEND_OTP_TIMEOUT = 180
    var checkTimeout = false

    fun getPhone() = (preferencesHelperImpl.user?.getPhone?.replaceRange(3, 7, "*****") ?: preferencesHelperImpl.user?.getPhone ?: "")

    fun resendOtp() {
        screenState.setDoing()
        launchOnViewModelScope(postExecutionThread.io) {
            authRepository.reSendOtp().collect {
                if (it is ApiResponseSuccess) {
                    screenState.postData()
                    retryOtp(isRetry = false)
                } else {
                    screenState.postError(it.message)
                }
            }
        }
    }

    fun confirmRegisterOTP(callbackSuccessNewUser: () -> Unit, callbackSuccessOldUser: () -> Unit) {
        if (!otps.contains('\u0000') && !checkTimeout) {
            screenState.setDoing()
            launchOnViewModelScope(postExecutionThread.io) {
                authRepository.confirmRegisterOTP(String(otps)).collect {
                    if (it is ApiResponseSuccess) {
                        when (it.data?.code) {
                            OtpStatusCode.OLD_USER.value -> getSessionForLogin(
                                it.data?.dataLogin?.token!!,
                                callbackSuccessOldUser
                            )
                            OtpStatusCode.NEW_USER.value -> getSessionForRegister(
                                it.data?.dataLogin?.token!!,
                                callbackSuccessNewUser
                            )
                        }
                    } else {
                        screenState.postData()
                        _errorOtp.post(EventLiveData(Unit))
                    }
                }
            }
        } else {
            _timeOutOtp.post(EventLiveData(Unit))
        }
    }

    private suspend fun getSessionForLogin(token: String, callbackSuccess: () -> Unit) {
        authRepository.getSessionForChangeProfile(token).collect {
            if (it is ApiResponseSuccess) {
                Logger.e("tokenLogin: ${it.data?.token!!}")
                getProfileRegister(it.data?.token!!, it.data?.user_id.toString())
                navigationDispatcher.emit { _ ->
                    screenState.post(ScreenStateObj(state = ScreenState.OTHER))
                    callbackSuccess()
                }
            } else {
                screenState.postError(it.message)
            }
        }
    }

    private suspend fun getSessionForRegister(token: String, callbackSuccess: () -> Unit) {
        authRepository.getSessionForChangeProfile(token).collect {
            if (it is ApiResponseSuccess) {
                getProfileRegister(it.data?.token!!, it.data?.user_id.toString())
                navigationDispatcher.emit { _ ->
                    screenState.postData()
//                    createChatSecretKey()
                    callbackSuccess()
                }
            } else {
                screenState.postError(it.message)
            }
        }
    }

    private suspend fun getProfileRegister(userToken: String, userId: String) {
        authRepository.getProfile(token = userToken, userId = userId).collect {
            if (it is ApiResponseSuccess) {
                screenState.postData()
            } else {
                screenState.postError(it.message)
            }
        }
    }

    fun retryOtp(isRetry: Boolean) {
        _enableRetry.post(EventLiveData(isRetry))
    }

    fun openUpdateProfile() {
        navigationDispatcher.emit {
            it.navigateIfSafe(OtpFragmentDirections.openUpdateProfile(isNewUser = true))
        }
    }

    fun onBack() {
        navigationDispatcher.emit {
            retryOtp(false)
            it.popBackStack()
        }
    }
}
