package com.netacom.full.ui.main.call

import com.netacom.base.chat.android_utils.LanguageUtils
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.type.ScreenState
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseCoreCallCameraFragment
import com.netacom.full.databinding.FragmentBaseCallLogsBinding
import com.netacom.full.ui.main.call.adapter.CallLogAdapter
import com.netacom.full.widget.EmptyView
import com.netacom.lite.define.CallDefine

open class BaseCallLogCameraFragment : BaseCoreCallCameraFragment<FragmentBaseCallLogsBinding, CallLogViewModel>(
    R.layout.fragment_base_call_logs,
    CallLogViewModel::class.java
) {
    private lateinit var callLogAdapter: CallLogAdapter
    protected var isMissCall = false
    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        with(binding.rcvCallLogs) {
            setHasFixedSize(true)
            callLogAdapter = CallLogAdapter(
                user = viewModel.getUser,
                languageApp = LanguageUtils.getLanguage(),
                themeHelperImpl = themeHelperImpl,
                infoClick = { item ->
                    viewModel.gotoChatInfoDialog(
                        item,
                        callbackError = {
                            showSnackBar(getString(R.string.text_error_show_user_info))
                        }
                    )
                },
                removeClick = { item ->
                    viewModel.deletedCallLogs(item, isMissCall)
                },
                itemClick = { item, _, _ ->
                    Logger.e("TAG_contactAdapter Item Click")
                    item.calleeIds?.firstOrNull { it.toLongOrNull() != viewModel.getUserId }?.let {
                        checkCall(it.toLongOrNull(), item.mediaType == CallDefine.MEDIA_TYPE_VIDEO)
                    }
                },
            )
            adapter = callLogAdapter

            if (viewModel.cacheCallLogs.first >= 0 && viewModel.cacheCallLogs.second != null) {
                callLogAdapter.display(viewModel.cacheCallLogs.second ?: emptyList())
            }
        }
    }

    override fun initData() {
        viewModel.contactChange.observeOnce { isChanged ->
            if (isChanged) {
                syncEvent()
            }
        }
        viewModel.callLogScreenState.observe { state ->
            if (state.state == ScreenState.EMPTY) {
                if (callLogAdapter.getData.isEmpty()) {
                    binding.emptyView.setEmptyState()
                }
            } else {
                binding.emptyView.setScreenState(state)
            }
        }
        viewModel.groupCallLogs.observeOnce { listCallLogs ->
            binding.swipeLayout.isRefreshing = false
            // Logger.e("listCallLogs=" + listCallLogs.map { it })
            viewModel.cacheCallLogs = viewModel.cacheCallLogs.copy(second = listCallLogs)
            callLogAdapter.display(listCallLogs)
            if (listCallLogs.isEmpty()) {
                binding.emptyView.setEmptyState()
            }
        }
        binding.emptyView.newActionListener = object : EmptyView.NewActionListener {
            override fun onStartNewAction() {
                viewModel.gotoNewCallDialog()
            }
        }
    }

    override fun syncEvent() {
        binding.swipeLayout.setOnRefreshListener {
            viewModel.getCallLogs(isMissCall)
        }
        callEvent()
    }

    override fun setupTheme() {
    }
}
