/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.call

import androidx.core.content.ContextCompat
import androidx.core.view.isGone
import androidx.fragment.app.Fragment
import androidx.fragment.app.commit
import com.google.android.material.tabs.TabLayout
import com.netacom.base.chat.type.ScreenState
import com.netacom.base.chat.util.getThemeColor
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseCoreCallCameraFragment
import com.netacom.full.databinding.FragmentCallLogBinding
import dagger.hilt.android.AndroidEntryPoint

/**
Created by vietnguyen on 05/Oct/2020
Company: Netacom.
Email: vietnt@netacom.vn
 **/

@AndroidEntryPoint
class CallLogCameraFragment :
    BaseCoreCallCameraFragment<FragmentCallLogBinding, CallLogViewModel>(
        R.layout.fragment_call_log,
        CallLogViewModel::class.java
    ) {
    private var isTabAll = true
    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        with(binding.tabLayout) {
            setTabTextColors(ContextCompat.getColor(requireContext(), R.color.color_grey_959595), getThemeColor(themeHelperImpl.mainColor))
            addOnTabSelectedListener(
                object : TabLayout.OnTabSelectedListener {
                    override fun onTabSelected(tab: TabLayout.Tab?) {
                        viewModel.cacheCallLogs = viewModel.cacheCallLogs.copy(first = tab?.position ?: 0)
                        when (tab?.position) {
                            0 -> addFragment(CallAllCameraFragment.newInstance())
                            1 -> addFragment(CallMissCameraFragment.newInstance())
                        }
                    }

                    override fun onTabUnselected(tab: TabLayout.Tab?) {
                    }

                    override fun onTabReselected(tab: TabLayout.Tab?) {
                    }
                }
            )
            if (viewModel.cacheCallLogs.first >= 0) {
                getTabAt(viewModel.cacheCallLogs.first)?.select()
                when (viewModel.cacheCallLogs.first) {
                    0 -> addFragment(CallAllCameraFragment.newInstance())
                    1 -> addFragment(CallMissCameraFragment.newInstance())
                }
            } else {
                viewModel.cacheCallLogs = viewModel.cacheCallLogs.copy(first = 0)
                addFragment(CallAllCameraFragment.newInstance())
            }
        }
    }

    private fun addFragment(fragment: Fragment) {
        isTabAll = fragment::class.java.simpleName == CallAllCameraFragment::class.java.simpleName
        activity?.supportFragmentManager?.commit {
            setReorderingAllowed(true)
            replace(R.id.fragmentCall, fragment)
        }
    }

    override fun initData() {
        viewModel.callLogScreenState.observe {
            if (isTabAll) {
                binding.flTabLayout.isGone = it.state == ScreenState.EMPTY
            }
        }
    }

    override fun syncEvent() {
        binding.toolbar.setOnRightClickListener {
            viewModel.gotoNewCallDialog()
        }
    }

    override fun setupTheme() {
        themeHelperImpl.setThemeColorForViews(
            binding.toolbar
        )
        if (themeHelperImpl.isDarkMode) {
            themeHelperImpl.setThemeColorForViews(binding.toolbar.getButtonRight()!!)
        }
    }
}
