package com.netacom.full.ui.main.call

import com.netacom.base.chat.android_utils.LanguageUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.logger.Logger
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.PopupViewAllCallLogBinding
import com.netacom.full.ui.main.call.adapter.CallLogAdapter
import com.netacom.full.ui.main.group.GroupViewModel
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class CallLogsByUserDialog : BaseSDKBottomDialog<PopupViewAllCallLogBinding, GroupViewModel>(
    R.layout.popup_view_all_call_log,
    GroupViewModel::class.java
) {

    private lateinit var callLogsAdapter: CallLogAdapter

    override fun setViewModel(): Int = BR.viewModel

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun initViews() {
        binding.icClose.clickDebounce {
            dismiss()
        }

        with(binding.recyclerView) {
            setHasFixedSize(true)
            callLogsAdapter = CallLogAdapter(
                user = viewModel.getUser,
                languageApp = LanguageUtils.getLanguage(),
                isCallLogDetail = true,
                themeHelperImpl = themeHelperImpl,
                infoClick = {},
                removeClick = {},
                itemClick = { item, _, _ ->
                    Logger.d("CallLogAdapter Item Click $item")
                }
            )
            viewModel.callLogsSortedByUser.observe { callLogs -> callLogsAdapter.display(callLogs.peekContent()) }
            adapter = callLogsAdapter
        }
    }

    override fun initData() {
    }

    override fun setupTheme() {
    }
}
