package com.netacom.full.ui.main.call

import android.text.Editable
import android.text.TextWatcher
import android.view.View
import androidx.core.view.isVisible
import androidx.core.widget.addTextChangedListener
import androidx.fragment.app.activityViewModels
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.network.ResultData
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseCoreCallCameraBottomDialog
import com.netacom.full.databinding.ViewNewCallPopupBinding
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.ui.main.contact.ContactUtils
import com.netacom.full.ui.main.contact.ContactViewModel
import com.netacom.full.ui.main.contact.adapter.ContactAdapter
import com.netacom.lite.define.SyncType
import com.netacom.lite.util.Constants
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
Created by vietnguyen on 7/Oct/2020
Company: Netacom.
Email: vietnt@netacom.vn
 **/
@AndroidEntryPoint
class NewCallDialog :
    BaseCoreCallCameraBottomDialog<ViewNewCallPopupBinding, CallLogViewModel>(
        R.layout.view_new_call_popup,
        CallLogViewModel::class.java
    ) {

    private lateinit var contactAdapter: ContactAdapter

    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()

    private val contactViewModel: ContactViewModel by viewModels()

    override fun setViewModel(): Int = BR.viewModel

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun initViews() {

        contactAdapter = ContactAdapter(
            { item, _, _ ->
            },
            { neContact ->
                /**
                 * Make the Audio Call
                 */
                neContact.id?.let { receiverId ->
                    checkCall(receiverId, isVideoEnable = false)
                } ?: let {
                    // TODO
                    // Will be show the Alert dialog or Toast to inform the error.
                }
            },
            { neContact ->
                /**
                 * Make the Video Call
                 */
                neContact.id?.let { receiverId ->
                    checkCall(receiverId, isVideoEnable = true)
                } ?: let {
                    // TODO
                    // Will be show the Alert dialog or Toast to inform the error.
                }
            },
            ContactAdapter.CONTACT_TYPE_MAIN,
            emptyCallBack = { isEmpty ->
                if (isEmpty) {
                    binding.tvEmpty.isVisible = true
                }
            }
        )

        binding.recyclerView.adapter = contactAdapter

        binding.icClose.clickDebounce {
            dismiss()
        }

        binding.icClear.clickDebounce {
            lifecycleScope.launch {
                binding.editSearch.setText("")
            }
        }

        binding.editSearch.addTextChangedListener {
            it ?: return@addTextChangedListener
            binding.icClear.visibility = if (it.isEmpty()) View.GONE else View.VISIBLE
        }

        binding.editSearch.addTextChangedListener(
            object : TextWatcher {
                private var searchFor = Constants.EMPTY
                override fun beforeTextChanged(
                    s: CharSequence?,
                    start: Int,
                    before: Int,
                    count: Int
                ) {
                }

                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                    val searchText = s.toString().trim()
                    if (searchText == searchFor) {
                        return
                    }

                    searchFor = searchText

                    lifecycleScope.launch {
                        delay(500) // debounce timeOut
                        if (searchText != searchFor) {
                            return@launch
                        }
                        searchLocalContact(filter = searchFor.trim())

                        contactAdapter.filter(
                            filterBy = searchFor,
                            lifecycleScope = lifecycleScope
                        )
                    }
                }

                override fun afterTextChanged(p0: Editable?) {}
            }
        )
    }

    override fun initData() {

        viewModel.contactChange.observeOnce { isChanged ->
            if (isChanged) {
                mainSdkViewModel.syncContact(SyncType.LIST_SYNC_DB)
            }
        }

        checkPermissionContact(
            {
                mainSdkViewModel.syncContact(SyncType.LIST_SYNC_DB)
                viewModel.listenerContactChange(requireContext())
            },
            {
                Logger.e("callbackDenied")
            }
        )
        mainSdkViewModel.listContact.observeOnce {
            contactAdapter.display(
                ContactUtils.sortContacts(sortBy = ContactUtils.SORT_BY_NAME, listContacts = it)
            )
        }

        contactViewModel.startCallingScreen.observeOnce { resultData ->
            when (resultData) {
                is ResultData.Success -> {
                    resultData.data?.let { _neGroup ->
                        viewModel.makeCall(_neGroup, _neGroup.isCallVideo)
                    }
                }
                else -> Unit
            }
        }

        // viewModel.neUserStatusLiveData.observe(
        //     this,
        //     Observer {
        //         it ?: return@Observer
        //         newCallAdapter.updateUserStatus(
        //             userStatus = it,
        //             lifecycleScope = lifecycleScope
        //         )
        //         viewModel.neUserStatusLiveData.postValue(null)
        //     }
        // )

        // mainSdkViewModel.userStatus.observe { userStatus ->
        //     for ((i, neGroup) in groupAdapter.getListData().withIndex()) {
        //         if (neGroup.type == GroupType.GROUP_TYPE_PUBLIC && neGroup.members?.firstOrNull { neMember -> neMember.id == userStatus.uin } != null) {
        //             neGroup.isOnline = userStatus.onlineStatus == UserStatusDefine.STATUS_ONLINE.toInt()
        //             groupAdapter.notifyItemChanged(i, neGroup)
        //             break
        //         }
        //     }
        // }
    }

    override fun setupTheme() {
    }

    /**
     * WAITING!!!!  Need to discuss with the iOS team to find out the final solution
     */
    private fun searchLocalContact(filter: String) {
    }
}
