/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.calling

import android.animation.Animator
import android.annotation.SuppressLint
import android.content.Context
import android.hardware.Sensor
import android.hardware.SensorEvent
import android.hardware.SensorEventListener
import android.hardware.SensorManager
import android.view.MotionEvent
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.AppCompatImageView
import androidx.constraintlayout.widget.Group
import androidx.core.view.isVisible
import androidx.lifecycle.LifecycleCoroutineScope
import com.netacom.base.chat.logger.Logger
import com.netacom.full.extensions.fadeIn
import com.netacom.full.extensions.fadeOut
import com.netacom.lite.R
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch
import java.util.Timer
import java.util.TimerTask

/**
 * Created by Tam Nguyen on 9/11/20.
 */

object CallingUtils {

    var isOnCall = false
    var fromFcm = false

    /**
     * Toggle
     * */
    private var lockToggle = false
    fun hideToggleAnimation(groupToggle: Group, switchCamera: AppCompatImageView) {
        MainScope().launch {
            if (!lockToggle) {
                lockToggle = true
                stopCountDownForToggle()
                groupToggle.fadeOut(isGone = true)
                switchCamera.fadeOut(isGone = true)
                lockToggle = false
            }
        }
    }

    fun showToggleAnimation(groupToggle: Group, switchCamera: AppCompatImageView, isCamera: Boolean) {
        MainScope().launch {
            if (!lockToggle) {
                lockToggle = true
                stopCountDownForToggle()
                groupToggle.fadeIn()
                if (isCamera) {
                    switchCamera.fadeIn()
                }
                startCountDownForToggle(groupToggle, switchCamera)
                lockToggle = false
            }
        }
    }

    private var countTimerToggle: Timer? = null
    private var timeToggle = 0L
    private var timeOutToggle = 5000L
    fun startCountDownForToggle(groupToggle: Group, switchCamera: AppCompatImageView) {
        stopCountDownForToggle()
        if (groupToggle.isVisible) {
            countTimerToggle = Timer()
            countTimerToggle?.scheduleAtFixedRate(
                object : TimerTask() {
                    override fun run() {
                        timeToggle += 1000
                        Logger.e("Toggle" + "Toggle will hiding after ${(timeOutToggle - timeToggle) / 1000}(s)")
                        if (timeToggle > timeOutToggle) {
                            hideToggleAnimation(groupToggle, switchCamera)
                            stopCountDownForToggle()
                        }
                    }
                },
                0,
                1000
            )
        }
    }

    /**
     * Time status
     * */
    private var countTimerStatus: Timer? = null
    private var timeStatus = 0L
    fun startCountdownStatus(textView: TextView, lifecycleScope: LifecycleCoroutineScope) {
        countTimerStatus = Timer()
        countTimerStatus?.scheduleAtFixedRate(
            object : TimerTask() {
                override fun run() {
                    lifecycleScope.launch(Dispatchers.Main) {
                        if (textView.tag != textView.context.resources.getString(R.string.end_call)) {
                            textView.text = convertCountTimeToString(timeStatus++)
                        }
                    }
                }
            },
            0,
            1000
        )
    }

    fun stopCountdownStatus() {
        countTimerStatus?.cancel()
        timeStatus = 0L
    }

    private fun convertCountTimeToString(count: Long): String {
        val h = count / 3600
        val m = (count - h * 3600) / 60
        val s = count % 60
        val ms = String.format("%02d:%02d", m, s)
        return if (h > 0) String.format("%02d:%s", h, ms) else ms
    }

    private var countTimerTimeOut: Timer? = null
    private var timeTimeOut = 0L
    fun startCountdownTimeOut(timeOut: Long, endTimeCallback: () -> Unit) {
        stopCountdownTimeOut()

        countTimerTimeOut = Timer()
        countTimerTimeOut?.scheduleAtFixedRate(
            object : TimerTask() {
                override fun run() {
                    Logger.d("The call ended in ${(timeOut - timeTimeOut) / 1000}(s)")
                    timeTimeOut += 1000
                    if (timeTimeOut > timeOut) {
                        endTimeCallback()
                        stopCountdownTimeOut()
                    }
                }
            },
            0,
            1000
        )
    }

    fun stopCountdownTimeOut() {
        countTimerTimeOut?.cancel()
        timeTimeOut = 0L
    }

    fun stopCountDownForToggle() {
        countTimerToggle?.cancel()
        countTimerToggle = null
        timeToggle = 0L
    }

    /**
     * Swipe camera
     * */
    fun swipeCamera(view: View, widthScreen: Float, heightScreen: Float) {
        view.setOnTouchListener(
            object : View.OnTouchListener {
                private var dX = 0F
                private var dY = 0F
                private val dimen20dp = view.context.resources.getDimension(R.dimen.dp_20)
                private var dimen60dp = view.context.resources.getDimension(R.dimen.dp_60)

                @SuppressLint("ClickableViewAccessibility")
                override fun onTouch(view: View, event: MotionEvent): Boolean {
                    val newX: Float
                    val newY: Float

                    when (event.action) {
                        MotionEvent.ACTION_DOWN -> {
                            dX = view.x - event.rawX
                            dY = view.y - event.rawY
                        }
                        MotionEvent.ACTION_MOVE -> {

                            newX = event.rawX + dX
                            newY = event.rawY + dY

                            val aX = widthScreen - view.width - dimen20dp
                            val aY = heightScreen - view.height - dimen60dp

                            if (newX < dimen20dp || newX > aX) {
                                if (newY >= dimen60dp && newY < aY) {
                                    view.animate()
                                        .y(newY)
                                        .setDuration(0)
                                        .start()
                                }
                            } else if (newY < dimen60dp || newY > aY) {
                                if (newX >= dimen20dp && newX < aX) {
                                    view.animate()
                                        .x(newX)
                                        .setDuration(0)
                                        .start()
                                }
                            } else {
                                view.animate()
                                    .x(newX)
                                    .y(newY)
                                    .setDuration(0)
                                    .start()
                            }
                        }
                        MotionEvent.ACTION_UP -> {
                            val newX_ = if (view.x < (widthScreen - view.width) / 2) {
                                dimen20dp
                            } else {
                                widthScreen - view.width - dimen20dp
                            }
                            val newY_ = if (view.y < (heightScreen - view.height) / 2) {
                                dimen60dp
                            } else {
                                heightScreen - view.height - dimen60dp
                            }

                            view.animate()
                                .x(newX_)
                                .y(newY_)
                                .setDuration(200)
                                .start()
                        }
                        else -> return true
                    }
                    return true
                }
            }
        )
    }

    private interface CustomAnimatorListener : Animator.AnimatorListener {
        override fun onAnimationRepeat(p0: Animator?) {
        }

        override fun onAnimationEnd(p0: Animator?) {
        }

        override fun onAnimationCancel(p0: Animator?) {
        }

        override fun onAnimationStart(p0: Animator?) {
        }
    }

    /**
     * Sensor
     * */
    private val SENSOR_PROXIMITY_LISTENER = object : SensorEventListener {
        lateinit var nearDeviceCallback: () -> Unit
        lateinit var farDeviceCallback: () -> Unit

        override fun onAccuracyChanged(p0: Sensor?, p1: Int) {
        }

        override fun onSensorChanged(event: SensorEvent?) {
//            Logger.e("onSensorChanged=" + event?.values?.map { it })
            val values = event?.values ?: return
            if (event.sensor.type == Sensor.TYPE_PROXIMITY) {
                if (values[0] == 0.0f) {
                    nearDeviceCallback()
                } else {
                    farDeviceCallback()
                }
            }
        }
    }

    fun registerProximitySensor(
        context: Context,
        nearDeviceCallback: () -> Unit,
        farDeviceCallback: () -> Unit
    ) {
        SENSOR_PROXIMITY_LISTENER.nearDeviceCallback = nearDeviceCallback
        SENSOR_PROXIMITY_LISTENER.farDeviceCallback = farDeviceCallback

        (context.getSystemService(AppCompatActivity.SENSOR_SERVICE) as? SensorManager)?.let {
            val mSensor = it.getDefaultSensor(Sensor.TYPE_PROXIMITY)
            it.registerListener(
                SENSOR_PROXIMITY_LISTENER,
                mSensor,
                SensorManager.SENSOR_DELAY_NORMAL
            )
        }
    }

    fun unregisterProximitySensor(context: Context) {
        (context.getSystemService(AppCompatActivity.SENSOR_SERVICE) as? SensorManager)?.unregisterListener(
            SENSOR_PROXIMITY_LISTENER
        )
    }
}
