/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.calling

import android.annotation.SuppressLint
import android.content.Context
import android.media.AudioManager
import android.media.MediaPlayer
import android.media.Ringtone
import android.media.RingtoneManager
import android.os.Build
import android.os.VibrationEffect
import android.os.Vibrator
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.full.R

@SuppressLint("MissingPermission")
object RingtonePlayer {
    private var mediaPlayer: MediaPlayer? = null
    private var ringtone: Ringtone? = null
    private var vibrator: Vibrator? = null

    fun switchSpeaker(context: Context, speakerEnable: Boolean) {
        (context.getSystemService(Context.AUDIO_SERVICE) as? AudioManager)?.run {
            mode = AudioManager.MODE_IN_COMMUNICATION
            isSpeakerphoneOn = speakerEnable
        }
    }

    fun ringCallOutcome(context: Context) {
        stopCallOutcome()
        MediaPlayer.create(context, R.raw.audio_calling)?.apply {
            mediaPlayer = this
            isLooping = true
            start()
        }
    }

    fun stopCallOutcome() {
        mediaPlayer?.let {
            if (it.isPlaying) {
                it.stop()
                it.release()
            }
            mediaPlayer = null
        }
    }

    fun ringCallIncome(context: Context) {
        val uri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_RINGTONE)
        RingtoneManager.getRingtone(context, uri).apply {
            ringtone = this
            this.play()
        }
    }

    fun stopCallIncome() {
        ringtone?.stop()
        ringtone = null
    }

    fun ringEndCall(context: Context, speakerEnable: Boolean) {
        MediaPlayer.create(context, R.raw.audio_endcall)?.run {
            isLooping = false
            start()
        }
        (context.getSystemService(Context.AUDIO_SERVICE) as? AudioManager)?.run {
            mode = AudioManager.MODE_NORMAL
        }
    }

    fun ringVibrator(context: Context, looping: Boolean = true) {
        try {
            vibrator = context.getSystemService(Context.VIBRATOR_SERVICE) as? Vibrator
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                val vEffect = VibrationEffect.createWaveform(
                    longArrayOf(0, 1000, 1000),
                    if (looping) 0 else -1
                )
                vibrator?.vibrate(vEffect)
            } else {
                vibrator?.vibrate(longArrayOf(0, 1000, 1000), if (looping) 0 else -1)
            }
        } catch (e: Exception) {
            FirebaseCrashlytics.getInstance().recordException(e)
            e.printStackTrace()
        }
    }

    fun stopVibrator() {
        vibrator?.cancel()
    }
}
