/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.chat

import android.Manifest
import android.annotation.SuppressLint
import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.os.Bundle
import android.os.Environment
import android.view.MotionEvent
import android.view.View
import android.view.animation.Animation
import android.view.animation.OvershootInterpolator
import android.view.animation.ScaleAnimation
import android.view.animation.Transformation
import android.widget.LinearLayout
import androidx.core.content.ContextCompat
import androidx.core.view.isGone
import androidx.core.view.isInvisible
import androidx.core.view.isVisible
import androidx.core.view.marginBottom
import androidx.fragment.app.activityViewModels
import androidx.fragment.app.setFragmentResultListener
import androidx.lifecycle.lifecycleScope
import androidx.navigation.fragment.navArgs
import androidx.recyclerview.widget.ItemTouchHelper
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.viewpager.widget.ViewPager
import com.abangfadli.shotwatch.ShotWatch
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.adapter.RecyclerViewPaginator
import com.netacom.base.chat.android_utils.KeyboardUtils
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImageBackground
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.util.isNotNull
import com.netacom.base.chat.util.isNull
import com.netacom.base.chat.util.unAccentText
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseCoreCallCameraFragment
import com.netacom.full.databinding.FragmentBaseChatBinding
import com.netacom.full.extensions.MessageSwipeController
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.ui.main.chat.adapter.ChangeBackgroundAdapter
import com.netacom.full.ui.main.chat.adapter.ChangeBackgroundAdapter.Companion.DEFAULT_BACKGROUND
import com.netacom.full.ui.main.chat.adapter.ChatMentionAdapter
import com.netacom.full.ui.main.chat.adapter.ListChatDiffUtilAdapter
import com.netacom.full.ui.main.chat.adapter.sticker.DCategoryStickerAdapter
import com.netacom.full.ui.main.chat.adapter.sticker.StickerCategoryAdapter
import com.netacom.full.ui.main.contact.ContactUtils
import com.netacom.full.ui.main.profile.SelectMediaFragment
import com.netacom.full.ui.sdk.NetAloSDK
import com.netacom.full.utils.DialogUtil
import com.netacom.full.utils.ItemClickListener
import com.netacom.full.widget.chat_footer.ViewChatFooterCallBack
import com.netacom.full.widget.chat_header.ViewChatHeaderCallBack
import com.netacom.full.widget.record.MediaRecordHelper
import com.netacom.full.widget.video.PlayerExoHelper
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MediaType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.define.MessageType
import com.netacom.lite.entity.database.attachment.NeDocument
import com.netacom.lite.entity.database.attachment.NeLocation
import com.netacom.lite.entity.database.attachment.NeVideo
import com.netacom.lite.entity.socket.EventType
import com.netacom.lite.entity.ui.NeChatInfo
import com.netacom.lite.entity.ui.NeSticker
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.entity.ui.local.LocalFileModel
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.message.NeSubMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.network.model.response.ImageBackgroundResponse
import com.netacom.lite.repository.secretChat.ChatSecretUtils
import com.netacom.lite.socket.request.UpdateBackgroundRequest
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.CallbackResult
import com.netacom.lite.util.Constants
import com.netacom.lite.util.FileUtils
import com.netacom.lite.util.afterMeasured
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.ObsoleteCoroutinesApi
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import java.io.File
import javax.inject.Inject

/**
Created by vantoan on 28,July,2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 */
@ObsoleteCoroutinesApi
@AndroidEntryPoint
open class BaseChatFragment :
    BaseCoreCallCameraFragment<FragmentBaseChatBinding, ChatViewModel>(
        R.layout.fragment_base_chat,
        ChatViewModel::class.java
    ) {

    companion object {
        val TAG = BaseChatFragment::class.java.simpleName
    }

    @Inject
    lateinit var playerExoHelper: PlayerExoHelper
    private lateinit var listChatAdapter: ListChatDiffUtilAdapter
    private lateinit var chatMentionAdapter: ChatMentionAdapter
    private var recyclerViewPaginator: RecyclerViewPaginator? = null
    private var messageForward: NeMessage? = null
    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()
    private val args: BaseChatFragmentArgs by navArgs()
    private var neUser: NeUser? = null
    private var neGroup: NeGroup = NeGroup()
    private var mediaRecordHelper: MediaRecordHelper? = null
    private var isShowInfo: Boolean = false
    private var backgroundChangeAdapter: ChangeBackgroundAdapter? = null

    // for Background
    private var applyBackgroundForAll = false
    private var isBlur = false

    // for Draft
    private var draftContent = ""

    private var previewBackgroundUrl: String? = null

    override fun setViewModel(): Int = BR.viewModel

    private var shotWatch: ShotWatch? = null

    override fun initViews() {
        neGroup = args.neGroup ?: NeGroup()
        if (neGroup.type.isNull) return

        if (neGroup.isSecretChat()) {
            initSecretChat()
        }

        listChatAdapter = ListChatDiffUtilAdapter(
            groupType = neGroup.type ?: GroupType.GROUP_TYPE_UNKNOWN,
            preferencesHelperImpl = preferencesHelperImpl,
            members = neGroup.members,
            itemClick = { _, _, _ ->
                // todo
            },
            moreClick = {
                // todo
            },
            hideClick = {
                // todo
            },
            removeClick = {
                // todo
            },
            themeHelperImpl = themeHelperImpl,
            groupRepository = viewModel.groupRepository,
            downloadRepository = viewModel.downloadRepository,
            stickerRepository = viewModel.stickerRepository,
            dbManager = viewModel.getDbManager,
            playerExoHelper = playerExoHelper
        )
        binding.rcvChat.setHasFixedSize(true)
        binding.rcvChat.adapter = listChatAdapter
        binding.rcvChat.itemAnimator = null

        binding.rcvChat.layoutManager = LinearLayoutManager(context).apply {
            stackFromEnd = true
            reverseLayout = false
        }

        mainSdkViewModel.cacheListMessages.filter { it.groupId == neGroup.id }.let { listSubMessage ->
            listChatAdapter.display(viewModel.convertMessages(listSubMessage))
        }

        initStickerView()

        binding.rcvMention.layoutManager = LinearLayoutManager(context).apply {
            this.stackFromEnd = true
        }
        chatMentionAdapter = ChatMentionAdapter(
            itemClick = { item, _, _ ->
                binding.viewChatFooter.addMention(neUser = item)
                chatMentionAdapter.display(emptyList())
            },
            themeHelperImpl
        )
        binding.rcvMention.adapter = chatMentionAdapter
        setupScrollDown()
        setupScrollMention()

        if (args.isChangeBackground) {
            showChangeBackground()
        }

        setupBackground()
        setupBackgroundConfig()
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(
                viewChatFooter,
                toolbar,
                fabScrollMention,
                fabScrollDown,
                containChangeBackground.ivCheckBlur,
                containChangeBackground.ivCheckForAll
            )
        }
    }

    override fun initData() {
        // Todo: Note -> handle for forward media from media view fragment
        if (viewModel.isForwardMessage && viewModel.forwardSelectedGroup != null) {
            viewModel.forwardSelectedGroup?.let {
                initNeGroup(it)
            } ?: initNeGroup(neGroup)
        } else {
            initNeGroup(neGroup)
        }

        recyclerViewPaginator = RecyclerViewPaginator(
            recyclerView = binding.rcvChat,
            isMessage = true,
            isLoading = { viewModel.isLoading() },
            loadMore = { loadMore(listChatAdapter.getLastMessage()) },
            onLast = { false }
        )

        viewModel.retryMessageFromDatabase(
            requireContext(),
            callbackCompressProgress = { messageId, compress, index, compressId, uploadId, mergeId ->
                callBackCompressProgressMessage(
                    messageId,
                    compress,
                    index,
                    compressId,
                    uploadId,
                    mergeId
                )
            },
            callbackUploadProgress = { messageId, progress, size, index, compressId, uploadId, mergeId ->
                callBackUploadProgressMessage(
                    messageId,
                    progress,
                    size,
                    index,
                    compressId,
                    uploadId,
                    mergeId
                )
            }
        )
        mainSdkViewModel.eventUpdate.observeOnce { event ->
            if (viewModel.isCurrentGroup(neGroup.id, event.groupId)) {
                when (event.type) {
                    EventType.EVENT_TYPE_MESSAGING_START_TYPING.value -> {
                        binding.viewChatFooter.setTyping(isTyping = true)
                    }

                    EventType.EVENT_TYPE_MESSAGING_STOP_TYPING.value -> {
                        binding.viewChatFooter.setTyping(isTyping = false)
                    }
                }
            }
        }

        mainSdkViewModel.messageReceive.observeOnce { neMessage ->
            if (::listChatAdapter.isInitialized) {
                if (viewModel.isCurrentGroup(neGroup.id, neMessage.groupId)) {
                    if (!neGroup.isSecretChat() ||
                        neMessage.type != MessageType.MESSAGE_TYPE_FIRST_MESSAGE ||
                        !listChatAdapter.getData.any { it.neMessage?.type == MessageType.MESSAGE_TYPE_FIRST_MESSAGE }
                    ) {
                        if (neGroup.isSecretChat()) neMessage.timeOut = neGroup.timeOut
                        viewModel.convertLatestNeMessage(listChatAdapter.getData.lastOrNull(), neMessage)
                            ?.apply {
                                createMessageCallback(this)
                            }
                    }
                }
            }
        }

        mainSdkViewModel.messageUpdate.observe { message ->
            if (::listChatAdapter.isInitialized) {
                message?.let { updateMessage ->
                    if (updateMessage.groupId == NetAloSDK.activeGroup) {
                        with(listChatAdapter) {
                            var messageUpdate = NeSubMessage()
                            getData.find { it.neMessage?.id == updateMessage.messageId && it.neMessage?.status != MessageStatusType.MESSAGE_SEEN }
                                ?.apply {
                                    if (message.seenUins?.size ?: 0 > 0) {
                                        this.neMessage?.status = MessageStatusType.MESSAGE_SEEN
                                        if (neGroup.isSecretChat() &&
                                            this.neMessage?.type != MessageType.MESSAGE_TYPE_GROUP_UPDATE &&
                                            this.neMessage?.type != MessageType.MESSAGE_TYPE_SCREENSHOT
                                        ) {
                                            viewModel.setTimeOutForSecretMessage(
                                                neGroup.timeOut,
                                                updateMessage.groupId,
                                                updateMessage.messageId,
                                                callbackSuccess = {
                                                    mainSdkViewModel.syncGroup()
                                                }
                                            )
                                        }
                                    } else if (message.receivedUins?.size ?: 0 > 0) {
                                        this.neMessage?.status = MessageStatusType.MESSAGE_RECEIVED
                                    }
                                    messageUpdate = this
                                }
                            listChatAdapter.notifyItemChanged(getData.indexOf(messageUpdate))
                            // change status all message
                            if (message.seenUins?.size ?: 0 > 0) {
                                getData.filter {
                                    it.neMessage?.status != MessageStatusType.MESSAGE_SEEN
                                }.forEach {
                                    it.neMessage?.status = MessageStatusType.MESSAGE_SEEN
                                    listChatAdapter.notifyItemChanged(getData.indexOf(it))
                                    if (neGroup.isSecretChat() &&
                                        it.neMessage?.type != MessageType.MESSAGE_TYPE_GROUP_UPDATE &&
                                        it.neMessage?.type != MessageType.MESSAGE_TYPE_SCREENSHOT
                                    ) {
                                        viewModel.setTimeOutForSecretMessage(
                                            it.neMessage?.timeOut,
                                            it.neMessage?.groupId,
                                            it.neMessage?.id,
                                            callbackSuccess = {
                                                mainSdkViewModel.syncGroup()
                                            }
                                        )
                                    }
                                }
                            }
                        }
                    }
                    mainSdkViewModel._messageUpdate.postValue(null)
                }
            }
        }
        mainSdkViewModel.messageDelete.observe { message ->
            if (::listChatAdapter.isInitialized) {
                message?.let { deleteMessage ->
                    if (deleteMessage.groupId == NetAloSDK.activeGroup) {
                        listChatAdapter.deleteMessage(deleteMessage.messageId)
                    }
                    mainSdkViewModel._messageDelete.postValue(null)
                }
            }
        }

        viewModel.listNeMessage.observeOnce { listNeMessage ->
            if (::listChatAdapter.isInitialized) {
                with(listChatAdapter) {
                    if (listNeMessage.isNotEmpty()) {
                        if (neGroup.isSecretChat()) {
                            listNeMessage.forEach {
                                if (it.neMessage?.status == MessageStatusType.MESSAGE_SEEN &&
                                    it.neMessage?.type != MessageType.MESSAGE_TYPE_GROUP_UPDATE &&
                                    it.neMessage?.type != MessageType.MESSAGE_TYPE_SCREENSHOT
                                ) {
                                    viewModel.setTimeOutForSecretMessage(
                                        it.neMessage?.timeOut,
                                        it.neMessage?.groupId,
                                        it.neMessage?.id,
                                        callbackSuccess = {
                                            mainSdkViewModel.syncGroup()
                                        }
                                    )
                                }
                            }
                        }
                        when {
                            viewModel.isForwardMessage -> {
                                viewModel.neGroup?.let {
                                    neGroup = it
                                    initWidgetChat(neGroup)
                                }
                                display(listNeMessage)
                                processSendForwardMessage()
                            }
                            viewModel.isFirstPage() -> {
                                display(listNeMessage)
                                scrollToNewMessage(
                                    recyclerView = binding.rcvChat,
                                    position = listNeMessage.size - 1,
                                    isFore = true
                                )
                                detectMention()
                            }
                            else -> {
                                if (neGroup.id == viewModel.neGroup?.id) {
                                    addNewMessage(listNeMessage, isNewMessage = false)
                                }
                            }
                        }
                    }
                }
            }
        }

        viewModel.listNeMessageLoadMore.observeOnce { listNeMessage ->
            with(listChatAdapter) {
                if (listNeMessage.isNotEmpty()) {
                    addNewMessage(listNeMessage, isNewMessage = false)
                }
            }
        }

        mainSdkViewModel.isConnectSocket.observe { isConnected ->
            binding.toolbar.setCheckConnection(isConnected)
            if (::listChatAdapter.isInitialized) {
                if (isConnected) {
                    if (neGroup.isSecretChat() && binding.viewSecretWaitingAccept.isVisible) {
                        initSecretChat()
                    } else {
                        viewModel.getListMessage()
                    }
                    initStickerView()
                } else {
                    Logger.e("socket-disconnect")
                }
            }
        }

        mainSdkViewModel.updateGroup.observeOnce {
            if (::listChatAdapter.isInitialized) {
                if (viewModel.isCurrentGroup(neGroup.id, it.id)) {
                    neGroup = it
                    initWidgetChat(neGroup)

                    // update background
                    if (neGroup.background?.background_url != it.background?.background_url || neGroup.background?.is_blur == it.background?.is_blur) {
                        neGroup.background?.apply {
                            background_url?.let { _url ->
                                applyBackgroundChat(_url, is_blur)
                            }
                        }
                    }
                }
            }
        }

        // NOTE : This use case to replace temp group
        viewModel.createGroupSuccess.observeOnce {
            neGroup = it
        }

        // quick fix to update member , refactor later
        mainSdkViewModel.listGroup.observeOnce {
            if (::listChatAdapter.isInitialized) {
                it.firstOrNull { group ->
                    group.id == neGroup.id
                }?.run {
                    if (neGroup.members?.size != this.members?.size) {
                        neGroup = this
                        Logger.e("saveGroupDb==list block from list group")
                        initWidgetChat(neGroup)
                        listChatAdapter.updateMembers(neGroup.members)
                    }
                    initHeaderGroup(this)
                }
            }
        }

        viewModel.clearUnreadMessageCount()

        checkPermissionStorage(
            {
                shotWatch = ShotWatch(requireContext().contentResolver) {
                    if (neGroup.isSecretChat()) {
                        viewModel.createMessage(
                            message = StringUtils.getString(R.string.me_message_capture_screenshot),
                            type = MessageType.MESSAGE_TYPE_SCREENSHOT,
                            callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                                callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
                            },
                            callbackError = { error, tempMessageId ->
                                createMessageCallbackFailed(tempMessageId = tempMessageId)
                            }
                        )
                    }
                }
            },
            {}
        )

        viewModel.addNewContactSuccess.observeOnce {
            binding.toolbar.isNewContact(false)
        }
    }

    private fun initSecretChat() {
        mainSdkViewModel.initKeyForSecretChat()
        if (neGroup.isFcm && neGroup.lastMessage == null) { // from fcm notification and type of start secret chat
            binding.viewSecretWaitingAccept.isVisible = true
            neGroup.id?.let {
                mainSdkViewModel.acceptSecretChat(
                    it.toLong(),
                    true,
                    object : CallbackResult<NeGroup> {
                        override fun callBackSuccess(result: NeGroup) {
                            neGroup = result
                            mainSdkViewModel.initSecretChat(
                                neGroup,
                                callbackResult = object : CallbackResult<NeGroup?> {
                                    override fun callBackSuccess(result: NeGroup?) {
                                        result?.apply {
                                            initNeGroup(this)
                                        } ?: initNeGroup(neGroup)
                                    }

                                    override fun callBackError(error: String?) {
                                    }
                                }
                            )
                        }

                        override fun callBackError(error: String?) {
                        }
                    }
                )
            }
        } else {
            mainSdkViewModel.initSecretChat(
                neGroup,
                callbackResult = object : CallbackResult<NeGroup?> {
                    override fun callBackSuccess(result: NeGroup?) {
                        if (activity?.isFinishing == false) {
                            initNeGroup(neGroup)
                        }
                    }

                    override fun callBackError(error: String?) {
                    }
                }
            )
        }
    }

    private fun initNeGroup(neGroup: NeGroup) {
        Logger.e("initNeGroup == $neGroup")
        initWidgetChat(neGroup, true)
        viewModel.initNeGroup(neGroup)
    }

    private fun initWidgetChat(neGroup: NeGroup, isOpenFromGroup: Boolean = false) {
        MainScope().launch {
            Logger.d("initWidgetChat == $neGroup")
            initHeaderGroup(neGroup)
            initFooterGroup(neGroup, isOpenFromGroup)
            initTypeChat(neGroup)
        }
    }

    private fun initHeaderGroup(neGroup: NeGroup) {
        when (neGroup.type) {
            GroupType.GROUP_TYPE_GROUP, GroupType.GROUP_TYPE_CHANNEL, GroupType.GROUP_TYPE_OFFICIAL -> {
                binding.toolbar.setHeader(NeChatInfo(neGroup))
                if (neGroup.type == GroupType.GROUP_TYPE_OFFICIAL) {
                    binding.toolbar.hideCallAndVideo()
                    binding.toolbar.hideMemberOrStatus()
                }
            }
            GroupType.GROUP_TYPE_PUBLIC, GroupType.GROUP_TYPE_PRIVATE -> {
                neUser = neGroup.members?.firstOrNull { it ->
                    it.id != viewModel.getUserId
                }
                neUser?.let { user ->
                    binding.toolbar.setHeader(NeChatInfo(user))
                    if (neGroup.isDeletedContacts) {
                        if (!viewModel.checkGroupExitsInDb(neGroup)) {
                            binding.toolbar.hideActionBlock(true)
                        }
                        binding.toolbar.isNewContact(!viewModel.checkHideAddInfo)
                    } else {
                        mainSdkViewModel.listContact.value?.peekContent()?.let {
                            user.id?.let { id ->
                                if (!viewModel.checkGroupExitsInDb(neGroup)) {
                                    binding.toolbar.hideActionBlock(true)
                                }
                                binding.toolbar.isNewContact(!ContactUtils.hasAddedFriend(id, it) && !viewModel.checkHideAddInfo)
                            }
                        }
                    }
                }
            }
            else -> {
            }
        }
    }

    private fun initFooterGroup(neGroup: NeGroup, isOpenFromGroup: Boolean = false) {
        when (neGroup.type) {
            GroupType.GROUP_TYPE_GROUP -> {
            }
            GroupType.GROUP_TYPE_PUBLIC, GroupType.GROUP_TYPE_PRIVATE -> {
                try {
                    neGroup.id?.let { id ->
                        if (isOpenFromGroup) {
                            val neGroupDb = viewModel.getGroupDbById(id)
                            neGroup.blockers = neGroupDb?.blockers
                        }
                        neGroup.blockers?.let { listBlockers ->
                            if (listBlockers.isNotEmpty()) {
                                if (listBlockers[0].id == viewModel.getUserId) {
                                    binding.viewChatFooter.showUserWasBlocked()
                                } else {
                                    neGroup.members?.firstOrNull { member ->
                                        member.id != viewModel.getUserId
                                    }?.let {
                                        binding.viewChatFooter.showOwnerBlocked(it)
                                    }
                                }
                            } else {
                                binding.viewChatFooter.showInputChat()
                            }
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                    FirebaseCrashlytics.getInstance().recordException(e)
                }
            }
            GroupType.GROUP_TYPE_CHANNEL -> {
                if (viewModel.isLeaderInGroup(neGroup)) {
                    binding.viewChatFooter.showInputChat()
                } else {
                    binding.viewChatFooter.showMemberOfChannel(neGroup)
                }
            }
            else -> {
            }
        }
    }

    private fun initTypeChat(neGroup: NeGroup) {
        when (neGroup.type) {
            GroupType.GROUP_TYPE_GROUP, GroupType.GROUP_TYPE_CHANNEL -> {
                binding.toolbar.isGroup(true)
            }
            GroupType.GROUP_TYPE_PUBLIC, GroupType.GROUP_TYPE_PRIVATE -> {
                binding.toolbar.isGroup(false)

                neGroup.blockers?.let {
                    if (it.isNotEmpty()) {
                        binding.toolbar.hideCallAndVideo()
                    } else {
                        binding.toolbar.showCallIcon()
                    }
                } ?: binding.toolbar.showCallIcon()
            }
        }
    }

    private fun loadMore(lastMessage: NeMessage?) = viewModel.loadMoreMessages(lastMessage)

    private fun loadMissMessage(lastMessage: NeMessage?) = viewModel.loadMissMessage(lastMessage)

    override fun syncEvent() {
        if (neGroup.type.isNull) return
        swipeForReply()
        callEvent()
        resultListener()

        mainSdkViewModel.userStatus.observeOnce {
            if (it.id == neUser?.id) {
                binding.toolbar.updateStatus(it.isOnline)
            }
        }

        binding.toolbar.registerCallBack(
            object : ViewChatHeaderCallBack {
                override fun onBlockUserClicked() {
                    neUser?.let { blockUser ->
                        if (neGroup.blockers != null) {
                            neGroup.blockers?.let {
                                if (it.isNotEmpty()) {
                                    if (it[0].id == viewModel.getUserId) {
                                        DialogUtil.show(
                                            requireContext(),
                                            messageRes = R.string.cannot_block_message,
                                            okLabel = R.string.popup_confirm_logout_ok,
                                            themeHelperImpl = themeHelperImpl
                                        )
                                    } else {
                                        val titleUnblock = requireContext().resources.getString(R.string.unblock_alert_title, blockUser.getDisplayName)
                                        val messageUnblock = requireContext().resources.getString(R.string.unblock_alert_message, blockUser.getDisplayName)
                                        DialogUtil.show(
                                            context = requireContext(),
                                            titleStr = titleUnblock,
                                            messageStr = messageUnblock,
                                            cancelLabel = R.string.str_cancel,
                                            okLabel = R.string.unblock_alert_button,
                                            okFunc = {
                                                blockUser.id?.let { blockIds ->
                                                    viewModel.unblockUser(
                                                        neGroup.id?.toLongOrNull() ?: 0,
                                                        blockIds,
                                                        object : CallbackResult<NeGroup> {
                                                            override fun callBackSuccess(neGroup: NeGroup) {
                                                                showSnackBar(R.string.unblock_user_success)
                                                            }

                                                            override fun callBackError(error: String?) {
                                                                showSnackBar(R.string.unblock_user_unsuccess)
                                                            }
                                                        }
                                                    )
                                                }
                                            },
                                            themeHelperImpl = themeHelperImpl
                                        )
                                    }
                                } else {
                                    showBlockPopup(blockUser)
                                }
                            }
                        } else {
                            showBlockPopup(blockUser)
                        }
                    }
                }

                override fun onMakeFriendClicked() {
                    viewModel.addNewContact(neUser, false, TAG)
                }

                override fun onVoiceCallClicked() {
                    if (neGroup.id?.isNotBlank() == true) {
                        mainSdkViewModel.openCall(neGroup, false)
                    } else {
                        neUser?.let {
                            checkCall(it.id, false)
                        }
                    }
                }

                override fun onVideoCallClicked() {
                    if (neGroup.id?.isNotBlank() == true) {
                        mainSdkViewModel.openCall(neGroup, true)
                    } else {
                        neUser?.let {
                            checkCall(it.id, true)
                        }
                    }
                }

                override fun onMoreClicked() {
                    if (neGroup.type == GroupType.GROUP_TYPE_OFFICIAL) return
                    isShowInfo = true
                    viewModel.showMemberOrGroupInfo(neGroup)
                }

                override fun onBack() {
                    if (binding.toolbar.isBackgroundChangeVisible()) {
                        binding.toolbar.hideChangeBackground()
                        binding.containChangeBackground.root.isGone = true
                        // cancel change background , return previous background
                        setupBackground()
                    } else {
                        KeyboardUtils.hideSoftInput(binding.toolbar)
                        viewModel.onBack {
                            activity?.onBackPressed()
                        }
                    }
                }

                override fun onGoneNewContact() {
                }

                override fun onChangeBackgroundClicked() {
                    binding.toolbar.hideChangeBackground(neGroup.type == GroupType.GROUP_TYPE_GROUP || neGroup.type == GroupType.GROUP_TYPE_CHANNEL)
                    binding.containChangeBackground.root.isGone = true
                    previewBackgroundUrl?.let { backgroundUrl ->
                        val updateBackground = UpdateBackgroundRequest(background_url = backgroundUrl, is_blur = isBlur)
                        if (applyBackgroundForAll) {
                            // use viewModel.negroup to fix case temp group
                            viewModel.updateGroupBackground(
                                neGroup,
                                updateBackground,
                                object : CallbackResult<NeGroup> {
                                    override fun callBackSuccess(result: NeGroup) {
                                        this@BaseChatFragment.neGroup.background = result.background
                                    }

                                    override fun callBackError(error: String?) {
                                        showSnackBar(error)
                                    }
                                }
                            )
                        } else {
                            if (backgroundUrl.isEmpty() && neGroup.background?.background_url?.isNotEmpty() == true) {
                                neGroup.background?.background_url?.let { groupBackgroundUrl ->
                                    applyBackgroundChat(groupBackgroundUrl, neGroup.background?.is_blur ?: false)
                                }
                            }
                            viewModel.updateGroupLocalBackground(neGroup, updateBackground)
                        }
                    }
                }
            }
        )

        binding.viewChatFooter.registerCallBack(
            object : ViewChatFooterCallBack {
                override fun onUnBlock() {
                    if (neGroup.type == GroupType.GROUP_TYPE_PUBLIC || neGroup.type == GroupType.GROUP_TYPE_PRIVATE) {
                        neUser = neGroup.members?.find { it ->
                            it.id != viewModel.getUserId
                        }
                        neUser?.let { user ->
                            val titleUnblock = requireContext().resources.getString(
                                R.string.unblock_alert_title,
                                user.getDisplayName
                            )
                            val messageUnblock = requireContext().resources.getString(
                                R.string.unblock_alert_message,
                                user.getDisplayName
                            )
                            DialogUtil.show(
                                context = requireContext(),
                                titleStr = titleUnblock,
                                messageStr = messageUnblock,
                                cancelLabel = R.string.str_cancel,
                                okLabel = R.string.unblock_alert_button,
                                okFunc = {
                                    viewModel.unblockUser(
                                        neGroup.id?.toLongOrNull() ?: 0,
                                        user.id!!,
                                        object : CallbackResult<NeGroup> {
                                            override fun callBackSuccess(result: NeGroup) {
                                                neGroup = result
                                                Logger.e("saveGroupDb==list block from onUnBlock")
                                                initWidgetChat(neGroup)
                                                showSnackBar(R.string.unblock_user_success)
                                            }

                                            override fun callBackError(error: String?) {
                                                showSnackBar(R.string.unblock_user_unsuccess)
                                            }
                                        }
                                    )
                                },
                                themeHelperImpl = themeHelperImpl
                            )
                        }
                    }
                }

                override fun onStartRecordVoice() {
/*
                * Start record voice message
                * */
                    processForStartRecordVoice()
                }

                override fun onStopRecordVoice() {
/*
                * Stop record voice message
                * */
                    processForStopRecordVoice()
                }

                override fun processSendAudioMessage() {
/*
                * Do process send voice message
                * */
                    processSendVoiceMessage()
                }

                override fun isTyping(isFocus: Boolean) {
                    Logger.d("__isTyping = $isFocus")
                    viewModel.setTyping(isFocus)
                }

                override fun onSendMessage(text: String) {
/*
                * Send text message
                * */
                    viewModel.createMessage(
                        message = getContentMention(text),
                        type = MessageType.MESSAGE_TYPE_TEXT,
                        isMentionAll = text.contains("@All"),
                        callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                            Logger.t(TAG)?.d("onSendMessage = $neMessage")
                            callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
                        },
                        callbackError = { error, tempMessageId ->
                            Logger.t(TAG)?.d("onSendMessage:callbackError = $error")
                            createMessageCallbackFailed(tempMessageId = tempMessageId)
                        }
                    )
                }

                override fun onSendSticker() {
                    viewModel.createMessage(
                        message = "👍",
                        type = MessageType.MESSAGE_TYPE_TEXT,
                        callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                            callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
                        },
                        callbackError = { error, tempMessageId ->
                            createMessageCallbackFailed(tempMessageId)
                        }
                    )
                }

                override fun openStickerView() {
                    showStickerView()
                    activity?.currentFocus?.clearFocus()
                    KeyboardUtils.hideSoftInput(binding.viewChatFooter)
                }

                override fun closeStickerView() {
                    hideStickerView()
                }

                override fun openTimer() {
                    viewModel.timeOutSecretChat.value?.let {
                        SetTimeDeleteDialog().show(
                            childFragmentManager,
                            it
                        )
                    }
                }

                override fun onPickMediaClicked() {
                    checkPermissionStorage(
                        {
                            handleActionPickMediaFile()
                        },
                        {
                        }
                    )
                }

                override fun onSendReplyMessage(text: String, replyMessage: NeMessage) {
                    Logger.t(TAG)?.d("__onSendReplyMessage *********")
                    viewModel.createMessage(
                        message = text,
                        optMessage = replyMessage,
                        isMentionAll = text.contains("@All"),
                        type = MessageType.MESSAGE_TYPE_REPLY,
                        callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                            callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
                        },
                        callbackError = { error, tempMessageId ->
                            createMessageCallbackFailed(tempMessageId = tempMessageId)
                        }
                    )
                }

                override fun onSendForwardMessage(text: String, forwardMessage: NeMessage) {
                    Logger.d("__onSendForwardMessage ***********")
                    viewModel.createMessage(
                        message = text,
                        optMessage = forwardMessage,
                        isMentionAll = text.contains("@All"),
                        type = MessageType.MESSAGE_TYPE_FORWARD,
                        callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                            callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
                        },
                        callbackError = { error, tempMessageId ->
                            createMessageCallbackFailed(tempMessageId = tempMessageId)
                        }
                    )
                }

                override fun onDraftMessage(content: String) {
/*
                * Show draft message
                * */
                    draftContent = getContentMention(input = content)
                }

                override fun openMention() {
                    if (neGroup.type == GroupType.GROUP_TYPE_GROUP) {
                        chatMentionAdapter.display(viewModel.getMentionMembers())
                        binding.rcvMention.isVisible = true
                    }
                }

                override fun openMentionFilter(filter: String) {
                    if (neGroup.type == GroupType.GROUP_TYPE_GROUP) {
                        chatMentionAdapter.display(
                            viewModel.getMentionMembers().filter {
                                it.getDisplayName.unAccentText().contains(filter.unAccentText(), true)
                            }
                        )
                        binding.rcvMention.visibility = View.VISIBLE
                    }
                }

                override fun closeMention() {
                    if (neGroup.type == GroupType.GROUP_TYPE_GROUP) {
                        binding.rcvMention.visibility = View.GONE
                        chatMentionAdapter.display(emptyList())
                    }
                }

                override fun onNotificationGroup() {
                    viewModel.groupActionNotification(
                        neGroup,
                        object : CallbackResult<NeGroup> {
                            override fun callBackSuccess(result: NeGroup) {
                                neGroup = result
                                initFooterGroup(neGroup)
                            }

                            override fun callBackError(error: String?) {
                            }
                        }
                    )
                }
            }
        )

        listChatAdapter.setItemClickListener(
            listener = object : ItemClickListener {
                override fun onLongItemClick(neMessage: NeMessage) {
                    messageForward = neMessage
                    viewModel.showAction(neMessage, neGroup)
                }

                override fun onDisplayImage(
                    position: Int,
                    images: List<String>?,
                    messageId: String?
                ) {
                    Logger.d("display image : $images")
                    images?.let {
                        try {
                            // val mediaUid = images[position].split("/").last()
                            viewModel.displayMedia(
                                images[position],
                                neGroup,
                                MessageType.MESSAGE_TYPE_IMAGE,
                                messageId
                            )
                        } catch (e: Exception) {
                            FirebaseCrashlytics.getInstance().recordException(e)
                            e.printStackTrace()
                        }
                    }
                }

                override fun onViewVideo(position: Int, neVideo: NeVideo) {
                    Logger.d("display video : $neVideo")
                    neVideo.url?.let { url ->
                        try {
                            // val mediaUid = it.split("/").last()
                            viewModel.displayMedia(url, neGroup, MessageType.MESSAGE_TYPE_VIDEO)
                        } catch (e: Exception) {
                            FirebaseCrashlytics.getInstance().recordException(e)
                            e.printStackTrace()
                        }
                    }
                }

                override fun onDocumentAction(
                    messageId: String?,
                    docItem: NeDocument,
                    itemClickedPos: Int,
                    isDownload: Boolean
                ) {
                    Logger.d("display document : $docItem")
                    docItem.url?.let { fileUrl ->
                        if (fileUrl.contains(Environment.getExternalStorageState())) {
                            File(fileUrl).let { localFile ->
                                FileUtils.openFile(
                                    context = requireContext(),
                                    file = localFile,
                                    callback = {
                                        showSnackBar(R.string.not_open_file)
                                    }
                                )
                            }
                        } else {
                            mainSdkViewModel.handleFile(
                                neGroup.isSecretChat(),
                                messageId,
                                docItem,
                                requireContext()
                            )
                        }
                    }
                }

                override fun onAvatarClicked(member: NeUser?) {
                    member?.let {
                        viewModel.showSingleMember(it)
                    }
                }

                override fun onRetryMessage(neMessage: NeMessage) {
                    viewModel.getMessageById(messageId = neMessage.id)?.let { dbMessageEntity ->
                        viewModel.retryMessage(
                            dbMessageEntity,
                            context = requireContext(),
                            callbackSuccess = { neRetryMessage ->
                                listChatAdapter.updateRetryMessage(neRetryMessage)
                                scrollToNewMessage(
                                    recyclerView = binding.rcvChat,
                                    position = listChatAdapter.itemCount
                                )
                            },
                            callBackError = { isError ->
                                if (isError) {
                                    showSnackBar(getString(R.string.text_message_retry_fail))
                                }
                            },
                            callbackCompressProgress = { messageId, compress, index, compressId, uploadId, mergeId ->
                                callBackCompressProgressMessage(
                                    messageId,
                                    compress,
                                    index,
                                    compressId,
                                    uploadId,
                                    mergeId
                                )
                            },
                            callbackUploadProgress = { messageId, progress, size, index, compressId, uploadId, mergeId ->
                                callBackUploadProgressMessage(
                                    messageId,
                                    progress,
                                    size,
                                    index,
                                    compressId,
                                    uploadId,
                                    mergeId
                                )
                            }
                        )
                    }
                }

                override fun onCallVoiceOrVideo(messageInfo: NeMessage?, isVoice: Boolean) {
                    if (isVoice) {
                        neUser?.let {
                            // call if user not block
                            if (neGroup.blockers.isNullOrEmpty()) {
                                checkCall(receiverId = it.id, isVideoEnable = false)
                            }
                        }
                    } else {
                        // call if user not block
                        neUser?.let {
                            if (neGroup.blockers.isNullOrEmpty()) {
                                checkCall(receiverId = it.id, isVideoEnable = true)
                            }
                        }
                    }
                }

                override fun onLocationClick(neLocation: NeLocation, neMessage: NeMessage) {
                    viewModel.showPickPhoto(neMessage)
                }

                override fun onScrollToPosition(position: Int) {
                    binding.rcvChat.smoothScrollToPosition(position)
                    MainScope().launch {
                        delay(500)
                        binding.rcvChat.findViewHolderForAdapterPosition(position)?.let { view ->
                            val scale = ScaleAnimation(0F, 1F, 0F, 1F, ScaleAnimation.RELATIVE_TO_SELF, .5f, ScaleAnimation.RELATIVE_TO_SELF, .5f)
                            scale.duration = 1000
                            scale.interpolator = OvershootInterpolator()
                            scale.repeatCount = 1
                            view.itemView.startAnimation(scale)
                        }
                    }
                }
            }
        )

        viewModel.messageFunctionReply.observeOnce { neMessage ->
            binding.viewChatFooter.showReplying(isEncrypt = neGroup.isSecretChat(), message = neMessage, members = neGroup.members ?: mutableListOf())
        }

        viewModel.messageFunctionCopy.observeOnce { neMessage ->
            (context?.getSystemService(Context.CLIPBOARD_SERVICE) as? ClipboardManager)
                ?.setPrimaryClip(
                    ClipData.newPlainText(
                        getString(R.string.copy_to_clipboard),
                        neMessage.content
                    ).apply {
                        showSnackBar(R.string.copy_to_clipboard)
                    }
                )
        }

        viewModel.deleteMessage.observeOnce { messageId ->
            listChatAdapter.deleteMessage(messageId)
        }

        viewModel.messageFunctionShare.observeOnce { neMessage ->
            launch(Dispatchers.IO) {
                viewModel.doActionShare(requireContext(), neMessage)?.let {
                    withContext(Dispatchers.Main) {
                        val shareIntent = Intent.createChooser(it, getString(R.string.app_name))
                        startActivity(shareIntent)
                    }
                }
            }
        }

        viewModel.dataRetryMessage.observeOnce { neRetryMessage ->
            listChatAdapter.updateRetryMessage(neRetryMessage)
            scrollToNewMessage(
                recyclerView = binding.rcvChat,
                position = listChatAdapter.itemCount
            )
        }

        if (neGroup.isSecretChat()) {
            viewModel.timeOutSecretChat.observe { timer ->
                timer?.let {
                    this@BaseChatFragment.binding.viewChatFooter.setTimer(it)
                }
                neGroup.timeOut = timer
            }

            mainSdkViewModel.acceptSecretChat.observe { neGroup ->
                if (neGroup != null) {
                    binding.viewSecretWaitingAccept.isGone = true
                } else {
                    binding.viewSecretWaitingAccept.isVisible = true
                }
            }

            mainSdkViewModel.deleteSecretGroup.observe { groupId ->
                if (groupId.toString() == neGroup.id) {
                    binding.tvSecretContent.text =
                        resources.getString(R.string.secret_can_not_answer)
                    binding.viewSecretWaitingAccept.isVisible = true
                    binding.toolbar.hideCallAndVideo()
                    KeyboardUtils.hideSoftInput(requireActivity())
                }
            }

            binding.toolbar.initForSecret()
            binding.viewChatFooter.initForSecret()
        } else {
            binding.viewSecretWaitingAccept.isGone = true
        }

        capture.observeOnce { result ->
            result.let {
                viewModel.processFileBeforeUpload(
                    uriPath = it,
                    mediaType = MediaType.PHOTO,
                    context = requireContext(),
                    callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                        callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
                    },
                    callbackError = { error, messageId ->
                        Logger.d(error)
                    },
                    callbackCompressProgress = { _, _, _, _, _, _ -> },
                    callbackUploadProgress = { _, _, _, _, _, _, _ -> }
                )
            }
        }

        viewModel.downloadMediaMessage.observeOnce {
            if (it) {
                showSnackBar(R.string.str_save_success)
            } else {
                showSnackBar(R.string.str_save_fail)
            }
        }
    }

    private fun scrollToNewMessage(
        recyclerView: RecyclerView?,
        position: Int,
        isFore: Boolean = false
    ) {
        if (recyclerView == null || position < 0) return
        recyclerView.post {
            (recyclerView.layoutManager as LinearLayoutManager?)?.findLastCompletelyVisibleItemPosition()?.apply {
                // Logger.e("position=" + position + "findLastCompletelyVisibleItemPosition=" + this + "total=" + (position - this))
                try {
                    val newPosition = position - this
                    if (newPosition <= 20 || isFore) {
                        binding.fabScrollDown.isInvisible = true
                        recyclerView.smoothScrollToPosition(position)
                    } else if (newPosition >= 50) {
                        binding.fabScrollDown.isInvisible = true
                        recyclerView.scrollToPosition(position - 1)
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                    FirebaseCrashlytics.getInstance().recordException(e)
                }
            }
        }
    }

    private fun scrollToLastMessage(recyclerView: RecyclerView?) {
        if (recyclerView == null) return
        recyclerView.smoothScrollToPosition(listChatAdapter.itemCount)
    }

    private fun processForStartRecordVoice() {
        /*val hasPermissionStore = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            Environment.isExternalStorageManager() && ContextCompat.checkSelfPermission(requireContext(), Manifest.permission.RECORD_AUDIO) == PackageManager.PERMISSION_GRANTED
        } else {
            ContextCompat.checkSelfPermission(requireContext(), Manifest.permission.READ_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED ||
                ContextCompat.checkSelfPermission(requireContext(), Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED ||
                ContextCompat.checkSelfPermission(requireContext(), Manifest.permission.RECORD_AUDIO) == PackageManager.PERMISSION_GRANTED
        }*/
        val hasPermissionStore = ContextCompat.checkSelfPermission(requireContext(), Manifest.permission.READ_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED ||
            ContextCompat.checkSelfPermission(requireContext(), Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED ||
            ContextCompat.checkSelfPermission(requireContext(), Manifest.permission.RECORD_AUDIO) == PackageManager.PERMISSION_GRANTED
        if (hasPermissionStore) {
            startRecordVoiceMessage()
        } else {
            checkPermissionRecordAudio(
                {
                    startRecordVoiceMessage()
                },
                {}
            )
        }
    }

    /*
    * RECORD
    * */
    private fun startRecordVoiceMessage() {
        mediaRecordHelper = MediaRecordHelper()
        mediaRecordHelper?.startRecord()
        binding.viewChatFooter.startAudioRecord(isStart = true)
    }

    private fun processForStopRecordVoice() {
        try {
            mediaRecordHelper?.stopRecord()
            binding.viewChatFooter.startAudioRecord(isStart = false)
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }

    private fun processSendVoiceMessage() {
        val duration = mediaRecordHelper?.recordDuration() ?: 0L
        val fileRecord = mediaRecordHelper?.recordFile()
        if (duration >= 1 && fileRecord != null) {
            sendVoiceMessage(duration, fileRecord)
        }
    }

    private fun sendVoiceMessage(recordDuration: Long, fileRecord: File) {
        viewModel.processFileBeforeUpload(
            file = fileRecord,
            mediaType = MediaType.AUDIO,
            duration = recordDuration,
            context = requireContext(),
            callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                Logger.d("Upload Audio Success")
                callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
            },
            callbackError = { it, messageid ->
                Logger.e(it)
            },
            callbackCompressProgress = { _, _, _, _, _, _ -> },
            callbackUploadProgress = { _, _, _, _, _, _, _ -> }
        )
    }

    private fun getContentMention(input: String): String {
        var result = input
        viewModel.getMentionMembers().forEach { neUser ->
            result = result.replace("@${neUser.getDisplayName}", "@${neUser.id}")
        }
        if (result.contains("@1 ")) result = result.replace("@1 ", "@All ")
        return result
    }

    private fun createMessageCallback(neSubMessages: List<NeSubMessage>) {
        try {
            listChatAdapter.addNewMessage(neSubMessages)
            /*scrollToNewMessage(
                recyclerView = binding.rcvChat,
                position = listChatAdapter.itemCount
            )*/
            MainScope().launch {
                delay(200)
                try {
                    if (activity?.isFinishing == false) {
                        scrollToLastMessage(recyclerView = binding.rcvChat)
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }

    private fun createMessageCallbackSuccess(tempMessageId: String?, neMessage: NeMessage?) {
        listChatAdapter.createMessageSuccess(
            tempMessageId = tempMessageId,
            neMessage = neMessage,
            lifecycleScope = lifecycleScope
        )
    }

    private fun createMessageCallbackFailed(tempMessageId: String?) {
        listChatAdapter.createMessageFail(tempMessageId = tempMessageId)
    }

// STICKER

    private var maxY = 0
    private var newMargin = 0
    private var isTouch = false

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        newMargin = AppUtils.dpToPx(requireContext(), 250f)

        binding.flRoot.afterMeasured {
            maxY = binding.flRoot.height - AppUtils.dpToPx(requireContext(), 20f)
        }
        binding.llSticker.afterMeasured {
            if (isTouch || height > newMargin) {
                binding.vOverlay.isVisible = true
                binding.vOverlay.alpha = (height - newMargin).toFloat() / maxY
            } else {
                binding.vOverlay.isGone = true
                binding.vOverlay.alpha = 0f
            }
        }
    }

    @SuppressLint("ClickableViewAccessibility")
    private fun showStickerView() {
        with(binding) {
            val layoutParam = viewChatLine.layoutParams as LinearLayout.LayoutParams
            val animation = object : Animation() {
                override fun applyTransformation(interpolatedTime: Float, t: Transformation?) {
                    val h = (newMargin * interpolatedTime).toInt()
                    layoutParam.setMargins(0, 0, 0, h)
                    llSticker.layoutParams.height = h
                    viewChatLine.requestLayout()
                }
            }
            animation.duration = 300
            viewChatLine.startAnimation(animation)

            flPullSticker.setOnTouchListener(
                object : View.OnTouchListener {
                    var alphaY = 0F
                    var deltaY = 0
                    var actionUp = false

                    override fun onTouch(view: View, event: MotionEvent): Boolean {
                        val hy = llSticker.height

                        when (event.action) {
                            MotionEvent.ACTION_DOWN -> {
                                alphaY = event.y
                                deltaY = hy
                                isTouch = true
                            }
                            MotionEvent.ACTION_UP -> {
                                isTouch = false
                                if (actionUp) {
                                    val deltaH = maxY - deltaY
                                    val animationUp = object : Animation() {
                                        override fun applyTransformation(
                                            interpolatedTime: Float,
                                            t: Transformation?
                                        ) {
                                            llSticker.layoutParams.height =
                                                deltaY + (deltaH * interpolatedTime).toInt()
                                            llSticker.requestLayout()
                                        }
                                    }
                                    animationUp.duration = 300
                                    llSticker.startAnimation(animationUp)
                                } else {
                                    val deltaH = deltaY - newMargin
                                    val animationDown = object : Animation() {
                                        override fun applyTransformation(
                                            interpolatedTime: Float,
                                            t: Transformation?
                                        ) {
                                            llSticker.layoutParams.height =
                                                deltaY - (deltaH * interpolatedTime).toInt()
                                            llSticker.requestLayout()
                                        }
                                    }
                                    animationDown.duration = 300
                                    llSticker.startAnimation(animationDown)
                                }
                            }
                            MotionEvent.ACTION_POINTER_DOWN -> {
                                // TODO: nothing
                            }
                            MotionEvent.ACTION_POINTER_UP -> {
                                // TODO: nothing
                            }
                            MotionEvent.ACTION_MOVE -> {
                                var newH = (hy - event.y + alphaY).toInt()
                                if (newH < newMargin) newH = newMargin
                                else if (newH > maxY) newH = maxY
                                actionUp = newH > deltaY
                                deltaY = newH
                                llSticker.layoutParams.height = newH
                                llSticker.requestLayout()
                            }
                        }

                        return true
                    }
                }
            )
        }
    }

    private fun hideStickerView() {
        with(binding) {
            val margin = viewChatLine.marginBottom
            val layoutParam = viewChatLine.layoutParams as LinearLayout.LayoutParams
            val animation = object : Animation() {
                override fun applyTransformation(interpolatedTime: Float, t: Transformation?) {
                    val h = (margin * (1 - interpolatedTime)).toInt()
                    layoutParam.setMargins(0, 0, 0, h)
                    llSticker.layoutParams.height = h
                    viewChatLine.requestLayout()
                }
            }
            animation.duration = 300
            viewChatLine.startAnimation(animation)
        }
    }

    private lateinit var stickerCategoryAdapter: StickerCategoryAdapter
    private lateinit var dCategoryStickerAdapter: DCategoryStickerAdapter

    private fun initStickerView() {
        with(binding) {
            vpStickerList.adapter = DCategoryStickerAdapter(context = requireContext()).apply {
                dCategoryStickerAdapter = this
                dCategoryStickerAdapter.setOnStickerClick(
                    object : DCategoryStickerAdapter.StickerClickListener {
                        override fun onClick(neSticker: NeSticker, time: Long) {
                            lifecycleScope.launch(Dispatchers.IO) {
                                this@BaseChatFragment.viewModel.recentStickerClick(
                                    stickerId = neSticker.id,
                                    time = time
                                )
                            }
                            sentSticker(neSticker = neSticker)
                        }
                    }
                )
            }
            stickerCategoryAdapter = StickerCategoryAdapter(
                themeHelperImpl = themeHelperImpl,
                stickerCategoryClick = {
                    dCategoryStickerAdapter.initView(position = it)
                    vpStickerList.setCurrentItem(it, false)
                },
                { _, _, _ ->
                }
            )

            rcvStickerCategory.adapter = stickerCategoryAdapter

            getStickerCategory()

            this@BaseChatFragment.viewModel.stickerRepository.stickerAvailable.observeForever { status ->
                if (status != null && status == true) {
                    getStickerCategory()
                }
            }
        }
    }

    private fun getStickerCategory() {
        this@BaseChatFragment.viewModel.getStickerCategory(
            callbackSuccess = { subNeCategories, isUpdate ->
                if (isUpdate) this@BaseChatFragment.viewModel.getListMessage()
                dCategoryStickerAdapter.setPageData(subNeCategories = subNeCategories)
                stickerCategoryAdapter.display(subNeCategories)
                for ((i, entry) in subNeCategories.withIndex()) {
                    if (entry.isSelect) {
                        dCategoryStickerAdapter.initView(position = i)
                        binding.vpStickerList.setCurrentItem(i, false)
                        break
                    }
                }

                binding.vpStickerList.addOnPageChangeListener(
                    object : ViewPager.OnPageChangeListener {

                        var currentPage: Int = 0
                        var mPreviousPosition: Int = -1

                        override fun onPageScrollStateChanged(state: Int) {
                            val pageCount = dCategoryStickerAdapter.count - 1
                            if (state == ViewPager.SCROLL_STATE_IDLE) {
                                if (currentPage in 1 until pageCount) {
                                    binding.rcvStickerCategory.smoothScrollToPosition(currentPage)
                                    stickerCategoryAdapter.setSelect(position = currentPage)
                                    dCategoryStickerAdapter.initView(position = currentPage)
                                    binding.vpStickerList.setCurrentItem(currentPage, false)
                                } else {
                                    if (mPreviousPosition == currentPage || mPreviousPosition == -1) {
                                        if (currentPage == 0) {
                                            binding.rcvStickerCategory.smoothScrollToPosition(pageCount)
                                            stickerCategoryAdapter.setSelect(position = pageCount)
                                            dCategoryStickerAdapter.initView(position = pageCount)
                                            binding.vpStickerList.setCurrentItem(pageCount, false)
                                        } else {
                                            binding.rcvStickerCategory.smoothScrollToPosition(0)
                                            stickerCategoryAdapter.setSelect(position = 0)
                                            dCategoryStickerAdapter.initView(position = 0)
                                            binding.vpStickerList.setCurrentItem(0, false)
                                        }
                                    } else {
                                        binding.rcvStickerCategory.smoothScrollToPosition(currentPage)
                                        stickerCategoryAdapter.setSelect(position = currentPage)
                                        dCategoryStickerAdapter.initView(position = currentPage)
                                        binding.vpStickerList.setCurrentItem(currentPage, false)
                                    }
                                }
                                mPreviousPosition = currentPage
                            }
                        }

                        override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {}

                        override fun onPageSelected(position: Int) {
                            currentPage = position
                        }
                    }
                )
            }
        )
    }

    private fun sentSticker(neSticker: NeSticker) {
        viewModel.createStickerMessage(
            neSticker = neSticker,
            callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
            },
            callbackError = { error, tempMessageId ->
                createMessageCallbackFailed(tempMessageId)
            }
        )
    }

    fun isShowSticker(): Boolean {
        return binding.llSticker.height > 0
    }

    fun backHideStickerView() {
        binding.viewChatFooter.closeSticker()
    }

    private fun handleActionPickMediaFile() {
        /*
        * Action pick media (Photos, Videos, Files)
        * */
        viewModel.openChooseMediaFragment(isChat = true)
    }

    private fun callBackSuccessMessage(
        neSubMessages: List<NeSubMessage>,
        tempMessageId: String?,
        neMessage: NeMessage?
    ) {
        if (tempMessageId == null) {
            createMessageCallback(neSubMessages)
        } else {
            createMessageCallbackSuccess(tempMessageId, neMessage)
        }
//        mainSdkViewModel.syncGroup(LIST_SYNC_DB)
    }

    private fun callBackCompressProgressMessage(
        messageId: String?,
        compress: Int,
        index: Int?,
        compressId: String?,
        uploadId: String?,
        mergeId: String?
    ) {
        listChatAdapter.updateMessageCompressProgress(
            messageId = messageId,
            compress = compress,
            index = index,
            compressId = compressId,
            uploadId = uploadId,
            mergeId = mergeId,
            lifecycleScope = lifecycleScope
        )
    }

    private fun callBackUploadProgressMessage(
        messageId: String?,
        progress: Long,
        size: Long,
        index: Int?,
        compressId: String?,
        uploadId: String?,
        mergeId: String?
    ) {
        listChatAdapter.updateMessageUploadProgress(
            messageId = messageId,
            progress = progress,
            size = size,
            index = index,
            compressId = compressId,
            uploadId = uploadId,
            mergeId = mergeId,
            lifecycleScope = lifecycleScope
        )
    }

    private fun swipeForReply() {
        val messageSwipeController = MessageSwipeController(
            requireContext(),
            object : MessageSwipeController.SwipeControllerActions {
                override fun showReplyUI(position: Int) {
                    listChatAdapter.getData[position].neMessage?.let {
                        binding.viewChatFooter.showReplying(isEncrypt = neGroup.isSecretChat(), message = it, members = neGroup.members ?: mutableListOf())
                    }
                }
            },
            themeHelperImpl = themeHelperImpl
        )

        val itemTouchHelper = ItemTouchHelper(messageSwipeController)
        itemTouchHelper.attachToRecyclerView(binding.rcvChat)
    }

    private fun setupScrollDown() {
        binding.fabScrollDown.isInvisible = true

        binding.rcvChat.addOnScrollListener(
            object : RecyclerView.OnScrollListener() {

                override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                    super.onScrollStateChanged(recyclerView, newState)
                    if (newState == RecyclerView.SCROLL_STATE_IDLE && !recyclerView.canScrollVertically(1)) {
                        binding.fabScrollDown.isInvisible = true
                    } else {
                        binding.fabScrollDown.show()
                    }
                }
            }
        )

        binding.fabScrollDown.clickDebounce {
            scrollToNewMessage(binding.rcvChat, listChatAdapter.itemCount, isFore = true)
        }
    }

    private var indexMention = 0
    private fun setupScrollMention() {
        binding.fabScrollMention.clickDebounce {
            preferencesHelperImpl.user?.let { ownerUser ->

                listChatAdapter.getData.reversed().let { listChat ->

                    listChat.find {
                        AppUtils.getMessagesHasOwnerMention(
                            it.neMessage?.content.toString(),
                            ownerUser
                        ) && listChat.indexOf(it) > indexMention
                    }?.run {
                        binding.fabScrollDown.show()
                        val position = listChat.indexOf(this)
                        indexMention = position

                        // detect mention to hide button
                        listChat.find {
                            AppUtils.getMessagesHasOwnerMention(
                                it.neMessage?.content.toString(),
                                ownerUser
                            ) && listChat.indexOf(it) > indexMention
                        }.run {
                            if (this.isNull) {
                                // Can't find mention , hide button
                                binding.fabScrollMention.hide()
                            }
                        }
                        // Logger.d("mention - message :${this.neMessage?.content} position = $position")
                        val positionInAdapter = listChatAdapter.getData.indexOf(this)
                        binding.rcvChat.smoothScrollToPosition(positionInAdapter)
                    }
                }
            }
        }
    }

    private fun detectMention() {
        preferencesHelperImpl.user?.let { ownerUser ->
            listChatAdapter.getData.find {
                AppUtils.getMessagesHasOwnerMention(it.neMessage?.content.toString(), ownerUser)
            }?.run {
                binding.fabScrollMention.isVisible = true
            }
        }
    }

    private fun resultListener() {
        setFragmentResultListener(SelectMediaFragment.SELECT_PHOTO_VIDEO) { _, bundle ->
            bundle.getParcelableArrayList<LocalFileModel>("data")?.let { media ->
                if (media.isNotEmpty()) {
                    /*
                    * Note Logic:
                    * list selected media maybe contain photos and videos
                    * => if just photos => upload photo inside 1 message
                    * => if just video:
                    * * -> 1 video => upload video inside 1 message
                    * * -> many videos => upload many video inside many message
                    * => if contain photos and video:
                    * * -> upload all photos inside 1 message
                    * * -> upload many video inside many message
                    * */
                    media.filter { path -> Constants.VIDEO_PATTEN.contains(path.fileExtension) }
                        .map { videoPath ->
                            /*
                            * Logic upload video:
                            * - Check size of video
                            * - If size < 250Mb => process upload video
                            * - else => show popup error (required video size <= 250Mb)
                            * */
                            AppUtils.checkVideoUploadFile(videoPath.filePath).let {
                                if (it != -1F) {
                                    viewModel.processForUploadMediaMessage(
                                        compressRatio = it,
                                        listOf(videoPath),
                                        MediaType.VIDEO,
                                        context = requireContext(),
                                        callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                                            Logger.d("Upload Video Success")
                                            callBackSuccessMessage(
                                                neSubMessages,
                                                tempMessageId,
                                                neMessage
                                            )
                                        },
                                        callbackError = { error, tempMessageId ->
                                            Logger.d("Upload Video Fail: messID = $tempMessageId - error = $error")
                                        },
                                        callbackCompressProgress = { messageId, compress, index, compressId, uploadId, mergeId ->
                                            callBackCompressProgressMessage(
                                                messageId,
                                                compress,
                                                index,
                                                compressId,
                                                uploadId,
                                                mergeId
                                            )
                                        },
                                        callbackUploadProgress = { messageId, progress, size, index, compressId, uploadId, mergeId ->
                                            callBackUploadProgressMessage(
                                                messageId,
                                                progress,
                                                size,
                                                index,
                                                compressId,
                                                uploadId,
                                                mergeId
                                            )
                                        }
                                    )
                                } else {
                                    DialogUtil.showError(
                                        context = requireContext(),
                                        title = R.string.popup_confirm,
                                        message = R.string.popup_str_max_video_size_message,
                                        cancelable = false
                                    )
                                }
                            }
                        }

                    media.filterNot { path -> Constants.VIDEO_PATTEN.contains(path.fileExtension) }
                        .apply {
                            if (this.isNotEmpty()) {
                                viewModel.processForUploadMediaMessage(
                                    compressRatio = null,
                                    this,
                                    MediaType.PHOTO,
                                    context = requireContext(),
                                    callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                                        Logger.d("Upload Photo Success")
                                        callBackSuccessMessage(
                                            neSubMessages,
                                            tempMessageId,
                                            neMessage
                                        )
                                    },
                                    callbackError = { error, tempMessageId ->
                                        Logger.d("Upload Photo Fail: messID = $tempMessageId - error = $error")
                                    },
                                    callbackCompressProgress = { messageId, compress, index, compressId, uploadId, mergeId ->
                                        callBackCompressProgressMessage(
                                            messageId,
                                            compress,
                                            index,
                                            compressId,
                                            uploadId,
                                            mergeId
                                        )
                                    },
                                    callbackUploadProgress = { messageId, progress, size, index, compressId, uploadId, mergeId ->
                                        callBackUploadProgressMessage(
                                            messageId,
                                            progress,
                                            size,
                                            index,
                                            compressId,
                                            uploadId,
                                            mergeId
                                        )
                                    }
                                )
                            }
                        }
                }
            }
        }
        setFragmentResultListener(SelectMediaFragment.SELECT_FILE) { _, bundle ->
            bundle.getParcelable<LocalFileModel>("data")?.let { document ->
                /*
                * Note Logic upload file (pdf, word, excel, powerpoint
                * - After selected file => check size
                * - Size < 250 Mb => upload to server => send message with type document
                * - Size > 250 Mb => show popup confirm cannot send large size
                * */
                if (AppUtils.convertSizeToMB(com.netacom.base.chat.android_utils.FileUtils.getFileLength(document.filePath)) < Constants.DOC_MEDIA_MAX_SIZE) {
                    viewModel.processForUploadMediaMessage(
                        compressRatio = null,
                        listOf(document),
                        MediaType.FILE,
                        callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                            Logger.d("Upload File Success")
                            callBackSuccessMessage(neSubMessages, tempMessageId, neMessage)
                        },
                        callbackError = { error, tempMessageId ->
                            Logger.d("Upload File Fail: messID = $tempMessageId - error = $error")
                        },
                        callbackCompressProgress = { messageId, compress, index, compressId, uploadId, mergeId ->
                            callBackCompressProgressMessage(
                                messageId,
                                compress,
                                index,
                                compressId,
                                uploadId,
                                mergeId
                            )
                        },
                        callbackUploadProgress = { messageId, progress, size, index, compressId, uploadId, mergeId ->
                            callBackUploadProgressMessage(
                                messageId,
                                progress,
                                size,
                                index,
                                compressId,
                                uploadId,
                                mergeId
                            )
                        }
                    )
                } else {
                    DialogUtil.showError(
                        context = requireContext(),
                        title = R.string.popup_confirm,
                        message = R.string.popup_str_max_doc_size_message,
                        cancelable = false
                    )
                }
            }
        }
    }

    override fun onResume() {
        super.onResume()
        NetAloSDK.fragmentDisplay = Constants.BASE_CHAT_FRAGMENT
        NetAloSDK.activeGroup = neGroup.id
        viewModel.isCalling = false
        shotWatch?.register()
        ChatSecretUtils.setActiveSecretGroupId(neGroup.id ?: "")
    }

    override fun onPause() {
        super.onPause()
        shotWatch?.unregister()
        NetAloSDK.fragmentDisplay = null
        NetAloSDK.activeGroup = null
        ChatSecretUtils.clearActiveSecretGroupId()
    }

    override fun onDestroyView() {
        super.onDestroyView()
        if (!viewModel.isCalling) {
            viewModel.destroy()
        }
        try {
            playerExoHelper.stopExoPlayer()
            playerExoHelper.releaseExoPlayer()
        } catch (e: Exception) {
        }

        if (mediaRecordHelper?.isRecording() == true) {
            Logger.d("ALO-1923 - recording")
            processForStopRecordVoice()
        }
    }

    private fun showBlockPopup(blockUser: NeUser) {
        val titleBlock = requireContext().resources.getString(R.string.block_alert_title, blockUser.getDisplayName)
        val messageBlock = requireContext().resources.getString(R.string.block_alert_message, blockUser.getDisplayName)
        DialogUtil.show(
            context = requireContext(),
            titleStr = titleBlock,
            messageStr = messageBlock,
            cancelLabel = R.string.str_cancel,
            okLabel = R.string.block_alert_button,
            okFunc = {
                blockUser.id?.let { blockIds ->
                    viewModel.blockUser(
                        neGroup,
                        blockIds,
                        object : CallbackResult<Boolean> {
                            override fun callBackSuccess(result: Boolean) {
                                showSnackBar(R.string.block_user_success)
                            }

                            override fun callBackError(error: String?) {
                                showSnackBar(R.string.block_user_unsuccess)
                            }
                        }
                    )
                }
            },
            themeHelperImpl = themeHelperImpl
        )
    }

    private fun processSendForwardMessage() {
        /*Note logic for forward message:
        * if message [is not audio message]:
        * => do with normal logic => forward message with attachment is a message want to forward
        * if message [is audio message]:
        * => don't dhow in chat footer
        * => created normal message media with type is audio using audio attachment from message want to forward
        * => send this message same normal to audio message
        */
        if (viewModel.forwardMedia != null) {
            if (viewModel.isMergeSuccess) {
                // send forward media
                viewModel.forwardMedia?.let { fw ->
                    viewModel.processForUploadMediaMessage(
                        listUploadMedia = listOf(fw),
                        mediaType = MediaType.PHOTO,
                        callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                            callBackSuccessMessage(
                                neSubMessages,
                                tempMessageId,
                                neMessage
                            )
                        },
                        callbackError = { error, messageId ->
                            Logger.d("Upload Forward Photo Fail")
                        },
                        callbackCompressProgress = { messageId, compress, index, compressId, uploadId, mergeId ->
                            callBackCompressProgressMessage(
                                messageId,
                                compress,
                                index,
                                compressId,
                                uploadId,
                                mergeId
                            )
                        },
                        callbackUploadProgress = { messageId, progress, size, index, compressId, uploadId, mergeId ->
                            callBackUploadProgressMessage(
                                messageId,
                                progress,
                                size,
                                index,
                                compressId,
                                uploadId,
                                mergeId
                            )
                        }
                    )
                    viewModel.isForwardMessage = false
                    viewModel.forwardMedia = null
                    viewModel.forwardSelectedGroup = null
                }
            }
        } else {
            val messageForwardType = messageForward?.type ?: MessageType.MESSAGE_TYPE_TEXT
            if (messageForwardType != MessageType.MESSAGE_TYPE_AUDIO) {
                binding.viewChatFooter.showForwarding(
                    message = messageForward,
                    members = neGroup.members
                )
                viewModel.isForwardMessage = false
            } else {
                messageForward?.let { forward ->
                    viewModel.sendForwardMessageAudio(
                        forwardAudio = forward,
                        callbackSuccess = { neSubMessages, tempMessageId, neMessage ->
                            callBackSuccessMessage(
                                neSubMessages,
                                tempMessageId,
                                neMessage
                            )
                        },
                        callbackError = { error, tempMessageId ->
                            createMessageCallbackFailed(tempMessageId = tempMessageId)
                        }
                    )
                    viewModel.isForwardMessage = false
                }
            }
        }
    }

    private fun showChangeBackground() {
        viewModel.getBackgroundImages(
            object : CallbackResult<List<ImageBackgroundResponse.ImageBackground>> {
                override fun callBackSuccess(result: List<ImageBackgroundResponse.ImageBackground>) {
                    with(binding.containChangeBackground) {
                        root.isVisible = true
                        backgroundChangeAdapter = ChangeBackgroundAdapter(
                            { backgroundImage, _, _ ->
                                // on selected background
                                previewBackgroundUrl = backgroundImage.backgroundUrl
                                // for preview background
                                if (backgroundImage.backgroundId == DEFAULT_BACKGROUND) {
                                    resetBackgroundDefault()
                                } else {
                                    applyBackgroundChat(backgroundImage.backgroundUrl, isBlur)
                                }
                                backgroundChangeAdapter?.setSelectedBackgroundUrl(backgroundImage.backgroundUrl)
                            },
                            previewBackgroundUrl,
                            themeHelperImpl
                        ).apply {
                            val listBackground = mutableListOf<ImageBackgroundResponse.ImageBackground>()
                            // add default background
                            listBackground.add(ImageBackgroundResponse.ImageBackground(backgroundId = DEFAULT_BACKGROUND, backgroundUrl = ""))
                            listBackground.addAll(result)
                            display(listBackground)
                        }
                        binding.toolbar.showChangeBackground()
                        rcvChangeBackground.adapter = backgroundChangeAdapter
                    }
                }

                override fun callBackError(error: String?) {
                    showSnackBar(error)
                }
            }
        )
    }

    private fun applyBackgroundChat(backgroundUrl: String, isBlur: Boolean = true) {
        binding.llBackground.loadImageBackground(backgroundUrl, isBlur)
        binding.toolbar.applyBackground(backgroundUrl)
    }

    private fun applyLocalBackground(neGroup: NeGroup) {
        neGroup.localBackground?.let { _neBackground ->
            _neBackground.background_url?.let { _url ->
                if (_url.isNotEmpty()) {
                    previewBackgroundUrl = _url
                    applyBackgroundChat(_url, _neBackground.is_blur)
                }
                if (_neBackground.is_blur) {
                    binding.containChangeBackground.ivCheckBlur.setImageResource(R.drawable.ic_single_check)
                    isBlur = true
                }
            }
        }
    }

    private fun applyServerBackground(neGroup: NeGroup) {
        neGroup.background?.let { _neBackground ->
            _neBackground.background_url?.let { _url ->
                if (_url.isNotEmpty()) {
                    previewBackgroundUrl = _url
                    applyBackgroundChat(_url, _neBackground.is_blur)
                    applyBackgroundForAll = true
                    binding.containChangeBackground.ivCheckForAll.setImageResource(R.drawable.ic_single_check)
                }
                if (_neBackground.is_blur) {
                    binding.containChangeBackground.ivCheckBlur.setImageResource(R.drawable.ic_single_check)
                    isBlur = true
                }
            }
        }
    }

    private fun resetBackgroundDefault() {
        binding.llBackground.setBackgroundColor(ContextCompat.getColor(requireContext(), R.color.color_background))
    }

    private fun setupBackground() {
        neGroup.id?.let { groupId ->
            viewModel.getGroupDbById(groupId)?.let { _neGroup ->
                if (_neGroup.localBackground.isNotNull) {
                    if (_neGroup.localBackground?.background_url?.isEmpty() == true && _neGroup.background?.background_url?.isNotEmpty() == true) {
                        applyServerBackground(_neGroup)
                    } else {
                        applyLocalBackground(_neGroup)
                    }
                } else {
                    applyServerBackground(_neGroup)
                }
            }
        }
    }

    private fun setupBackgroundConfig() {
        with(binding.containChangeBackground.ivCheckForAll) {
            clickDebounce {
                if (this.drawable.isNotNull) {
                    applyBackgroundForAll = false
                    setImageResource(0)
                } else {
                    setImageResource(R.drawable.ic_single_check)
                    applyBackgroundForAll = true
                }
            }
        }

        with(binding.containChangeBackground.ivCheckBlur) {
            clickDebounce {
                if (this.drawable.isNotNull) {
                    isBlur = false
                    setImageResource(0)
                } else {
                    setImageResource(R.drawable.ic_single_check)
                    isBlur = true
                }
                previewBackgroundUrl?.let { _url ->
                    applyBackgroundChat(_url, isBlur)
                }
            }
        }
    }
}
