/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.chat

import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.Color
import android.net.Uri
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Observer
import androidx.navigation.NavController
import androidx.work.ArrayCreatingInputMerger
import androidx.work.OneTimeWorkRequest
import androidx.work.OneTimeWorkRequestBuilder
import androidx.work.WorkContinuation
import androidx.work.WorkInfo
import androidx.work.WorkManager
import androidx.work.setInputMerger
import androidx.work.workDataOf
import com.google.zxing.BarcodeFormat
import com.google.zxing.MultiFormatWriter
import com.netacom.base.chat.android_utils.ImageUtils
import com.netacom.base.chat.android_utils.IntentUtils
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.android_utils.UriUtils
import com.netacom.base.chat.android_utils.Utils
import com.netacom.base.chat.define.ConfigDef
import com.netacom.base.chat.json.JsonSerializer
import com.netacom.base.chat.livedata.EventLiveData
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.model.ScreenStateObj
import com.netacom.base.chat.network.ApiResponseError
import com.netacom.base.chat.network.ApiResponseSuccess
import com.netacom.base.chat.network.ResultData
import com.netacom.base.chat.type.ScreenState
import com.netacom.base.chat.util.ConvertUtil.convertSize
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKViewModel
import com.netacom.full.dispatchers.Dispatcher
import com.netacom.full.extensions.navigateIfSafe
import com.netacom.full.model.CallInfoModel
import com.netacom.full.worker.upload.CompressWorker
import com.netacom.full.worker.upload.MergeWorker
import com.netacom.full.worker.upload.UploadWorker
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MediaType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.define.MessageType
import com.netacom.lite.define.SocketMessageStatus
import com.netacom.lite.entity.database.attachment.NeAttachments
import com.netacom.lite.entity.database.attachment.NeDocument
import com.netacom.lite.entity.database.attachment.NeLocation
import com.netacom.lite.entity.database.attachment.NeVideo
import com.netacom.lite.entity.database.message.DbMessageAttachmentEntity
import com.netacom.lite.entity.database.message.DbMessageEntity
import com.netacom.lite.entity.database.sticker.DbEmotionEntity
import com.netacom.lite.entity.socket.EventType
import com.netacom.lite.entity.socket.Message
import com.netacom.lite.entity.ui.NeCategory
import com.netacom.lite.entity.ui.NeSticker
import com.netacom.lite.entity.ui.SubNeCategory
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.entity.ui.local.LocalFileModel
import com.netacom.lite.entity.ui.local.UploadFileSuccessModel
import com.netacom.lite.entity.ui.media.NeMedia
import com.netacom.lite.entity.ui.message.NeAudio
import com.netacom.lite.entity.ui.message.NeImage
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.message.NeRetryMessage
import com.netacom.lite.entity.ui.message.NeSubMessage
import com.netacom.lite.entity.ui.theme.NeBackground
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.mapper.Attachment_SK_DB_Mapper
import com.netacom.lite.network.model.FileUpload
import com.netacom.lite.network.model.response.ImageBackgroundResponse
import com.netacom.lite.network.model.response.UploadResult
import com.netacom.lite.repository.ContactRepository
import com.netacom.lite.repository.DownloadRepository
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.repository.MessageRepository
import com.netacom.lite.repository.SocketRepository
import com.netacom.lite.repository.StickerRepository
import com.netacom.lite.repository.UploadRepository
import com.netacom.lite.repository.base.State
import com.netacom.lite.repository.configs.MessageConfig
import com.netacom.lite.repository.secretChat.ChatSecretUtils
import com.netacom.lite.socket.request.CreateMessageRequest
import com.netacom.lite.socket.request.DeleteMessageRequest
import com.netacom.lite.socket.request.RequestEvent
import com.netacom.lite.socket.request.UpdateBackgroundRequest
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.CallbackResult
import com.netacom.lite.util.Constants
import com.netacom.lite.util.Constants.DEFAULT_STICKER_NUMBER
import com.netacom.lite.util.Constants.EMPTY
import com.netacom.lite.util.Constants.RETRY_MESSAGE_CODE
import com.netacom.lite.util.FileUtils
import com.netacom.lite.util.TimerSupport
import com.netacom.lite.util.getUrlImage
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.ObsoleteCoroutinesApi
import kotlinx.coroutines.channels.ticker
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.withContext
import java.io.File
import javax.inject.Inject

/**
Created by vantoan on 30,July,2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/
@HiltViewModel
class ChatViewModel @Inject constructor(
    val downloadRepository: DownloadRepository,
    val groupRepository: GroupRepository,
    private val socketRepository: SocketRepository,
    private val uploadRepository: UploadRepository,
    val messageRepository: MessageRepository,
    private val contactRepository: ContactRepository,
    val stickerRepository: StickerRepository,
    private val attachment_SK_DB_Mapper: Attachment_SK_DB_Mapper,
    private val navigationDispatcher: Dispatcher<(NavController) -> Unit>,
    private val jsonSerializer: JsonSerializer
) : BaseSDKViewModel(socketRepository, groupRepository, navigationDispatcher) {
    private val isShowLog = true
    private var messageConfig: MessageConfig? = null
    val screenState: LiveData<ScreenStateObj> = MutableLiveData()

    private var _listNeMessage = MutableLiveData<EventLiveData<List<NeSubMessage>>>()
    val listNeMessage: LiveData<EventLiveData<List<NeSubMessage>>> = _listNeMessage

    private var _listNeMessageLoadMore = MutableLiveData<EventLiveData<List<NeSubMessage>>>()
    val listNeMessageLoadMore: LiveData<EventLiveData<List<NeSubMessage>>> = _listNeMessageLoadMore

    private var _dataRetryMessage = MutableLiveData<EventLiveData<NeRetryMessage>>()
    val dataRetryMessage: LiveData<EventLiveData<NeRetryMessage>> = _dataRetryMessage

    private var _messageFunctionReply = MutableLiveData<EventLiveData<NeMessage>>()
    val messageFunctionReply: LiveData<EventLiveData<NeMessage>> = _messageFunctionReply

    private var _messageFunctionCopy = MutableLiveData<EventLiveData<NeMessage>>()
    val messageFunctionCopy: LiveData<EventLiveData<NeMessage>> = _messageFunctionCopy

    private var _deleteMessage = MutableLiveData<EventLiveData<String>>()
    val deleteMessage: LiveData<EventLiveData<String>> = _deleteMessage

    private var _messageFunctionShare = MutableLiveData<EventLiveData<NeMessage>>()
    val messageFunctionShare: LiveData<EventLiveData<NeMessage>> = _messageFunctionShare

    private var _downloadMediaMessage = MutableLiveData<EventLiveData<Boolean>>()
    val downloadMediaMessage: LiveData<EventLiveData<Boolean>> = _downloadMediaMessage

    var _timeOutSecretChat = MutableLiveData<Int?>()
    val timeOutSecretChat: LiveData<Int?> = _timeOutSecretChat

    var _addNewContactSuccess = MutableLiveData<EventLiveData<NeUser>>()
    val addNewContactSuccess: LiveData<EventLiveData<NeUser>> = _addNewContactSuccess

    var _createGroupSuccess = MutableLiveData<EventLiveData<NeGroup>>()
    val createGroupSuccess: LiveData<EventLiveData<NeGroup>> = _createGroupSuccess
    val checkHideAddInfo get() = getPreferences.sdkConfig?.hideAddInfo ?: true

    var neGroup: NeGroup? = null
    var isForwardMessage = false
    private var _isLoading = false
    fun isLoading() = _isLoading
    private var _isFirstPage = true
    fun isFirstPage() = _isFirstPage
    private var loadLastMessageSuccess = false
    var pairMissMessage = Pair(0L, 0)
    var countLoadMissMessage = 0

    // forward media
    var forwardMedia: LocalFileModel? = null
    var forwardSelectedGroup: NeGroup? = null
    var isMergeSuccess = false

    var failures = 0
    private val maxFailures = 3

    fun initNeGroup(_neGroup: NeGroup) {
        neGroup = _neGroup
        messageConfig = MessageConfig(group = _neGroup)
        getListMessage()

        if (neGroup?.isSecretChat() == true) {
            launchOnViewModelScope(getPostExecutionThread.io) {
                val timeOut = getTimeOutForSecretChat()
                neGroup?.timeOut = timeOut
                _timeOutSecretChat.post(timeOut)
            }
        }
    }

    fun getListMessage(lastMessage: NeMessage? = null) {
        if (_isLoading) return
        loadLastMessageSuccess = true
        launchOnViewModelScope(getPostExecutionThread.io) {
            messageConfig?.apply {
                this.lastMessageId = lastMessage?.id?.toLongOrNull()
                this.lastMessageCreatedAt = lastMessage?.createAt
                // Logger.e("testLoadMore --------lastMessageId = $lastMessageId--------")
                _isFirstPage = lastMessage == null
                socketRepository.getListMessage(messageConfig = this).collect { state ->
                    isMergeSuccess = false
                    var fullData = false
                    when (state) {
                        is State.SuccessLocal -> {
                            fullData = state.data.size == ConfigDef.PAGE_SIZE_MESSAGE_GET
                            if (isFirstPage() || fullData) {
                                _listNeMessage.post(EventLiveData(messageRepository.convertNeMessToNeSubMess(state.data.filterNot { it.status == MessageStatusType.MESSAGE_DELETED })))
                            }
                            screenState.postData()
                        }
                        is State.Loading -> {
                            screenState.post(ScreenStateObj(ScreenState.LOADING))
                            _isLoading = true
                        }
                        is State.SuccessMerged -> {

                            if (isFirstPage() || !fullData) {
                                isMergeSuccess = true
                                _listNeMessage.post(EventLiveData(messageRepository.convertNeMessToNeSubMess(state.data.filterNot { it.status == MessageStatusType.MESSAGE_DELETED })))
                            }
                            screenState.postData()
                            _isLoading = false
                            loadLastMessageSuccess = false
                        }
                        is State.Error -> {
                            screenState.postError(state.message)
                            _isLoading = false
                            loadLastMessageSuccess = false
                        }
                    }
                }
            }
        }
    }

    fun loadMoreMessages(lastMessage: NeMessage? = null) {
        if (_isLoading) return
        loadLastMessageSuccess = true
        launchOnViewModelScope(getPostExecutionThread.io) {
            messageConfig?.apply {
                this.lastMessageId = lastMessage?.id?.toLongOrNull()
                this.lastMessageCreatedAt = lastMessage?.createAt
                _isFirstPage = lastMessage == null
                socketRepository.getListMessage(messageConfig = this).collect { state ->
                    isMergeSuccess = false
                    when (state) {
                        is State.SuccessLocal -> Unit
                        is State.Loading -> {
                            screenState.post(ScreenStateObj(ScreenState.LOADING))
                            _isLoading = true
                        }
                        is State.SuccessMerged -> {
                            isMergeSuccess = true
                            _listNeMessageLoadMore.post(EventLiveData(messageRepository.convertNeMessToNeSubMess(state.data.filterNot { it.status == MessageStatusType.MESSAGE_DELETED })))
                            screenState.postData()
                            _isLoading = false
                            loadLastMessageSuccess = false
                        }
                        is State.Error -> {
                            screenState.postError(state.message)
                            _isLoading = false
                            loadLastMessageSuccess = false
                        }
                    }
                }
            }
        }
    }

    /**
     * Need to refactor this function
     */
    fun loadMissMessage(lastMessage: NeMessage? = null, missMessage: MutableList<NeMessage> = mutableListOf()) {
        if (loadLastMessageSuccess) return
        val messageId = lastMessage?.id?.toLongOrNull() ?: return
        /**
         * What is the pairMissMessage?
         */
        if (pairMissMessage.first == messageId && pairMissMessage.second == 3) {
            countLoadMissMessage = 0
            return
        } else if (pairMissMessage.first != messageId) {
            countLoadMissMessage = 0
            pairMissMessage = pairMissMessage.copy(first = messageId, second = countLoadMissMessage++)
        } else if (pairMissMessage.first == messageId && pairMissMessage.second < 3) {
            pairMissMessage = pairMissMessage.copy(first = messageId, second = countLoadMissMessage++)
        }
        val loadMissMessageSize = 50L
        launchOnViewModelScope(getPostExecutionThread.io) {
            MessageConfig().apply {
                this.group = neGroup
                this.lastMessageId = missMessage.firstOrNull()?.id?.toLongOrNull()
                this.groupSize = loadMissMessageSize
                _isLoading = true
                socketRepository.getListMessage(messageConfig = this).collect { state ->
                    when (state) {
                        is State.SuccessLocal -> {
                            screenState.postData()
                        }
                        is State.Loading -> {
                            screenState.post(ScreenStateObj(ScreenState.LOADING))
                            _isLoading = true
                        }
                        is State.SuccessMerged -> {
                            var isStop = false
                            for (entry in state.data) {
                                if (messageId >= entry.id?.toLongOrNull() ?: 0) {
                                    isStop = true
                                    break
                                } else {
                                    missMessage.add(0, entry)
                                }
                            }
                            /**
                             * Need to recheck this logic
                             */
                            if (isStop || state.data.size <= loadMissMessageSize) {
                                _listNeMessage.post(EventLiveData(messageRepository.convertNeMessToNeSubMess(state.data.filterNot { it.status == MessageStatusType.MESSAGE_DELETED })))
                                screenState.postData()
                                _isLoading = false
                            } else {
                                loadMissMessage(
                                    lastMessage = lastMessage,
                                    missMessage = missMessage
                                )
                            }
                        }
                        is State.Error -> {
                            screenState.postError(state.message)
                            _isLoading = false
                        }
                    }
                }
            }
        }
    }

    /**
     * Call this function to convert the latest NeMessage to NeSubMessage
     */
    fun convertLatestNeMessage(lastNeMessage: NeSubMessage?, newMessage: NeMessage?): List<NeSubMessage>? =
        messageRepository.convertLatestNeMessage(lastNeMessage, newMessage)

    fun createMessage(
        message: String,
        optMessage: NeMessage? = null,
        type: Int,
        isMentionAll: Boolean = false,
        callbackSuccess: (List<NeSubMessage>, String?, NeMessage?) -> Unit,
        callbackError: (String?, String) -> Unit
    ) {
        failures = 0
        launchOnViewModelScope(getPostExecutionThread.io) {
            if (checkGroupExitsInDb(neGroup)) {
                val groupId = neGroup?.id
                val myId = socketRepository.getUserId
                val senderName = socketRepository.getUser?.getDisplayName
                val senderAvatar = socketRepository.getUser?.getDisplayAvatar
                val tempCreatedAt = TimerSupport.nowNano()
                val tempMessageId = (tempCreatedAt + 1).toString()
                val attachmentMessage = optMessage?.let { neMessage ->
                    messageRepository.mapNeMessageToMessage(neMessage)
                }
                val strAttachment = optMessage?.let {
                    jsonSerializer.asJson(attachmentMessage, Message::class.java)
                }
                val dbMessageEntity = DbMessageEntity().apply {
                    messageId = tempMessageId
                    messageGroupId = groupId
                    messageType = type
                    isEncrypted = neGroup?.isSecretChat() == true
                    timeOut = if (isEncrypted) {
                        neGroup?.timeOut
                    } else {
                        null
                    }
                    messageContent = message
                    messageAttachments =
                        if (attachmentMessage != null && (type == MessageType.MESSAGE_TYPE_REPLY || type == MessageType.MESSAGE_TYPE_FORWARD)) {
                            attachment_SK_DB_Mapper.mapToReplyOrForward(attachmentMessage, type)
                        } else {
                            null
                        }
                    messageOwnerId = myId
                    messageCreatedAt = tempCreatedAt
                    messageSenderName = senderName
                    messageSenderAvatar = senderAvatar
                    messageStatus = MessageStatusType.MESSAGE_SENDING
                    messageVersion = Constants.MESSAGE_VERSION
                }

                messageRepository.insertMessageAndUpdateGroup(
                    dbMessageEntity = dbMessageEntity,
                    dbGroupId = groupId,
                    isIncreaseCount = false
                ).run {
                    /**
                     * show sending message to UI
                     * */
                    val listSubMessages = mutableListOf<NeSubMessage>()
                    val neMessage = messageRepository.mapMessageDBToUi(dbMessageEntity = dbMessageEntity)
                    listSubMessages.add(0, NeSubMessage(neMessage = neMessage))
                    withContext(getPostExecutionThread.main) {
                        callbackSuccess(listSubMessages, null, null)
                    }
                    val createMessageRequest = CreateMessageRequest(
                        groupId = groupId ?: "",
                        type = type,
                        nonce = tempMessageId,
                        senderName = senderName,
                        isMentionAll = isMentionAll,
                        senderAvatar = senderAvatar,
                        isEncrypted = dbMessageEntity.isEncrypted,
                        message = ChatSecretUtils.handleTextInput(
                            plainText = dbMessageEntity.messageContent,
                            isTextType = true,
                            isEncrypt = dbMessageEntity.isEncrypted
                        ),
                        version = Constants.MESSAGE_VERSION.toInt(),
                        attachments = optMessage?.let {
                            StringUtils.handleSpecialChar(
                                text = strAttachment,
                                isTextType = false
                            )
                        }
                    )
                    while (failures < maxFailures) {
                        socketRepository.createMessage(createMessageRequest).let { result ->
                            when (result) {
                                is ResultData.Success -> result.data?.let {
                                    Logger.e("createMessage=$it")
                                    failures = maxFailures
                                    insertMessageAfterCreate(
                                        tempMessageId = tempMessageId,
                                        message = it,
                                        dbMessageEntity = dbMessageEntity
                                    )?.let { dbMessageEntitySaved ->
                                        messageRepository.mapMessageDBToUi(dbMessageEntitySaved).apply {
                                            status = MessageStatusType.MESSAGE_SENT
                                        }.let { neMessageMap ->
                                            withContext(getPostExecutionThread.main) {
                                                callbackSuccess(
                                                    listSubMessages,
                                                    tempMessageId,
                                                    neMessageMap
                                                )
                                            }
                                        }
                                    }
                                }
                                is ResultData.Failed -> {
                                    failures++
                                    when (failures) {
                                        maxFailures -> {
                                            screenState.postError(message = result.message)
                                            launchOnViewModelScope(getPostExecutionThread.io) {
                                                messageRepository.createMessageFailed(
                                                    tempMessageId = tempMessageId,
                                                    callbackSuccess = {
                                                        callbackError(result.message, tempMessageId)
                                                    }
                                                )
                                            }
                                        }
                                        else -> Unit
                                    }
                                }
                                is ResultData.Loading -> Unit
                                is ResultData.Exception -> {
                                    failures++
                                    when (failures) {
                                        maxFailures -> {
                                            screenState.postError(message = result.exception?.message)
                                            launchOnViewModelScope(getPostExecutionThread.io) {
                                                messageRepository.createMessageFailed(
                                                    tempMessageId = tempMessageId,
                                                    callbackSuccess = {
                                                        callbackError(result.exception?.message, tempMessageId)
                                                    }
                                                )
                                            }
                                        }
                                        else -> Unit
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                val listIds = mutableListOf<Long>()
                neGroup?.members?.mapNotNull {
                    it.id
                }?.run {
                    listIds.addAll(this)
                }
                val groupType = neGroup?.type ?: GroupType.GROUP_TYPE_GROUP
                createGroup(type = groupType, listIDs = listIds, groupName = EMPTY, avatar = EMPTY).let { result ->
                    when (result) {
                        is ResultData.Success -> result.data?.let {
                            Logger.e("ResultData.Success:createGroup=" + it)
                            groupRepository.saveGroupToDB(group = it)?.let { savedGroup ->
                                Logger.e("createGroup = $savedGroup")
                                neGroup = savedGroup
                                createGroupSuccess.post(EventLiveData(savedGroup))
                                createMessage(
                                    message = message,
                                    type = type,
                                    isMentionAll = message.contains("@All"),
                                    callbackSuccess = callbackSuccess,
                                    callbackError = callbackError
                                )
                            }
                        }
                        is ResultData.Failed -> {
                            Logger.e("ResultData.Failed:exception=" + result)
                            callbackError(result.message, "")
                            screenStateError.postErrorOnce(result.message)
                            Logger.e("error = ${result.message}")
                        }
                        else -> {
                        }
                    }
                }
            }
        }
    }

    fun setTimeOutForSecretMessage(
        timeOut: Int?,
        groupId: String?,
        messageId: String?,
        callbackSuccess: ((String) -> Unit)? = null
    ) {
        if (timeOut != null && timeOut > 0 && groupId != null) {
            launchOnViewModelScope(getPostExecutionThread.io) {
                removeMessageFromServer(
                    timeRemove = timeOut,
                    messageId = messageId,
                    groupId = groupId.toLong(),
                    callbackSuccess = callbackSuccess
                )
            }
        }
    }

    fun retryMessage(
        dbMessageEntity: DbMessageEntity,
        context: Context,
        callbackSuccess: ((NeRetryMessage) -> Unit)? = null,
        callBackError: (error: Boolean) -> Unit? = {},
        callbackCompressProgress: (String?, Int, Int?, String?, String?, String?) -> Unit,
        callbackUploadProgress: (String?, Long, Long, Int?, String?, String?, String?) -> Unit
    ) {
        val groupId = dbMessageEntity.messageGroupId ?: return
        val senderName = socketRepository.getUser?.getDisplayName
        val senderAvatar = socketRepository.getUser?.avatar
        val messageId = dbMessageEntity.messageId
        val messageType = dbMessageEntity.messageType ?: return
        var strAttachment: String? = null
        var isTextType = false

        val callbackAction = {
            launchOnViewModelScope(getPostExecutionThread.io) {
                val isEncrypted = neGroup?.isSecretChat() ?: false
                val createMessageRequest = CreateMessageRequest(
                    groupId = groupId,
                    type = messageType,
                    nonce = messageId,
                    senderName = senderName,
                    senderAvatar = senderAvatar,
                    isEncrypted = isEncrypted,
                    isMentionAll = dbMessageEntity.messageContent?.contains("@All") == true,
                    message = ChatSecretUtils.handleTextInput(
                        plainText = dbMessageEntity.messageContent,
                        isTextType = true,
                        isEncrypt = isEncrypted
                    ),
                    version = Constants.MESSAGE_VERSION.toInt(),
                    attachments = StringUtils.handleSpecialChar(
                        text = strAttachment,
                        isTextType = isTextType
                    )
                )
                socketRepository.createMessage(createMessageRequest).let { result ->
                    when (result) {
                        is ResultData.Success -> result.data?.let { message ->
                            dbMessageEntity.messageId = message.messageId
                            insertMessageAfterCreate(
                                tempMessageId = messageId,
                                message = message,
                                dbMessageEntity = dbMessageEntity
                            )?.let { dbMessageEntity ->
                                if (neGroup?.isSecretChat() == true) {
                                    com.netacom.base.chat.android_utils.FileUtils.rename("${FileUtils.secretFolderPath}/$messageId", dbMessageEntity.messageId)
                                }
                                _dataRetryMessage.post(
                                    EventLiveData(
                                        NeRetryMessage(
                                            messageTempId = messageId,
                                            neSubMessages = mutableListOf(
                                                NeSubMessage(
                                                    neMessage = messageRepository.mapMessageDBToUi(messageRepository.mapMessageSKToDb(message)).apply {
                                                        status = MessageStatusType.MESSAGE_SENT
                                                    }
                                                )
                                            )
                                        )
                                    )
                                )
                            }
                        }
                        is ResultData.Loading -> {
                        }
                        is ResultData.Failed -> {
                            screenState.postError(message = result.message)
                            launchOnViewModelScope(getPostExecutionThread.io) {
                                if (result.status == RETRY_MESSAGE_CODE) {
                                    /**
                                     * retry error
                                     * */
                                    messageRepository.retryMessageFail(
                                        tempMessageId = messageId,
                                        callbackSuccess = {
                                            callBackError(true)
                                        }
                                    )
                                } else {
                                    /**
                                     * socket not connect
                                     * */
                                    messageRepository.createMessageFailed(
                                        tempMessageId = messageId,
                                        callbackSuccess = {
                                            callBackError(true)
                                        }
                                    )
                                }
                            }
                        }
                        is ResultData.Exception -> {
                            launchOnViewModelScope(getPostExecutionThread.io) {
                                messageRepository.retryMessageFail(
                                    tempMessageId = messageId,
                                    callbackSuccess = {
                                        callBackError(true)
                                    }
                                )
                            }
                        }
                    }
                }
            }
        }
        launchOnViewModelScope(getPostExecutionThread.io) {
            dbMessageEntity.messageAttachments?.let { dbAttachment ->
                when (dbMessageEntity.messageType) {
                    /*
                * Note Logic for retry send message with media attachment
                * Message with type is media (PHOTO, AUDIO, VIDEO, FILE)
                * check attachment with 2 case:
                * # Case 1: Attachment is contain [uid] (media file is upload to server success)
                * => Just resend message to socket
                * # Case 2: Attachment is contain [file_path] (media file is not upload to server)
                * => get list local file corresponding with path
                * => re-upload file and collect [uid] from server
                * => created attachment math with message type
                * => resend message to socket
                * */
                    MessageType.MESSAGE_TYPE_IMAGE, MessageType.MESSAGE_TYPE_VIDEO, MessageType.MESSAGE_TYPE_AUDIO, MessageType.MESSAGE_TYPE_FILE -> {
                        /**
                         * upload attachment
                         * */
                        dbMessageEntity.messageType?.let { type ->
                            dbMessageEntity.messageAttachments?.let { _dbMessageAttachmentEntity ->
                                if (checkAttachmentContainFilePath(_dbMessageAttachmentEntity, type)) {
                                    val listLocalFileUpload = getListLocalFileFromMediaAttachment(_dbMessageAttachmentEntity, type)
                                    if (listLocalFileUpload.isNotEmpty()) {
                                        var videoThumb = ""
                                        var compressRatio: Float? = null
                                        val mediaType = when (messageType) {
                                            MessageType.MESSAGE_TYPE_IMAGE -> {
                                                MediaType.PHOTO
                                            }
                                            MessageType.MESSAGE_TYPE_VIDEO -> {
                                                compressRatio = AppUtils.checkVideoUploadFile(listLocalFileUpload[0].filePath)
                                                // for upload video thumbnail
                                                uploadThumbnailFile(
                                                    dbMessageEntity.messageId,
                                                    isEncryptedFile = neGroup?.isSecretChat() == true,
                                                    videoPath = listLocalFileUpload[0].filePath,
                                                    callbackSuccess = { result ->
                                                        if (result is ResultData.Success) {
                                                            videoThumb = result.data.toString()
                                                        }
                                                    },
                                                    callbackError = {}
                                                )
                                                MediaType.VIDEO
                                            }
                                            MessageType.MESSAGE_TYPE_AUDIO -> {
                                                MediaType.AUDIO
                                            }
                                            MessageType.MESSAGE_TYPE_FILE -> {
                                                MediaType.FILE
                                            }
                                            else -> MediaType.FILE
                                        }
                                        val listFileUpload = getListFileUploadByLocalFile(dbMessageEntity.messageId, listLocalFileUpload, mediaType)
                                        if (listFileUpload.isNotEmpty()) {
                                            uploadFile(
                                                compressRatio = compressRatio,
                                                isEncryptedFile = neGroup?.isSecretChat() ?: false,
                                                listFileUpload,
                                                mediaType,
                                                callbackSuccess = { lstFileUploaded ->
                                                    Logger.d("processForUploadMediaMessage - uploadFile - callbackSuccess: $lstFileUploaded")
                                                    strAttachment = messageRepository.parseAttachmentToJson(
                                                        createAttachmentByListUid(
                                                            mediaType,
                                                            lstFileUploaded.toMutableList(),
                                                            _dbMessageAttachmentEntity,
                                                            videoThumb
                                                        )
                                                    )
                                                    callbackAction()
                                                },
                                                callbackError = {
                                                    Logger.d("processForUploadMediaMessage - uploadFile - callbackError")
                                                },
                                                callbackCompressProgress = { messageId, compress, index, compressId, uploadId, mergeId ->
                                                    actionUpdateCompressProgressToUi(messageId, compress, index, compressId, uploadId, mergeId, callbackCompressProgress)
                                                },
                                                callbackUploadProgress = { messageId, progress, size, index, compressId, uploadId, mergeId ->
                                                    actionUpdateUploadProgressToUi(messageId, progress, size, index, compressId, uploadId, mergeId, callbackUploadProgress)
                                                }
                                            )
                                        }
                                    }
                                } else {
                                    strAttachment = messageRepository.parseDbAttachmentToJson(dbMessageAttachmentEntity = dbAttachment)
                                    callbackAction()
                                }
                            }
                        }
                    }
                    MessageType.MESSAGE_TYPE_REPLY -> {
                        strAttachment = dbAttachment.replyMessage?.let {
                            messageRepository.parseDbMessageToJson(dbMessageEntity = it)
                        } ?: EMPTY
                        isTextType = dbAttachment.type?.toIntOrNull() == MessageType.MESSAGE_TYPE_TEXT
                        callbackAction()
                    }
                    MessageType.MESSAGE_TYPE_FORWARD -> {
                        strAttachment = dbAttachment.forwardMessage?.let {
                            messageRepository.parseDbMessageToJson(dbMessageEntity = it)
                        } ?: EMPTY
                        isTextType = dbAttachment.type?.toIntOrNull() == MessageType.MESSAGE_TYPE_TEXT
                        callbackAction()
                    }
                    else -> {
                        /**
                         * check reason
                         * => do nothing
                         * */
                    }
                }
            } ?: callbackAction()
        }
    }

    fun retryMessageFromDatabase(
        context: Context,
        callbackCompressProgress: (String?, Int, Int?, String?, String?, String?) -> Unit,
        callbackUploadProgress: (String?, Long, Long, Int?, String?, String?, String?) -> Unit
    ) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            delay(500)
            messageRepository.getFailMessageByGroupId(
                groupId = neGroup?.id,
                myId = socketRepository.getUserId
            ).forEach { dbMessageEntity ->
                retryMessage(
                    dbMessageEntity = dbMessageEntity, context = context,
                    callbackCompressProgress = callbackCompressProgress, callbackUploadProgress = callbackUploadProgress
                )
            }
        }
    }

    fun getMessageById(messageId: String?) = messageRepository.getMessageById(messageId = messageId)

    private suspend fun insertMessageAfterCreate(
        tempMessageId: String?,
        message: Message,
        dbMessageEntity: DbMessageEntity
    ): DbMessageEntity? {
        /**
         * Note logic: if received message, message groupId == current groupId => not increase count
         */
        var isIncreaseCount = true
        neGroup?.id?.let { groupId ->
            message.groupId?.let { receivedGroupId ->
                isIncreaseCount = groupId != receivedGroupId
            }
        }
        message.isEncrypted = false
        message.message = dbMessageEntity.messageContent
        message.timeOut = dbMessageEntity.timeOut
        return messageRepository.insertMessageAfterCreate(
            tempMessageId = tempMessageId,
            dbMessageEntity = messageRepository.mapMessageSKToDb(message),
            dbGroupId = message.groupId,
            isIncreaseCount = isIncreaseCount
        )
    }

    fun setTyping(isTyping: Boolean) {
        neGroup?.id?.let { groupId ->
            val typingRequest = RequestEvent(
                groupId = groupId,
                senderUin = getUserId,
                type = if (isTyping) EventType.EVENT_TYPE_MESSAGING_START_TYPING.value else EventType.EVENT_TYPE_MESSAGING_STOP_TYPING.value
            )
            getIOSocket.requestEvent(requestEvent = typingRequest)
        }
    }

    // For Upload File
    private fun uploadFile(
        compressRatio: Float? = null,
        isEncryptedFile: Boolean,
        files: List<FileUpload>,
        fileType: MediaType,
        callbackSuccess: (List<UploadFileSuccessModel>) -> Unit = {},
        callbackError: () -> Unit = {},
        callbackCompressProgress: (String?, Int, Int?, String?, String?, String?) -> Unit,
        callbackUploadProgress: (String?, Long, Long, Int?, String?, String?, String?) -> Unit
    ) {
        val listFileUid = mutableListOf<UploadFileSuccessModel>()
        val compressorWorkers = mutableListOf<OneTimeWorkRequest>()
        val uploadWorkers = mutableListOf<OneTimeWorkRequest>()
        val chains = mutableListOf<WorkContinuation>()
        val mergeWorkRequest = OneTimeWorkRequestBuilder<MergeWorker>().setInputMerger(ArrayCreatingInputMerger::class).build()
        files.forEachIndexed { index, fileUpload ->
            val compressWorkRequest = OneTimeWorkRequestBuilder<CompressWorker>().setInputData(
                workDataOf(
                    CompressWorker.KEY_UPLOAD_FILE_ARG to jsonSerializer.asJson(fileUpload, FileUpload::class.java),
                    CompressWorker.KEY_MEDIA_TYPE_ARG to jsonSerializer.asJson(fileType, MediaType::class.java),
                    CompressWorker.KEY_INDEX_ARG to index,
                    CompressWorker.KEY_COMPRESS_RATIO_ARG to compressRatio
                )
            ).build()
            compressorWorkers.add(compressWorkRequest)

            val uploadWorkRequest = OneTimeWorkRequestBuilder<UploadWorker>().setInputData(
                workDataOf(
                    UploadWorker.KEY_THUMBNAIL_ARG to false,
                    UploadWorker.KEY_ENCRYPT_ARG to isEncryptedFile,
                    UploadWorker.KEY_MEDIA_TYPE_ARG to jsonSerializer.asJson(fileType, MediaType::class.java),
                    UploadWorker.KEY_INDEX_ARG to index
                )
            ).build()
            uploadWorkers.add(uploadWorkRequest)
            chains.add(
                WorkManager.getInstance(Utils.getApp())
                    .beginWith(compressWorkRequest)
                    .then(uploadWorkRequest)
            )
        }

        val mergeChain: WorkContinuation = WorkContinuation
            .combine(chains)
            .then(mergeWorkRequest)
        mergeChain.enqueue()

        launchOnViewModelScope(getPostExecutionThread.main) {
            compressorWorkers.forEachIndexed { index, request ->
                WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(request.id).observeForever(object : Observer<WorkInfo> {
                    override fun onChanged(workInfo: WorkInfo?) {
                        if (workInfo?.state?.isFinished == true) {
                            callbackCompressProgress(
                                files[index].messageId, -1, index,
                                request.id.toString(), uploadWorkers[index].toString(), mergeWorkRequest.id.toString()
                            )
                            WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(request.id).removeObserver(this)
                        } else {
                            val progress = workInfo?.progress?.getInt(CompressWorker.KEY_COMPRESS_PROGRESS, -1)
                            progress?.let {
                                callbackCompressProgress(
                                    files[index].messageId, it, index,
                                    request.id.toString(), uploadWorkers[index].toString(), mergeWorkRequest.id.toString()
                                )
                            }
                        }
                    }
                })
            }
            uploadWorkers.forEachIndexed { index, request ->
                WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(request.id).observeForever(object : Observer<WorkInfo> {
                    override fun onChanged(workInfo: WorkInfo?) {
                        if (workInfo?.state?.isFinished == true) {
                            val uploadResult = workInfo.outputData.getString(UploadWorker.KEY_UPLOAD_RESULT)
                            jsonSerializer.asObject(uploadResult, UploadResult::class.java)?.let { result ->
                                callbackUploadProgress(
                                    result.message, -1L, result.size, result.index,
                                    compressorWorkers[index].toString(), request.id.toString(), mergeWorkRequest.id.toString()
                                )
                            }
                            WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(request.id).removeObserver(this)
                        } else {
                            val progress = workInfo?.progress?.getString(UploadWorker.KEY_UPLOAD_RESULT)
                            jsonSerializer.asObject(progress, UploadResult::class.java)?.let { result ->
                                callbackUploadProgress(
                                    result.message, result.progress, result.size, result.index,
                                    compressorWorkers[index].toString(), request.id.toString(), mergeWorkRequest.id.toString()
                                )
                            }
                        }
                    }
                })
            }
            WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(mergeWorkRequest.id).observeForever(object : Observer<WorkInfo> {
                override fun onChanged(workInfo: WorkInfo?) {
                    if (workInfo != null) {
                        if (workInfo.state.isFinished) {
                            val uploadResult = workInfo.outputData.getStringArray(MergeWorker.KEY_MERGE_RESULT)
                            uploadResult?.forEach {
                                jsonSerializer.asObject(it, UploadResult::class.java)?.let { file ->
                                    // Create upload success model for get width/height of photo (maybe have info for another file type)
                                    val uploadedFile = UploadFileSuccessModel(
                                        fileUid = file.fileUrl ?: "",
                                        fileWidth = file.width ?: 0,
                                        fileHeight = file.height ?: 0,
                                        index = file.index
                                    )
                                    listFileUid.add(uploadedFile)
                                }
                            }

                            Logger.d("listFileUid: ${listFileUid.size}")
                            if (listFileUid.isNotEmpty()) {
                                val sortListFile = listFileUid.sortedWith(compareBy { it.index })
                                Logger.d("listFileUid: $sortListFile")
                                sortListFile.forEach {
                                    Logger.d("upload file index : ${it.index}")
                                }
                                callbackSuccess(sortListFile)
                            } else {
                                callbackError()
                            }
                            WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(mergeWorkRequest.id).removeObserver(this)
                        }
                    }
                }
            })
        }
    }

    fun processFileBeforeUpload(
        uriPath: Uri? = null,
        file: File? = null,
        mediaType: MediaType,
        duration: Long = 0L,
        context: Context,
        callbackSuccess: (List<NeSubMessage>, String?, NeMessage?) -> Unit,
        callbackError: (String, String) -> Unit,
        callbackCompressProgress: (String?, Int, Int?, String?, String?, String?) -> Unit,
        callbackUploadProgress: (String?, Long, Long, Int?, String?, String?, String?) -> Unit
    ) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            val fileUpload = when {
                uriPath.isNotNull -> {
                    UriUtils.uri2File(uriPath)
                }
                file.isNotNull -> {
                    file
                }
                else -> {
                    null
                }
            }
            fileUpload?.apply {
                val fileSize = com.netacom.base.chat.android_utils.FileUtils.getFileLength(path)
                val photoLocalFileModel = LocalFileModel(
                    filePath = absolutePath,
                    fileName = nameWithoutExtension,
                    fileExtension = extension,
                    dateAdded = lastModified(),
                    fileDuration = duration,
                    fileSize = fileSize,
                    fileSizeText = fileSize.convertSize()
                )
                processForUploadMediaMessage(
                    listUploadMedia = listOf(photoLocalFileModel),
                    mediaType = mediaType,
                    callbackSuccess = callbackSuccess,
                    context = context,
                    callbackError = callbackError,
                    callbackCompressProgress = callbackCompressProgress,
                    callbackUploadProgress = callbackUploadProgress
                )
            } ?: callbackError("Found not file", "")
        }
    }

    fun processForUploadMediaMessage(
        compressRatio: Float? = null,
        listUploadMedia: List<LocalFileModel>,
        mediaType: MediaType,
        context: Context? = null,
        callbackSuccess: (List<NeSubMessage>, String?, NeMessage?) -> Unit,
        callbackError: (String, String) -> Unit,
        callbackCompressProgress: (String?, Int, Int?, String?, String?, String?) -> Unit,
        callbackUploadProgress: (String?, Long, Long, Int?, String?, String?, String?) -> Unit
    ) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            if (checkGroupExitsInDb(neGroup)) {
                val groupId: String = neGroup?.id ?: return@launchOnViewModelScope
                val senderName = socketRepository.getUser?.getDisplayName ?: ""
                val senderAvatar = socketRepository.getUser?.getDisplayAvatar ?: ""
                val tempCreatedAt = TimerSupport.nowNano()
                val tempMessageId = (tempCreatedAt + 1).toString()
                val listUploadFile = getListFileUploadByLocalFile(tempMessageId, listUploadMedia, mediaType)
                val tempMessage = createdTempMediaMessage(tempMessageId, listUploadMedia, listUploadFile, mediaType)
                val dbMessageEntity = messageRepository.mapMessageSKToDb(tempMessage)
                messageRepository.insertMessageAndUpdateGroup(dbMessageEntity, neGroup?.id, false)?.let {
                    if (it) {
                        // Step 1: update temp message to UI with status = sending
                        actionUpdateTempMessageToUi(dbMessageEntity = dbMessageEntity, callbackSuccess = callbackSuccess)

                        var videoThumb = ""
                        if (mediaType == MediaType.VIDEO) { // video thumbnail
                            uploadThumbnailFile(
                                messageId = tempMessageId,
                                isEncryptedFile = neGroup?.isSecretChat() == true,
                                videoPath = listUploadMedia[0].filePath,
                                context = context,
                                callbackSuccess = { result ->
                                    if (result is ResultData.Success) {
                                        videoThumb = result.data.toString()
                                    }
                                },
                                callbackError = {}
                            )
                        }
//                        else if (mediaType == MediaType.PHOTO) { // rotate image capture before upload
//                            listUploadFile.forEachIndexed { index, fileUpload ->
//                                val imageSize = ImageUtils.getSize(fileUpload.file)
//                                ImageUtils.rotate(
//                                    ImageUtils.getBitmap(fileUpload.file),
//                                    ImageUtils.getRotateDegree(listUploadMedia[index].filePath),
//                                    (imageSize[0] / 2).toFloat(),
//                                    (imageSize[1] / 2).toFloat(),
//                                    true
//                                )?.apply {
//                                    AppUtils.createFileFromBitmap(Utils.getApp(), this)?.let { file ->
//                                        listUploadFile[index].file = file.absolutePath
//                                    }
//                                }
//                            }
//                        }

                        // Step 2: upload file to server
                        uploadFile(
                            compressRatio,
                            isEncryptedFile = neGroup?.isSecretChat() ?: false,
                            listUploadFile,
                            mediaType,
                            callbackSuccess = { lstFileUploaded ->
                                Logger.d("processForUploadMediaMessage - uploadFile - callbackSuccess: $lstFileUploaded")
                                val messageForSend = updateTempMessageUpload(mediaType, tempMessage, videoThumb, lstFileUploaded.toMutableList())
                                // Step 3.1: create message and send to socket
                                sendMessageToSocket(groupId, tempMessageId, messageForSend, senderName, senderAvatar, dbMessageEntity, callbackSuccess)
                            },
                            callbackError = {
                                Logger.d("processForUploadMediaMessage - uploadFile - callbackError")
                                // Step 3.2: Update message with status = false
                                callbackError("Upload error", tempMessageId)
                                launchOnViewModelScope(getPostExecutionThread.io) {
                                    actionUpdateTempMessageToUi(true, tempMessageId, dbMessageEntity, callbackSuccess)
                                    dbMessageEntity.messageStatus = MessageStatusType.MESSAGE_FAILED
                                    getDbManager.syncMessage(dbMessageEntity)
                                }
                            },
                            callbackCompressProgress = { messageId, compress, index, compressId, uploadId, mergeId ->
                                actionUpdateCompressProgressToUi(messageId, compress, index, compressId, uploadId, mergeId, callbackCompressProgress)
                            },
                            callbackUploadProgress = { messageId, progress, size, index, compressId, uploadId, mergeId ->
                                actionUpdateUploadProgressToUi(messageId, progress, size, index, compressId, uploadId, mergeId, callbackUploadProgress)
                            }
                        )
                    } else {
                        // Update message with status = false
                        actionUpdateTempMessageToUi(true, tempMessageId, dbMessageEntity, callbackSuccess)
                    }
                }
            } else {
                val listIds = mutableListOf<Long>()
                neGroup?.members?.mapNotNull {
                    it.id
                }?.run {
                    listIds.addAll(this)
                }
                createGroup(type = GroupType.GROUP_TYPE_PUBLIC, listIDs = listIds, groupName = EMPTY, avatar = EMPTY).let { result ->
                    when (result) {
                        is ResultData.Success -> result.data?.let {
                            groupRepository.saveGroupToDB(group = it)?.let { savedGroup ->
                                neGroup = savedGroup
                                createGroupSuccess.post(EventLiveData(savedGroup))
                                processForUploadMediaMessage(
                                    listUploadMedia = listUploadMedia,
                                    mediaType = mediaType,
                                    context = context,
                                    callbackSuccess = callbackSuccess,
                                    callbackError = callbackError,
                                    callbackCompressProgress = callbackCompressProgress,
                                    callbackUploadProgress = callbackUploadProgress
                                )
                            }
                        }
                        is ResultData.Failed -> {
                            callbackError(result.message ?: "", "")
                            screenStateError.postErrorOnce(result.message)
                            Logger.e("error = ${result.message}")
                        }
                        else -> {
                        }
                    }
                }
            }
        }
    }

    private fun createdTempMediaMessage(
        tempId: String,
        listUploadMedia: List<LocalFileModel>,
        listUpload: List<FileUpload>,
        mediaType: MediaType
    ): Message {
        val neAttachments = NeAttachments()
        var messageType = 0
        when (mediaType) {
            MediaType.PHOTO -> {
                messageType = MessageType.MESSAGE_TYPE_IMAGE
                neAttachments.images = listUpload.mapIndexed { index, image ->
                    Logger.e("images attachment upload index = $index ")
                    NeImage(
                        sub_index = index,
                        url = listUploadMedia[index].filePath,
                        width = image.width,
                        height = image.height,
                        index = index,
                        isLoading = true
                    )
                }
            }
            MediaType.VIDEO -> {
                messageType = MessageType.MESSAGE_TYPE_VIDEO
                val localVideo = listUploadMedia[0]
                neAttachments.video = NeVideo(
                    url = localVideo.filePath,
                    duration = localVideo.fileDuration,
                    thumbnailUrl = null,
                    width = FileUtils.getWidthOrHeightOfMediaByPath(localVideo.filePath, true),
                    height = FileUtils.getWidthOrHeightOfMediaByPath(localVideo.filePath, false)
                )
            }
            MediaType.FILE -> {
                messageType = MessageType.MESSAGE_TYPE_FILE
                val localFile = listUploadMedia[0]
                neAttachments.file = NeDocument(
                    url = localFile.filePath,
                    name = localFile.fileName,
                    extension = localFile.fileExtension,
                    size = localFile.fileSize,
                    sizeText = localFile.fileSizeText
                )
            }
            MediaType.AUDIO -> {
                messageType = MessageType.MESSAGE_TYPE_AUDIO
                val localRecordAudio = listUploadMedia[0]
                neAttachments.audio = NeAudio(
                    url = localRecordAudio.filePath,
                    duration = localRecordAudio.fileDuration
                )
            }
            MediaType.MAP -> {
                messageType = MessageType.MESSAGE_TYPE_LOCATION
                val localImageLocation = listUploadMedia[0]
                val imageSize = ImageUtils.getSize(localImageLocation.filePath)
                neAttachments.type = "location"
                neAttachments.location = NeLocation(
                    lat = localImageLocation.location?.latitude,
                    long = localImageLocation.location?.longitude,
                    image_url = localImageLocation.filePath,
                    width = imageSize[0],
                    height = imageSize[1],
                    address = localImageLocation.address
                )
            }
            else -> {}
        }
        val attachmentString = messageRepository.parseAttachmentToJson(neAttachments)
        return Message(
            messageId = tempId,
            groupId = neGroup?.id ?: "tempGroupId",
            type = messageType,
            attachments = attachmentString,
            senderUin = getUserId.toString(),
            isEncrypted = neGroup?.isSecretChat() == true,
            timeOut = if (neGroup?.isSecretChat() == true) neGroup?.timeOut else null,
            status = MessageStatusType.MESSAGE_SENDING,
            isTempMessage = true
        )
    }

    private suspend fun actionUpdateTempMessageToUi(
        isFalse: Boolean = false,
        tempMessageId: String? = null,
        dbMessageEntity: DbMessageEntity,
        callbackSuccess: (List<NeSubMessage>, String?, NeMessage?) -> Unit
    ) = launchOnViewModelScope(getPostExecutionThread.io) {
        val listSubMessages = mutableListOf<NeSubMessage>()
        val neMessage = messageRepository.mapMessageDBToUi(dbMessageEntity = dbMessageEntity)
        if (isFalse) neMessage.status = MessageStatusType.MESSAGE_FAILED
        listSubMessages.add(0, NeSubMessage(neMessage = neMessage))
        withContext(getPostExecutionThread.main) {
            tempMessageId?.let { tempId ->
                callbackSuccess(listSubMessages, tempId, neMessage)
            } ?: callbackSuccess(listSubMessages, null, null)
        }
    }

    private fun actionUpdateCompressProgressToUi(
        messageId: String?,
        compress: Int,
        index: Int?,
        compressId: String?,
        uploadId: String?,
        mergeId: String?,
        callbackCompressProgress: (String?, Int, Int?, String?, String?, String?) -> Unit
    ) = launchOnViewModelScope(getPostExecutionThread.main) {
        callbackCompressProgress(messageId, compress, index, compressId, uploadId, mergeId)
    }

    private fun actionUpdateUploadProgressToUi(
        messageId: String?,
        progress: Long,
        size: Long,
        index: Int?,
        compressId: String?,
        uploadId: String?,
        mergeId: String?,
        callbackUploadProgress: (String?, Long, Long, Int?, String?, String?, String?) -> Unit
    ) = launchOnViewModelScope(getPostExecutionThread.main) {
        callbackUploadProgress(messageId, progress, size, index, compressId, uploadId, mergeId)
    }

    private fun sendMessageToSocket(
        groupId: String,
        tempMessageId: String,
        tempMessage: Message,
        senderName: String,
        senderAvatar: String,
        tempDbMessageEntity: DbMessageEntity,
        callbackSuccess: (List<NeSubMessage>, String?, NeMessage?) -> Unit
    ) = launchOnViewModelScope(getPostExecutionThread.io) {
        val createMessageRequest = CreateMessageRequest(
            groupId = groupId,
            type = tempMessage.type,
            nonce = tempMessageId,
            attachments = StringUtils.handleSpecialChar(
                text = tempMessage.attachments,
                isTextType = false
            ),
            senderName = senderName,
            senderAvatar = senderAvatar,
            version = Constants.MESSAGE_VERSION.toInt(),
            isEncrypted = neGroup?.isSecretChat() == true
        )
        Logger.d("sendMessageToSocket - :$createMessageRequest")
        getIOSocket.createMessage(createMessageRequest).let { result ->
            when (result) {
                is ResultData.Success -> result.data?.let {
                    insertMessageAfterCreate(
                        tempMessageId = tempMessageId,
                        message = it,
                        dbMessageEntity = tempDbMessageEntity
                    )?.let { dbMessageEntity ->
                        if (dbMessageEntity.messageId != null) {
                            Logger.d("sendMessageToSocket - createMessage - callBackSuccess - insertMessageAfterCreate SUCCESS")
                            if (neGroup?.isSecretChat() == true) {
                                // Change folder that save encrypted file of secret group from tempMessageId to messageId
                                com.netacom.base.chat.android_utils.FileUtils.rename("${FileUtils.secretFolderPath}/$tempMessageId", it.messageId)
                                val listSubMessages = mutableListOf<NeSubMessage>()
                                val neMessage = messageRepository.mapMessageDBToUi(dbMessageEntity = tempDbMessageEntity)
                                neMessage.status = MessageStatusType.MESSAGE_SENT
                                listSubMessages.add(0, NeSubMessage(neMessage = neMessage))
                                callbackSuccess(
                                    listSubMessages,
                                    tempMessageId,
                                    neMessage
                                )
                            }
                        } else {
                            Logger.d("sendMessageToSocket - createMessage - callBackSuccess - insertMessageAfterCreate FAIL:")
                            actionUpdateTempMessageToUi(true, tempMessageId, tempDbMessageEntity, callbackSuccess)
                        }
                    }
                }
                is ResultData.Failed -> {
                    Logger.d("sendMessageToSocket - createMessage - callBackError:")
                    actionUpdateTempMessageToUi(true, tempMessageId, tempDbMessageEntity, callbackSuccess)
                }
                else -> Logger.d("sendMessageToSocket - createMessage - socketRepository RESULT: $result")
            }
        }
    }

    suspend fun getListGroup(): List<NeGroup> = groupRepository.getListGroupDb()

    fun getListContactRegistered(): List<NeUser> = contactRepository.getUser()

    fun getMentionMembers(): List<NeUser> {
        val mentionList = mutableListOf<NeUser>()
        mentionList.addAll((neGroup?.members?.filter { it.id != socketRepository.getUserId } ?: mutableListOf()))
        if (mentionList.isNotEmpty()) mentionList.add(
            0,
            NeUser().apply {
                id = 1
                username = StringUtils.getString(R.string.call_all)
            }
        )
        return mentionList
    }

    // Parse list upload file and map with attachment follow media type
    private fun updateTempMessageUpload(
        mediaType: MediaType,
        tempMessage: Message,
        videoThumb: String,
        listUploadMedia: MutableList<UploadFileSuccessModel>
    ): Message {
        /*
        * If list upload is empty => return temp message with attachment temp
        * */
        if (listUploadMedia.isEmpty()) return tempMessage

        val oldAttachments = tempMessage.attachments?.let { messageRepository.parseAttachmentToObject(tempMessage) }

        if (oldAttachments != null) {
            tempMessage.attachments =
                messageRepository.parseAttachmentToJson(createAttachmentByListUid(mediaType, listUploadMedia, oldAttachments, videoThumb))
        }

        return tempMessage
    }

    fun deleteMessage(
        groupId: Long?,
        messageId: String?,
        isDeleteAll: Boolean,
        callbackSuccess: ((String) -> Unit)? = null
    ) {
        if (groupId == null || messageId == null) return
        val deleteMessageRequest = DeleteMessageRequest(
            groupId = groupId,
            messageId = messageId,
            isDeleteAll = isDeleteAll
        )
        launchOnViewModelScope(getPostExecutionThread.io) {
            getIOSocket.deleteMessage(deleteMessageRequest).let { result ->
                when (result) {
                    is ResultData.Success -> result.data?.let {
                        messageRepository.removeMessage(messageId = messageId).let { isDeleted ->
                            if (isDeleted) {
                                withContext(getPostExecutionThread.io) {
                                    groupRepository.deleteEncryptedFilesInMessage(messageId)
                                }
                                _deleteMessage.post(EventLiveData((messageId.toString())))
                                callbackSuccess?.invoke(messageId.toString())
                            }
                        }
                    }
                    is ResultData.Failed -> {
                    }
                    else -> {
                    }
                }
            }
        }
    }

    @OptIn(ObsoleteCoroutinesApi::class)
    private suspend fun removeMessageFromServer(
        timeRemove: Int,
        messageId: String?,
        groupId: Long,
        callbackSuccess: ((String) -> Unit)? = null
    ) {
        val tickerChannel = ticker(delayMillis = 1000, initialDelayMillis = 0)
        var time = 0
        repeat(timeRemove) {
            tickerChannel.receive()
            time += 1
            if (time >= timeRemove) {
                deleteMessage(
                    groupId = groupId,
                    messageId = messageId,
                    isDeleteAll = true,
                    callbackSuccess = callbackSuccess
                )
            }
        }
    }

    fun getStickerCategory(callbackSuccess: (List<SubNeCategory>, Boolean) -> Unit) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            val dbEmotionEntityList = stickerRepository.getStickerCategory()
            if (dbEmotionEntityList.size < DEFAULT_STICKER_NUMBER + 1) {
                stickerRepository.getMoreStickersFromServer(
                    downloadRepository,
                    callbackSuccess = {
                        launchOnViewModelScope(getPostExecutionThread.io) {
                            setupStickers(stickerRepository.getStickerCategory(), callbackSuccess, true)
                        }
                    }
                )
            } else {
                setupStickers(dbEmotionEntityList, callbackSuccess, false)
            }
        }
    }

    private fun setupStickers(
        dbEmotionEntityList: List<DbEmotionEntity>,
        callbackSuccess: (List<SubNeCategory>, Boolean) -> Unit,
        isUpdateSticker: Boolean
    ) {
        val result = mutableListOf<SubNeCategory>()
        result.addAll(
            dbEmotionEntityList.sortedByDescending { it.updatedAt }.map {
                SubNeCategory(
                    isSelect = false,
                    neCategory = NeCategory().apply {
                        id = it.id
                        name = it.name
                        thumbnail = it.thumbnail
                        imageUrl = it.imageUrl
                        updatedAt = it.updatedAt
                        stickers = mutableListOf()
                        it.stickers?.map { dbStickerEntity ->
                            NeSticker().apply {
                                id = dbStickerEntity.id
                                name = dbStickerEntity.name
                                filePath = dbStickerEntity.filePath
                                categoryId = dbStickerEntity.categoryId
                                sentTime = dbStickerEntity.sentTime
                            }
                        }?.let { list ->
                            stickers?.addAll(list)
                        }
                    }
                )
            }
        )

        val recentSubNeCategory = SubNeCategory(
            isSelect = false,
            neCategory = NeCategory().apply {
                stickers = mutableListOf()
                result.forEach { subNeCategory ->
                    stickers?.addAll(
                        subNeCategory.neCategory.stickers?.filter { neSticker ->
                            neSticker.sentTime ?: 0 > 0
                        } ?: emptyList()
                    )
                }
                stickers?.sortByDescending { neSticker ->
                    neSticker.sentTime
                }
            }
        )

        result.add(0, recentSubNeCategory)
        if (result.size > 2) {
            result[1].isSelect = true
        } else if (result.size > 1) {
            result[0].isSelect = true
        }

        launchOnViewModelScope(getPostExecutionThread.main) {
            callbackSuccess(result, isUpdateSticker)
        }
    }

    fun createStickerMessage(
        neSticker: NeSticker,
        callbackSuccess: (List<NeSubMessage>, String?, NeMessage?) -> Unit,
        callbackError: (String?, String) -> Unit
    ) {
        val groupType = neGroup?.type ?: GroupType.GROUP_TYPE_PUBLIC
        if (checkGroupExitsInDb(neGroup)) {
            val groupId = neGroup?.id ?: return
            launchOnViewModelScope(getPostExecutionThread.io) {
                val myId = socketRepository.getUser?.id
                val senderName = socketRepository.getUser?.getDisplayName
                val senderAvatar = socketRepository.getUser?.getDisplayAvatar
                val tempCreatedAt = TimerSupport.nowNano()
                val tempMessageId = (tempCreatedAt + 1).toString()
                val attachments = jsonSerializer.asJson(
                    NeAttachments(
                        mediaType = MessageType.MESSAGE_TYPE_STICKER,
                        stickerId = neSticker.id
                    ),
                    NeAttachments::class.java
                )
                val dbMessageEntity = DbMessageEntity().apply {
                    messageId = tempMessageId
                    messageGroupId = groupId
                    messageType = MessageType.MESSAGE_TYPE_STICKER
                    messageContent = null
                    isEncrypted = neGroup?.isSecretChat() == true
                    timeOut = if (isEncrypted) {
                        neGroup?.timeOut
                    } else {
                        null
                    }
                    messageAttachments = DbMessageAttachmentEntity().apply {
                        messageId = tempMessageId + "_attachment"
                        mediaType = MessageType.MESSAGE_TYPE_STICKER
                        stickerId = neSticker.id
                        stickerUrl = neSticker.filePath
                    }
                    messageOwnerId = myId
                    messageCreatedAt = tempCreatedAt
                    messageSenderName = senderName
                    messageSenderAvatar = senderAvatar
                    messageStatus = MessageStatusType.MESSAGE_SENDING
                    messageVersion = Constants.MESSAGE_VERSION
                }

                messageRepository.insertMessageAndUpdateGroup(
                    dbMessageEntity = dbMessageEntity,
                    dbGroupId = groupId,
                    isIncreaseCount = false
                ).run {
                    /**
                     * show sending message to UI
                     * */
                    val listSubMessages = mutableListOf<NeSubMessage>()
                    val neMessage = messageRepository.mapMessageDBToUi(dbMessageEntity = dbMessageEntity)
                    listSubMessages.add(0, NeSubMessage(neMessage = neMessage))
                    withContext(getPostExecutionThread.main) {
                        callbackSuccess(listSubMessages, null, null)
                    }
                    val createMessageRequest = CreateMessageRequest(
                        groupId = groupId,
                        type = MessageType.MESSAGE_TYPE_STICKER,
                        nonce = tempMessageId,
                        senderName = senderName,
                        senderAvatar = senderAvatar,
                        isEncrypted = dbMessageEntity.isEncrypted,
                        attachments = StringUtils.handleSpecialChar(
                            text = attachments,
                            isTextType = false,
                        ),
                        version = Constants.MESSAGE_VERSION.toInt()
                    )
                    socketRepository.getIOSocket.createMessage(
                        createMessageRequest
                    ).let { result ->
                        when (result) {
                            is ResultData.Success -> result.data?.let {
                                Logger.e("createStickerMessage==$it")
                                insertMessageAfterCreate(
                                    tempMessageId = tempMessageId,
                                    message = it,
                                    dbMessageEntity = dbMessageEntity
                                )?.let { dbMessageEntity ->
                                    withContext(getPostExecutionThread.main) {
                                        callbackSuccess(
                                            listSubMessages,
                                            tempMessageId,
                                            messageRepository.mapMessageDBToUi(dbMessageEntity).apply {
                                                status = MessageStatusType.MESSAGE_SENT
                                            }
                                        )
                                    }
                                }
                            }
                            is ResultData.Failed -> screenState.postError(message = "")
                        }
                    }
                }
            }
        } else {
            launchOnViewModelScope(getPostExecutionThread.io) {
                val listIds = mutableListOf<Long>()
                neGroup?.members?.mapNotNull {
                    it.id
                }?.run {
                    listIds.addAll(this)
                }
                createGroup(type = groupType, listIDs = listIds, groupName = EMPTY, avatar = EMPTY).let { result ->
                    when (result) {
                        is ResultData.Success -> result.data?.let {
                            groupRepository.saveGroupToDB(group = it)?.let { savedGroup ->
                                neGroup = savedGroup
                                createGroupSuccess.post(EventLiveData(savedGroup))
                                createStickerMessage(
                                    neSticker = neSticker,
                                    callbackSuccess = callbackSuccess,
                                    callbackError = callbackError
                                )
                            }
                        }
                        is ResultData.Failed -> {
                            callbackError(result.message, "")
                            screenStateError.postErrorOnce(result.message)
                            Logger.e("error = ${result.message}")
                        }
                        else -> {
                        }
                    }
                }
            }
        }
    }

    fun recentStickerClick(stickerId: String?, time: Long) {
        stickerRepository.recentStickerClick(stickerId, time)
    }

    private suspend fun uploadThumbnailFile(
        messageId: String?,
        isEncryptedFile: Boolean,
        videoPath: String,
        context: Context? = null,
        callbackSuccess: (ResultData<String>) -> Unit = {},
        callbackError: (ResultData<String>) -> Unit = {}
    ) {
        FileUtils.getBitmapFromLocalPath(videoPath, context)?.let { thumbBitMap ->
            FileUtils.convertBitmapToUriTemp(thumbBitMap).let { thumbPath ->
                val thumbFileUpload = thumbPath?.path?.let { FileUpload(it, messageId = messageId) }
                val uploadWorkRequest = OneTimeWorkRequestBuilder<UploadWorker>().setInputData(
                    workDataOf(
                        UploadWorker.KEY_THUMBNAIL_ARG to true,
                        UploadWorker.KEY_ENCRYPT_ARG to isEncryptedFile,
                        UploadWorker.KEY_MEDIA_TYPE_ARG to jsonSerializer.asJson(MediaType.PHOTO, MediaType::class.java),
                        UploadWorker.KEY_UPLOAD_FILE_ARG to jsonSerializer.asJson(thumbFileUpload, FileUpload::class.java)
                    )
                ).build()
                WorkManager.getInstance(Utils.getApp()).enqueue(uploadWorkRequest)
                withContext(getPostExecutionThread.main) {
                    WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(uploadWorkRequest.id).observeForever(object : Observer<WorkInfo> {
                        override fun onChanged(workInfo: WorkInfo?) {
                            if (workInfo != null && workInfo.state.isFinished) {
                                jsonSerializer.asObject(workInfo.outputData.getString(UploadWorker.KEY_UPLOAD_RESULT), UploadResult::class.java)?.let {
                                    if (it.status == UploadResult.UploadResultStatus.SUCCESS) {
                                        callbackSuccess(ResultData.Success(data = it.fileUrl ?: ""))
                                    } else if (it.status == UploadResult.UploadResultStatus.FAIL) {
                                        callbackError(ResultData.Failed(message = it.message))
                                    }
                                }
                                WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(uploadWorkRequest.id).removeObserver(this)
                            }
                        }
                    })
                }
            }
        }
    }

    private fun goToViewMedia(neMedia: NeMedia, neGroup: NeGroup) {
        navigationDispatcher.emit {
            it.navigateIfSafe(BaseChatFragmentDirections.viewMedia(neMedia, isOpenFromChatMessage = true, neGroup = neGroup))
        }
    }

    fun displayMedia(url: String, neGroup: NeGroup, mediaType: Int, messageId: String? = "") {
        launchOnViewModelScope(getPostExecutionThread.io) {
            var neMedia = groupRepository.getMediaByUid(url.split("/").last())
            neMedia?.let {
                withContext(getPostExecutionThread.main) {
                    goToViewMedia(it, neGroup)
                }
            } ?: run {
                // handle play media for local link or media not yet insert database
                neMedia = NeMedia(
                    groupId = neGroup.id?.toLongOrNull() ?: 0L,
                    senderId = 0,
                    messId = messageId ?: "",
                    mediaUid = url,
                    mediaType = mediaType,
                    msgCreateAt = 0
                )
                withContext(getPostExecutionThread.main) {
                    goToViewMedia(neMedia!!, neGroup)
                }
            }
        }
    }

    fun clearUnreadMessageCount() {
        launchOnViewModelScope(getPostExecutionThread.io) {
            neGroup?.let { group ->
                /**
                 *  Garbage Collection: Need to recheck this logic
                 */
                // groupRepository.clearGroupMessageCountAndUpdateSeenStatus(group.id)

                group.lastMessage?.id.let { messageId ->
                    updateSeenForLatestMessage(
                        groupId = group.id,
                        messageId = messageId,
                        status = SocketMessageStatus.MESSAGE_STATUS_SEEN
                    )
                }
            }
        }
    }

    fun isCurrentGroup(currentGroupId: String?, updateGroupId: String?): Boolean {
        return currentGroupId == updateGroupId
    }

    fun isSecretGroup(groupId: String?) = socketRepository.getDbManager.isSecretGroup(groupId)

    suspend fun doActionShare(context: Context, neMessage: NeMessage): Intent? {
        var shareIntent: Intent? = null
        when (neMessage.type) {
            MessageType.MESSAGE_TYPE_TEXT -> {
                shareIntent = IntentUtils.getShareTextIntent(neMessage.content)
            }
            MessageType.MESSAGE_TYPE_IMAGE -> {
                if (neMessage.attachment?.images?.size ?: 0 > 1) {
                    val listUri = mutableListOf<Uri>()
                    neMessage.attachment?.images?.map { neImage ->
                        neImage.url?.getUrlImage()?.let { url ->
                            downloadFileForShare(url, ".jpeg")?.let { tempPath ->
                                if (tempPath.isNotNull) {
                                    listUri.add(Uri.parse(tempPath))
                                }
                            } ?: screenStateError.postErrorOnce(R.string.cant_download)
                        }
                    }
                    if (listUri.isNotEmpty()) {
                        shareIntent = IntentUtils.getShareImageIntent(ArrayList(listUri))
                    }
                } else {
                    var uriImageShare: Uri? = null
                    neMessage.attachment?.images?.get(0)?.apply {
                        url?.getUrlImage()?.let { url ->
                            downloadFileForShare(url, ".jpeg")?.let { tempPath ->
                                if (tempPath.isNotNull) {
                                    uriImageShare = Uri.parse(tempPath)
                                }
                            } ?: screenStateError.postErrorOnce(R.string.cant_download)
                        }
                    }
                    shareIntent = IntentUtils.getShareImageIntent(uriImageShare)
                }
            }
            MessageType.MESSAGE_TYPE_FILE -> {
                neMessage.attachment?.file?.url?.let {
                    shareIntent = doShareFile(context, it, neMessage.attachment?.file?.extension ?: "")
                }
            }
            MessageType.MESSAGE_TYPE_VIDEO -> {
                neMessage.attachment?.video?.url?.let {
                    shareIntent = doShareFile(context, it, Constants.VIDEO_PATTEN)
                }
            }
            MessageType.MESSAGE_TYPE_AUDIO -> {
                neMessage.attachment?.audio?.url?.let {
                    shareIntent = doShareFile(context, it, Constants.AUDIO_PATTEN)
                }
            }
        }
        return shareIntent
    }

    override fun onCleared() {
        super.onCleared()
        launchOnViewModelScope(getPostExecutionThread.io) {
            clearTempUploadFiles()
        }
    }

    fun destroy() {
        onCleared()
    }

    private fun clearTempUploadFiles() {
        if (neGroup?.isSecretChat() == true) {
            val tempUploadFilePath = "${Utils.getApp().filesDir.path}/${Constants.UPLOAD_FOLDER}"
            com.netacom.base.chat.android_utils.FileUtils.deleteAllInDir(tempUploadFilePath)
        }
    }

    private suspend fun downloadFileForShare(fileUrl: String, fileExtension: String): String? {
        var tempPathFile: String? = null
        downloadRepository.downloadFiles(arrayListOf(fileUrl.getUrlImage())).collect {
            when (it) {
                is ApiResponseSuccess -> {
                    val responseDownload = it.data
                    responseDownload?.let { responseBody ->
                        tempPathFile = FileUtils.saveFileToLocal(responseBody, "temp_file_${System.currentTimeMillis()}$fileExtension")
                    }
                }
                is ApiResponseError -> {
                    screenStateError.postErrorOnce(R.string.cant_download)
                }
            }
        }
        Logger.d("Temp Path: $tempPathFile")
        return tempPathFile
    }

    private suspend fun downloadFileForSave(messageId: String, fileUrl: String, fileExtension: String, type: Int) {
        downloadRepository.downloadFiles(arrayListOf(fileUrl.getUrlImage())).collect {
            when (it) {
                is ApiResponseSuccess -> {
                    val responseDownload = it.data
                    responseDownload?.let { responseBody ->
                        FileUtils.saveFileToLocal(responseBody, "downloaded_file_${messageId}_${System.currentTimeMillis()}$fileExtension", isSaveDocument = true, type = type)
                            .let { path ->
                                Logger.d("SAVE: $path")
                            }
                    }
                }
                is ApiResponseError -> {
                    screenStateError.postErrorOnce(R.string.cant_download)
                }
            }
        }
    }

    private suspend fun doShareFile(context: Context, fileUrl: String, fileExtension: String = ""): Intent? {
        var intentShareFile: Intent? = null
        fileUrl.getUrlImage()?.let {
            downloadFileForShare(it, fileExtension)?.let { tempPath ->
                if (tempPath.isNotNull) {
                    val tempFile = com.netacom.base.chat.android_utils.FileUtils.getFileByPath(tempPath)
                    intentShareFile = Intent().apply {
                        action = Intent.ACTION_SEND
                        addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)
                        putExtra(Intent.EXTRA_STREAM, Uri.parse(tempPath))
                        type = when (fileExtension) {
                            Constants.VIDEO_PATTEN -> "video/*"
                            Constants.AUDIO_PATTEN -> "audio/*"
                            else -> {
                                if (fileExtension.isNotNull) {
                                    "application/$fileExtension"
                                } else {
                                    FileUtils.getMimeType(tempFile)
                                }
                            }
                        }
                    }
                }
            }
        }

        return intentShareFile
    }

    /*
    * Check attachment is contain file path (local file) or file uid (server file)
    * */
    private fun checkAttachmentContainFilePath(dbMessageAttachmentEntity: DbMessageAttachmentEntity, type: Int): Boolean {
        var isContainLocalPath = false

        when (type) {
            MessageType.MESSAGE_TYPE_IMAGE -> {
                if (dbMessageAttachmentEntity.images.isNotEmpty()) {
                    dbMessageAttachmentEntity.images[0]?.url?.let {
                        if (it.split("/").size > 2) {
                            isContainLocalPath = true
                        }
                    }
                }
            }
            MessageType.MESSAGE_TYPE_VIDEO -> {
                dbMessageAttachmentEntity.video?.url?.let {
                    if (it.split("/").size > 2) {
                        isContainLocalPath = true
                    }
                }
            }
            MessageType.MESSAGE_TYPE_FILE -> {
                dbMessageAttachmentEntity.file?.url?.let {
                    if (it.split("/").size > 2) {
                        isContainLocalPath = true
                    }
                }
            }
            MessageType.MESSAGE_TYPE_AUDIO -> {
                dbMessageAttachmentEntity.audio?.url?.let {
                    if (it.split("/").size > 2) {
                        isContainLocalPath = true
                    }
                }
            }
        }

        return isContainLocalPath
    }

    private fun getListLocalFileFromMediaAttachment(dbMessageAttachmentEntity: DbMessageAttachmentEntity, type: Int): MutableList<LocalFileModel> {
        val listLocalFile = mutableListOf<LocalFileModel>()
        when (type) {
            MessageType.MESSAGE_TYPE_IMAGE -> {
                dbMessageAttachmentEntity.images?.map {
                    it.url?.let { path ->
                        if (com.netacom.base.chat.android_utils.FileUtils.isFileExists(path)) {
                            listLocalFile.add(FileUtils.getLocalFileByPath(path, MediaType.PHOTO))
                        }
                    }
                }
            }
            MessageType.MESSAGE_TYPE_VIDEO -> {
                dbMessageAttachmentEntity.video?.url?.let { path ->
                    if (com.netacom.base.chat.android_utils.FileUtils.isFileExists(path)) {
                        listLocalFile.add(FileUtils.getLocalFileByPath(path, MediaType.VIDEO))
                    }
                }
            }
            MessageType.MESSAGE_TYPE_AUDIO -> {
                dbMessageAttachmentEntity.audio?.url?.let { path ->
                    if (com.netacom.base.chat.android_utils.FileUtils.isFileExists(path)) {
                        listLocalFile.add(FileUtils.getLocalFileByPath(path, MediaType.AUDIO))
                    }
                }
            }
            MessageType.MESSAGE_TYPE_FILE -> {
                dbMessageAttachmentEntity.file?.url?.let { path ->
                    if (com.netacom.base.chat.android_utils.FileUtils.isFileExists(path)) {
                        listLocalFile.add(FileUtils.getLocalFileByPath(path, MediaType.FILE))
                    }
                }
            }
        }

        return listLocalFile
    }

    /*
    * Generate list upload file from list local file
    * */
    private suspend fun getListFileUploadByLocalFile(
        messageId: String?,
        listLocalFile: List<LocalFileModel>,
        mediaType: MediaType
    ): List<FileUpload> {
        return listLocalFile.mapIndexed { index, localFileModel ->
            when (mediaType) {
                MediaType.PHOTO -> {
//                    val file = CompressUtil.compressImage(localFileModel.filePath)
                    val imageSize = ImageUtils.getSize(localFileModel.filePath)
                    FileUpload(
                        file = localFileModel.filePath,
                        width = imageSize[0],
                        height = imageSize[1],
                        messageId = messageId,
                        index = index
                    )
                }
                else -> {
                    FileUpload(
                        file = localFileModel.filePath,
                        width = 0,
                        height = 0,
                        messageId = messageId,
                        index = index
                    )
                }
            }
        }
    }

    /*
    * Generate attachment follow list upload file response
    * */
    private fun createAttachmentByListUid(
        mediaType: MediaType,
        listUploadMedia: List<UploadFileSuccessModel>,
        dbMessageAttachmentEntity: DbMessageAttachmentEntity,
        videoThumb: String
    ): NeAttachments {
        val newAttachments = NeAttachments()
        when (mediaType) {
            MediaType.PHOTO -> {
                newAttachments.images = listUploadMedia.mapIndexed { index, uploadFileSuccessModel ->
                    NeImage(index, uploadFileSuccessModel.fileUid, uploadFileSuccessModel.fileWidth, uploadFileSuccessModel.fileHeight, index)
                }
            }

            MediaType.VIDEO -> {
                newAttachments.video = NeVideo(
                    url = listUploadMedia[0].fileUid,
                    duration = dbMessageAttachmentEntity.video?.duration,
                    thumbnailUrl = videoThumb,
                    width = dbMessageAttachmentEntity.video?.width ?: 0,
                    height = dbMessageAttachmentEntity.video?.height ?: 0
                )
            }

            MediaType.AUDIO -> {
                newAttachments.audio = NeAudio(
                    url = listUploadMedia[0].fileUid,
                    duration = dbMessageAttachmentEntity.audio?.duration ?: 0
                )
            }

            MediaType.FILE -> {
                newAttachments.mediaType = null
                newAttachments.file = NeDocument(
                    url = listUploadMedia[0].fileUid,
                    name = dbMessageAttachmentEntity.file?.name,
                    extension = dbMessageAttachmentEntity.file?.extension,
                    size = dbMessageAttachmentEntity.file?.size,
                    sizeText = if (dbMessageAttachmentEntity.file?.size == null) {
                        null
                    } else {
                        (dbMessageAttachmentEntity.file?.size ?: 0L).convertSize()
                    }
                )
            }
            MediaType.MAP -> {
                newAttachments.location = NeLocation(
                    // lat = dbMessageAttachmentEntity.location?.lat,
                    // long = dbMessageAttachmentEntity.location?.long,
                    // image_url = listUploadMedia[0].fileUid,
                    // width = dbMessageAttachmentEntity.video?.width ?: 0,
                    // height = dbMessageAttachmentEntity.video?.height ?: 0,
                    // address = dbMessageAttachmentEntity.location?.address
                )
            }
        }

        return newAttachments
    }

    fun sendForwardMessageAudio(
        forwardAudio: NeMessage,
        callbackSuccess: (List<NeSubMessage>, String?, NeMessage?) -> Unit,
        callbackError: (String, String) -> Unit
    ) {
        val groupId = neGroup?.id
        if (neGroup == null || groupId == null) return
        launchOnViewModelScope(getPostExecutionThread.io) {
            val groupType = neGroup?.type ?: GroupType.GROUP_TYPE_PUBLIC
            if (checkGroupExitsInDb(neGroup)) {
                val senderName = socketRepository.getUser?.getDisplayName ?: StringUtils.getString(R.string.unknown_user)
                val senderAvatar = socketRepository.getUser?.getDisplayAvatar ?: EMPTY
                val tempCreatedAt = TimerSupport.nowNano()
                val tempMessageId = (tempCreatedAt + 1).toString()

                val forwardAudioAttachment = forwardAudio.attachment?.let {
                    jsonSerializer.asJson(it, NeAttachments::class.java)
                }

                forwardAudioAttachment?.let { stringAudioAttachment ->
                    if (stringAudioAttachment.isNotNull) {
                        val tempMessage = Message(
                            messageId = tempMessageId,
                            groupId = groupId,
                            type = MessageType.MESSAGE_TYPE_AUDIO,
                            attachments = stringAudioAttachment,
                            senderUin = getUserId.toString(),
                            status = MessageStatusType.MESSAGE_SENDING
                        )
                        val dbMessageEntity = messageRepository.mapMessageSKToDb(tempMessage)
                        messageRepository.insertMessageAndUpdateGroup(dbMessageEntity, groupId, false)?.let {
                            if (it) {
                                // Step 1: update temp message to UI with status = sending
                                // actionUpdateTempMessageToUi(dbMessageEntity = dbMessageEntity, callbackSuccess = callbackSuccess)
                                sendMessageToSocket(groupId, tempMessageId, tempMessage, senderName, senderAvatar, dbMessageEntity, callbackSuccess)
                            } else {
                                // Update message with status = false
                                actionUpdateTempMessageToUi(true, tempMessageId, dbMessageEntity, callbackSuccess)
                            }
                        }
                    }
                }
            } else {
                val listIds = mutableListOf<Long>()
                neGroup?.members?.mapNotNull {
                    it.id
                }?.run {
                    listIds.addAll(this)
                }
                createGroup(type = groupType, listIDs = listIds, groupName = EMPTY, avatar = EMPTY).let { result ->
                    when (result) {
                        is ResultData.Success -> result.data?.let {
                            groupRepository.saveGroupToDB(group = it)?.let { savedGroup ->
                                neGroup = savedGroup
                                createGroupSuccess.post(EventLiveData(savedGroup))
                                sendForwardMessageAudio(
                                    forwardAudio,
                                    callbackSuccess,
                                    callbackError
                                )
                            }
                        }
                        is ResultData.Failed -> {
                            result.message?.let { callbackError(it, "") }
                            Logger.e("error = ${result.message}")
                        }
                        else -> {
                        }
                    }
                }
            }
        }
    }

    fun replyMessage(neMessage: NeMessage) {
        _messageFunctionReply.post(EventLiveData(neMessage))
    }

    fun forwardMessage(neMessage: NeMessage) {
        _messageFunctionCopy.post(EventLiveData(neMessage))
    }

    fun downloadMediaMessage(neMessage: NeMessage) {
        var isDownloaded = false
        launchOnViewModelScope(getPostExecutionThread.io) {
            when (neMessage.type) {
                MessageType.MESSAGE_TYPE_IMAGE -> {
                    val downloadSize = neMessage.attachment?.images?.size ?: 0
                    if (downloadSize > 1) {
                        var downloadCount = 0
                        neMessage.attachment?.images?.map { neImage ->
                            neImage.url?.getUrlImage()?.let { url ->
                                downloadFileForSave(neMessage.id ?: "", url, ".jpeg", MessageType.MESSAGE_TYPE_IMAGE)
                                downloadCount++
                            }
                        }
                        isDownloaded = downloadCount == downloadSize
                    } else {
                        neMessage.attachment?.images?.get(0)?.apply {
                            url?.getUrlImage()?.let { url ->
                                downloadFileForSave(neMessage.id ?: "", url, ".jpeg", MessageType.MESSAGE_TYPE_IMAGE)
                                isDownloaded = true
                            }
                        }
                    }
                }
                MessageType.MESSAGE_TYPE_FILE -> {
                    neMessage.attachment?.file?.url?.let {
                        downloadFileForSave(neMessage.id ?: "", it, neMessage.attachment?.file?.extension ?: "", MessageType.MESSAGE_TYPE_FILE)
                        isDownloaded = true
                    }
                }
                MessageType.MESSAGE_TYPE_VIDEO -> {
                    neMessage.attachment?.video?.url?.let {
                        downloadFileForSave(neMessage.id ?: "", it, Constants.VIDEO_PATTEN, MessageType.MESSAGE_TYPE_VIDEO)
                        isDownloaded = true
                    }
                }
                MessageType.MESSAGE_TYPE_AUDIO -> {
                    neMessage.attachment?.audio?.url?.let {
                        downloadFileForSave(neMessage.id ?: "", it, Constants.AUDIO_PATTEN, MessageType.MESSAGE_TYPE_AUDIO)
                        isDownloaded = true
                    }
                }
            }
            downloadMediaMessage.post(EventLiveData(isDownloaded))
        }
    }

    private fun shareMessage(neMessage: NeMessage) {
        _messageFunctionShare.post(EventLiveData(neMessage))
    }

    fun saveTimeOutForSecretChat(timeOut: Int) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            groupRepository.getGroupDbById(neGroup?.id)?.let {
                groupRepository.saveTimeOutForSecretChat(it, timeOut)
                _timeOutSecretChat.post(timeOut)
                neGroup?.timeOut = timeOut
                neGroup?.let { it1 -> sendMessageUpdateGroupSecretTimeNotification(it1, timeOut) }
            }
        }
    }

    fun getGroupDbById(groupId: String): NeGroup? {
        groupRepository.getGroupDbById(groupId)?.let {
            return groupRepository.convertDBToNeGroup(it)
        } ?: return null
    }

    fun generateQrCode(text: String?, callbackResult: CallbackResult<Bitmap>) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            Logger.e("generateQrCode==$text")
            val width = 500
            val height = 500
            val bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888)
            val codeWriter = MultiFormatWriter()
            try {
                val bitMatrix = codeWriter.encode(text, BarcodeFormat.QR_CODE, width, height)
                for (x in 0 until width) {
                    for (y in 0 until height) {
                        bitmap.setPixel(x, y, if (bitMatrix[x, y]) Color.BLACK else Color.WHITE)
                    }
                }
                withContext(getPostExecutionThread.main) {
                    callbackResult.callBackSuccess(result = bitmap)
                }
            } catch (e: Exception) {
                Logger.d("generateQRCode: ${e.message}")
                callbackResult.callBackError(error = e.message.toString())
            }
        }
    }

    // Navigation

    private fun getTimeOutForSecretChat() = groupRepository.getTimeOutForSecretChat(neGroup?.id)

    private fun isGroupOwner(): Boolean = neGroup?.type == GroupType.GROUP_TYPE_GROUP && neGroup?.owner?.id == socketRepository.getUserId

    private fun isNotGroupChat(): Boolean = neGroup?.type != GroupType.GROUP_TYPE_GROUP

    fun showMemberOrGroupInfo(neGroup: NeGroup) {
        navigationDispatcher.emit {
            it.navigateIfSafe(BaseChatFragmentDirections.openInfo(CallInfoModel(neGroup = neGroup)))
        }
    }

    fun addNewContact(neUser: NeUser?, isChat: Boolean = true, className: String? = null) {
        navigationDispatcher.emit {
            it.navigate(BaseChatFragmentDirections.addContactPhone(neUser, isChat, className = className))
        }
    }

    fun showAction(neMessage: NeMessage, neGroup: NeGroup) {
        navigationDispatcher.emit {
            it.navigateIfSafe(
                BaseChatFragmentDirections.openMessageFunction(
                    neMessage = neMessage,
                    isSenderOrOwner = isGroupOwner() || isNotGroupChat(),
                    neGroup = neGroup
                )
            )
        }
    }

    fun getBackgroundImages(callbackResult: CallbackResult<List<ImageBackgroundResponse.ImageBackground>>) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            groupRepository.getChatBackgroundImages().collect { state ->
                when (state) {
                    is ApiResponseSuccess -> {
                        state.data?.let {
                            withContext(getPostExecutionThread.main) {
                                callbackResult.callBackSuccess(it.backgrounds)
                            }
                        }
                    }
                    is ApiResponseError -> {
                        withContext(getPostExecutionThread.main) {
                            callbackResult.callBackError(state.data.toString())
                        }
                    }
                }
            }
        }
    }

    fun showPickPhoto(neMessage: NeMessage) {
        navigationDispatcher.emit {
            it.navigateIfSafe(
                BaseChatFragmentDirections.chooseMedia(
                    neMessage = neMessage,
                    isChat = false
                )
            )
        }
    }

    fun actionForward() {
        navigationDispatcher.emit { nav ->
            nav.navigateIfSafe(
                MessageFunctionDialogDirections.actionMessageFunctionToForwardMessageDialog(
                    null
                )
            )
        }
    }

    fun updateGroupBackground(
        neGroup: NeGroup,
        updateBackground: UpdateBackgroundRequest,
        callbackResult: CallbackResult<NeGroup>
    ) {
        val groupId = neGroup.id?.toLongOrNull() ?: return
        launchOnViewModelScope(getPostExecutionThread.io) {
            val owner = neGroup.owner?.id.toString()
            updateGroup(
                groupId = groupId,
                owner = owner,
                name = "",
                background = updateBackground
            ).let { result ->
                when (result) {
                    is ResultData.Success -> result.data?.let {
                        groupRepository.saveGroupToDB(group = it)?.let { neGroup ->
                            updateGroup(neGroup)
                            sendMessageUpdateBackground(neGroup, updateBackground)
                            callbackResult.callBackSuccess(neGroup)
                        }
                    }
                    is ResultData.Failed -> {
                        screenStateError.postErrorOnce(result.message)
                        callbackResult.callBackError(result.message)
                    }
                    else -> {
                        callbackResult.callBackError(result.toString())
                    }
                }
            }
        }
    }

    private fun sendMessageUpdateBackground(
        neGroup: NeGroup,
        background: UpdateBackgroundRequest?
    ) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            val neMessage: NeMessage? = NeMessage()
            neMessage.let { updateGroup ->
                updateGroup?.type = MessageType.MESSAGE_TYPE_GROUP_UPDATE
                updateGroup?.attachment = NeAttachments(
                    type = "group_update",
                    updatedGroupBackground = NeBackground(background_url = background?.background_url, is_blur = background?.is_blur ?: false),
                )
                updateGroup?.let {
                    createUpdateGroup(
                        neGroup = neGroup,
                        updatedGroup = it,
                        isAddMember = false,
                        callbackResult = object : CallbackResult<Message> {
                            override fun callBackSuccess(result: Message) {
                                getListMessage()
                            }

                            override fun callBackError(error: String?) {
                            }
                        }
                    )
                }
            }
        }
    }

    fun updateGroupLocalBackground(neGroup: NeGroup, updateBackground: UpdateBackgroundRequest) {
        val groupId = neGroup.id?.toLongOrNull() ?: return
        launchOnViewModelScope(getPostExecutionThread.io) {
            getDbManager.updateLocalBackgroundGroup(groupId, updateBackground.toString())
        }
    }

    fun actionShare(neMessage: NeMessage?, callbackResult: CallbackResult<Boolean>) {
        navigationDispatcher.emit {
            neMessage?.let { _neMessage ->
                shareMessage(_neMessage)
                callbackResult.callBackSuccess(true)
            } ?: callbackResult.callBackError()
        }
    }

    fun openForward(neGroup: NeGroup, callbackResult: () -> Unit?) {
        navigationDispatcher.emit { nav ->
            callbackResult()
            nav.navigateIfSafe(ForwardMessageDialogDirections.actionForwardMessageDialogToChatGroupFragment(neGroup))
        }
    }

    private fun sendMessageUpdateGroupSecretTimeNotification(
        neGroup: NeGroup,
        timer: Int?
    ) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            val neMessage = NeMessage()
            neMessage.let { updateGroup ->
                updateGroup.type = MessageType.MESSAGE_TYPE_GROUP_UPDATE
                updateGroup.attachment = NeAttachments(
                    type = "update_group",
                    updated_message_delete_timer = timer
                )
                createUpdateGroup(
                    neGroup = neGroup,
                    updatedGroup = updateGroup,
                    isAddMember = false,
                    callbackResult = object : CallbackResult<Message> {
                        override fun callBackSuccess(result: Message) {
                            getListMessage()
                        }

                        override fun callBackError(error: String?) {
                        }
                    }

                )
            }
        }
    }

    fun convertMessages(listNeMessage: List<NeMessage>) = messageRepository.convertNeMessToNeSubMess(listNeMessage)
}
