package com.netacom.full.ui.main.chat

import android.text.Editable
import android.text.TextWatcher
import android.util.Log
import android.view.View
import androidx.core.content.ContextCompat
import androidx.core.widget.doAfterTextChanged
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.lifecycleScope
import androidx.navigation.fragment.navArgs
import androidx.recyclerview.widget.LinearLayoutManager
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.util.isNotNull
import com.netacom.base.chat.util.unAccentText
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.PopupForwardMessageBinding
import com.netacom.full.ui.main.chat.adapter.ForwardMessageAdapter
import com.netacom.full.ui.main.chat.adapter.ForwardMessageAdapter.Companion.ALL
import com.netacom.full.ui.main.chat.adapter.ForwardMessageAdapter.Companion.RECENTLY
import com.netacom.full.ui.main.group.GroupViewModel
import com.netacom.lite.define.MediaType
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.entity.ui.message.NeForwardMessage
import com.netacom.lite.util.CallbackResult
import com.netacom.lite.util.FileUtils
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import java.util.Locale
import java.util.regex.Pattern
import kotlin.coroutines.CoroutineContext

/**
 * I've clone this class from the old project, will be refactor it later.
 */
@AndroidEntryPoint
class ForwardMessageDialog :
    BaseSDKBottomDialog<PopupForwardMessageBinding, ChatViewModel>(
        R.layout.popup_forward_message,
        ChatViewModel::class.java
    ),
    CoroutineScope {

    override val coroutineContext: CoroutineContext
        get() = Dispatchers.Main

    private val args: ForwardMessageDialogArgs by navArgs()

    private lateinit var forwardMessageAdapter: ForwardMessageAdapter
    private val neForwardItemsAll = mutableListOf<NeForwardMessage>()
    private val neForwardItemsRecently = mutableListOf<NeForwardMessage>()

    private val groupViewModel: GroupViewModel by activityViewModels()
    private val chatViewModel: ChatViewModel by activityViewModels()

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun setViewModel(): Int = BR.viewModel

    private var tabSelect = 0
    private var job: Job? = null

    override fun initViews() {
        val mediaPath = args.forwardMediaPath
        binding.recyclerView.layoutManager = LinearLayoutManager(context)
        forwardMessageAdapter = ForwardMessageAdapter(
            currentUserId = chatViewModel.getUserId,
            itemClick = { item, _, _ ->
                /*
                * check forward
                * if forward media path
                * => set forward local file
                * => set is forward media = true
                * */
                if (item.type == ALL) {
                    item.neUser?.id?.let {
                        groupViewModel.checkPartnerId(
                            it,
                            callbackResult = object : CallbackResult<NeGroup> {
                                override fun callBackSuccess(result: NeGroup) {
                                    Log.d("TAG", "TAG_ForwardMessageDialog callBackSuccess")
                                    dismiss()
                                    if (mediaPath != null && mediaPath.isNotNull) {
                                        chatViewModel.forwardMedia = FileUtils.getLocalFileByPath(mediaPath, MediaType.PHOTO)
                                        viewModel.forwardSelectedGroup = result
                                    }
                                    chatViewModel.isForwardMessage = true
                                    viewModel.initNeGroup(result)
                                }

                                override fun callBackError(error: String?) {
                                    Log.d("TAG", "TAG_ForwardMessageDialog callBackError")
                                }
                            }
                        )
                    }
                } else if (item.type == RECENTLY) {
                    item.neGroup?.let { _neGroup ->
                        viewModel.openForward(_neGroup) {
                            dismiss()
                            if (mediaPath != null && mediaPath.isNotNull) {
                                chatViewModel.forwardMedia = FileUtils.getLocalFileByPath(mediaPath, MediaType.PHOTO)
                                viewModel.forwardSelectedGroup = _neGroup
                            }
                            chatViewModel.isForwardMessage = true
                            viewModel.initNeGroup(_neGroup)
                        }
                    }
                }
            }
        )

        binding.recyclerView.adapter = forwardMessageAdapter

        val filterTabRecently: (String) -> Unit = { filterBy ->
            job?.cancel()
            job = lifecycleScope.launch(Dispatchers.IO) {
                neForwardItemsRecently.filter { entry ->
                    if (entry.neGroup?.type == 2) {
                        entry.neGroup?.getDisplayName?.unAccentText()?.contains(filterBy, true) ?: false
                    } else {
                        entry.neGroup?.owner?.getDisplayName?.unAccentText()?.contains(filterBy, true) ?: false
                    }
                }.let { listData ->
                    withContext(Dispatchers.Main) {
                        forwardMessageAdapter.display(listData)
                    }
                }
            }
        }
        val filterTabAllContact: (String) -> Unit = { filterBy ->
            job?.cancel()
            job = lifecycleScope.launch(Dispatchers.IO) {
                neForwardItemsAll.filter { entry ->
                    entry.neUser?.getDisplayName?.unAccentText()?.contains(filterBy, true) ?: false
                }.let { neForwardItems ->
                    val regex = "[A-Z]"
                    val pattern = Pattern.compile(regex)

                    neForwardItems.sortedBy {
                        val userName = it.neUser?.getDisplayName ?: ""
                        val sortName = userName.split(" ").firstOrNull() ?: ""
                        sortName.toUpperCase(Locale.getDefault())
                    }.let {
                        var headers = ""
                        var count = 0
                        val result = mutableListOf<NeForwardMessage>()

                        for (entry in it) {
                            val userName = entry.neUser?.getDisplayName ?: ""
                            val sortName = userName.split(" ").firstOrNull() ?: ""

                            if (sortName.isNotEmpty()) {
                                var header = sortName.take(1).toUpperCase(Locale.getDefault())
                                header = if (pattern.matcher(header).matches()) header else "#"

                                if (headers.contains(header)) {
                                    if (header != "#") {
                                        result.add(
                                            result.size - count,
                                            NeForwardMessage(
                                                type = ALL,
                                                neUser = entry.neUser
                                            )
                                        )
                                    } else {
                                        count += 1
                                        result.add(
                                            NeForwardMessage(
                                                type = ALL,
                                                neUser = entry.neUser
                                            )
                                        )
                                    }
                                } else {
                                    headers += header
                                    if (header != "#") {
                                        result.add(
                                            result.size - count,
                                            NeForwardMessage(
                                                type = ForwardMessageAdapter.HEADER,
                                                header = header
                                            )
                                        )
                                        result.add(
                                            result.size - count,
                                            NeForwardMessage(
                                                type = ALL,
                                                neUser = entry.neUser
                                            )
                                        )
                                    } else {
                                        count += 2
                                        result.add(
                                            NeForwardMessage(
                                                type = ForwardMessageAdapter.HEADER,
                                                header = header
                                            )
                                        )
                                        result.add(
                                            NeForwardMessage(
                                                type = ALL,
                                                neUser = entry.neUser
                                            )
                                        )
                                    }
                                }
                            } else {
                                result.add(
                                    NeForwardMessage(
                                        type = ALL,
                                        neUser = entry.neUser
                                    )
                                )
                            }
                        }
                        withContext(Dispatchers.Main) {
                            forwardMessageAdapter.display(result)
                        }
                    }
                }
            }
        }

        val selectRecently = {
            binding.pfmTvRecently.setTextColor(ContextCompat.getColor(requireContext(), R.color.color_white))
            binding.pfmTvRecently.background = ContextCompat.getDrawable(requireContext(), R.drawable.bg_forward_select_button)
            binding.pfmTvAll.setTextColor(ContextCompat.getColor(requireContext(), R.color.color_grey_959595))
            binding.pfmTvAll.background = ContextCompat.getDrawable(requireContext(), android.R.color.transparent)

            if (neForwardItemsRecently.isNullOrEmpty()) {
                launch(Dispatchers.IO) {
                    val listRecent = viewModel.getListGroup()
                    neForwardItemsRecently.clear()
                    neForwardItemsRecently.addAll(
                        listRecent.map { neGroup ->
                            NeForwardMessage(
                                type = RECENTLY,
                                neGroup = neGroup
                            )
                        }
                    )
                    withContext(Dispatchers.Main) {
                        forwardMessageAdapter.display(neForwardItemsRecently)
                    }
                }
            }
            filterTabRecently(binding.pfmEdtSearch.text?.trim()?.toString()?.unAccentText() ?: "")

            themeHelperImpl.setThemeColorForViews(binding.pfmTvRecently)
        }

        val selectAllContact = {
            binding.pfmTvRecently.setTextColor(ContextCompat.getColor(requireContext(), R.color.color_grey_959595))
            binding.pfmTvRecently.background = ContextCompat.getDrawable(requireContext(), android.R.color.transparent)
            binding.pfmTvAll.setTextColor(ContextCompat.getColor(requireContext(), R.color.color_white))
            binding.pfmTvAll.background = ContextCompat.getDrawable(requireContext(), R.drawable.bg_forward_select_button)

            if (neForwardItemsAll.isNullOrEmpty()) {
                viewModel.getListContactRegistered().run {
                    neForwardItemsAll.clear()
                    neForwardItemsAll.addAll(
                        this.map { neUser ->
                            NeForwardMessage(
                                type = ALL,
                                neUser = neUser
                            )
                        }
                    )
                }
            }
            filterTabAllContact(binding.pfmEdtSearch.text?.trim()?.toString()?.unAccentText() ?: "")
            themeHelperImpl.setThemeColorForViews(binding.pfmTvAll)
        }

        when (tabSelect) {
            0 -> {
                selectRecently()
            }
            1 -> {
                selectAllContact()
            }
        }

        binding.pfmTvRecently.setOnClickListener {
            if (tabSelect != 0) {
                tabSelect = 0
                selectRecently()
            }
        }
        binding.pfmTvAll.setOnClickListener {
            if (tabSelect != 1) {
                tabSelect = 1
                selectAllContact()
            }
        }

        binding.pfmTvCancel.setOnClickListener {
            dismiss()
        }

        val watcher = object : TextWatcher {
            private var searchFor = ""

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                val searchText = s.toString().trim()
                if (searchText == searchFor) {
                    return
                }

                searchFor = searchText

                launch {
                    delay(500) // debounce timeOut
                    if (searchText != searchFor) {
                        return@launch
                    }
                    // do our magic here
                    Logger.d("__ForwardMessage Search = $searchText")
                    when (tabSelect) {
                        0 -> {
                            Logger.d("__ForwardMessage Search 00000 = ")
                            filterTabRecently(searchText)
                        }
                        1 -> {
                            Logger.d("__ForwardMessage Search 11111 = ")
                            filterTabAllContact(searchText)
                        }
                    }
                }
            }

            override fun afterTextChanged(s: Editable?) = Unit
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) = Unit
        }

        binding.pfmEdtSearch.addTextChangedListener(watcher)

        binding.pfmEdtSearch.doAfterTextChanged {
            it ?: return@doAfterTextChanged
            binding.pfmTvSearch.visibility = if (it.toString().isNotEmpty()) View.GONE else View.VISIBLE
        }
    }

    override fun initData() {
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(pfmTvCancel)
        }
    }
}
