package com.netacom.full.ui.main.chat

import android.content.Intent
import android.graphics.Bitmap
import androidx.core.view.drawToBitmap
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.fragment.app.activityViewModels
import androidx.navigation.fragment.navArgs
import com.netacom.base.chat.android_utils.IntentUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.util.getThemeColor
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.ViewQrcodePopupBinding
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.utils.DialogUtil
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.util.CallbackResult
import com.netacom.lite.util.FileUtils
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class GroupQrCodeDialog : BaseSDKBottomDialog<ViewQrcodePopupBinding, ChatViewModel>(
    R.layout.view_qrcode_popup,
    ChatViewModel::class.java
) {

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun setViewModel(): Int = BR.viewModel

    private val args: GroupQrCodeDialogArgs by navArgs()

    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()

    private var neGroup: NeGroup? = null

    private var groupLink: String? = null

    override fun initViews() {
        groupLink = args.groupLink
        neGroup = args.neGroup
        binding.neGroup = neGroup

        with(binding) {
            tvGroupName.text = neGroup?.getDisplayName
            ivQrcode.bringToFront()
            viewModel.generateQrCode(
                groupLink,
                object : CallbackResult<Bitmap> {
                    override fun callBackSuccess(result: Bitmap) {
                        ivQrcode.setImageBitmap(result)
                    }

                    override fun callBackError(error: String?) {
                        showSnackBar(error.toString())
                    }
                }
            )

            if (neGroup?.owner?.id == preferencesHelperImpl.getUserId) {
                tvResetQrCode.isVisible = true
                tvResetQrCode.clickDebounce {
                    showDialogConfirmChangeQrCode()
                }
            } else {
                tvResetQrCode.isGone = true
            }

            tvShare.clickDebounce {
                FileUtils.getImageUriShare(requireContext(), flQrcode.drawToBitmap())?.let { uri ->
                    val shareIntent = Intent.createChooser(IntentUtils.getShareImageIntent(uri), getString(R.string.app_name))
                    startActivity(shareIntent)
                }
                // Forward
//                navigationDispatcher.emit { nav ->
//                    bitmapUri?.let {
//                        val path = FileUtils.getRealPathFromURI(requireContext(), it)
//                        if (path.isNotNull) {
//                            nav.navigateIfSafeClearStack(GroupQrCodeDialogDirections.actionQrCodeToForwardMessageDialog(path))
//                        }
//                    }
//                }
            }

            icClose.clickDebounce {
                dismiss()
            }
        }
    }

    override fun initData() {
    }

    private fun showDialogCantJoinGroup() {
        DialogUtil.showMessage(
            context = requireContext(),
            title = R.string.qr_code_not_join_group_title,
            message = R.string.qr_code_not_join_group_description,
            okLabel = R.string.qr_code_not_join_group_text_button,
            okFunc = {
                // TO DO
            },
            cancelButtonIsGone = true,
            themeHelperImpl = themeHelperImpl
        )
    }

    private fun showDialogConfirmChangeQrCode() {
        DialogUtil.showMessage(
            context = requireContext(),
            title = R.string.qr_code_change_title,
            message = R.string.qr_code_change_description,
            okLabel = R.string.qr_code_change_text_button,
            cancelLabel = R.string.str_cancel,
            okFunc = {
                neGroup?.id?.toLongOrNull()?.let { groupId ->
                    if (neGroup?.owner?.id == preferencesHelperImpl.getUserId) {
                        mainSdkViewModel.createDeepLink(
                            groupId,
                            object : CallbackResult<String?> {
                                override fun callBackSuccess(result: String?) {
                                    showDialogQrCodeSuccess(result)
                                }

                                override fun callBackError(error: String?) {
                                }
                            }
                        )
                    } else {
                        mainSdkViewModel.getDeepLink(
                            groupId,
                            object : CallbackResult<String?> {
                                override fun callBackSuccess(result: String?) {
                                    showDialogQrCodeSuccess(result)
                                }

                                override fun callBackError(error: String?) {
                                }
                            }
                        )
                    }
                }
            },
            cancelFunc = {
            },
            themeHelperImpl = themeHelperImpl
        )
    }

    private fun showDialogQrCodeSuccess(groupLink: String?) {
        DialogUtil.showMessage(
            context = requireContext(),
            title = R.string.qr_code_change_successfully,
            okLabel = R.string.qr_code_not_join_group_text_button,
            okFunc = {
                viewModel.generateQrCode(
                    groupLink,
                    object : CallbackResult<Bitmap> {
                        override fun callBackSuccess(result: Bitmap) {
                            binding.ivQrcode.setImageBitmap(result)
                        }

                        override fun callBackError(error: String?) {
                            showSnackBar(error.toString())
                        }
                    }
                )
            },
            cancelButtonIsGone = true,
            themeHelperImpl = themeHelperImpl
        )
    }

    override fun setupTheme() {
        with(binding) {
            main.setBackgroundColor(getThemeColor(themeHelperImpl.mainColor))
            themeHelperImpl.setThemeColorForViews(tvShare)
//            themeHelperImpl.setThemeColorForSubBackground(ivGroupChat, ivSecretChat, ivCreateChannel)
        }
    }
}
