package com.netacom.full.ui.main.chat

import androidx.fragment.app.activityViewModels
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.FragmentRegisteredUserBinding
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.ui.main.chat.adapter.RegisteredUserAdapter
import com.netacom.full.ui.main.contact.ContactViewModel
import com.netacom.lite.define.SyncType
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class RegisteredUserFragment : BaseSDKBottomDialog<FragmentRegisteredUserBinding, ContactViewModel>(
    R.layout.fragment_registered_user,
    ContactViewModel::class.java
) {

    companion object {
        const val TAG = "_RegisteredUserFragment"
    }

    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()
    private lateinit var registeredUserAdapter: RegisteredUserAdapter

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        registeredUserAdapter = RegisteredUserAdapter { item, _, _ -> {} }

        binding.recyclerView.adapter = registeredUserAdapter
    }

    override fun initData() {
        checkPermissionContact(
            {
                mainSdkViewModel.syncContact(SyncType.LIST_SYNC_SERVER)
            },
            {
            }
        )
    }

    override fun setupTheme() {
    }
}
