package com.netacom.full.ui.main.chat

import androidx.fragment.app.FragmentManager
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.ViewSetTimePopupBinding
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class SetTimeDeleteDialog : BaseSDKBottomDialog<ViewSetTimePopupBinding, ChatViewModel>(
    R.layout.view_set_time_popup,
    ChatViewModel::class.java
) {

    companion object {
        private val TAG: String = this::class.java.simpleName
    }

    fun show(manager: FragmentManager, value: Int) {
        if (isVisible) return
        curValue = value
        super.show(manager, TAG)
    }

    private var curValue: Int = 0

    override fun setViewModel(): Int = BR.viewModel

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_WRAP_CONTENT

    override fun initViews() {
        val listTime: Array<Int> = arrayOf(0, 2, 5, 10, 30, 60, 90)
        val listTimeString = listTime.map {
            if (it == 0) StringUtils.getString(R.string.popup_set_time_turn_offf)
            else "$it ${StringUtils.getString(R.string.popup_set_time_second)}"
        }.toTypedArray()

        binding.numberPicker.maxValue = listTime.size - 1
        binding.numberPicker.minValue = 0
        binding.numberPicker.wrapSelectorWheel = false
        binding.numberPicker.displayedValues = listTimeString
        binding.numberPicker.value = listTime.indexOf(curValue)
        binding.numberPicker.setFormatter { p0 -> listTimeString[p0] }
        binding.txtFinish.clickDebounce {
            viewModel.saveTimeOutForSecretChat(listTime[binding.numberPicker.value])
            dismiss()
        }
        binding.tvCancel.clickDebounce { dismiss() }
    }

    override fun initData() {
    }

    override fun setupTheme() {
        themeHelperImpl.setThemeColorForSecretBackground(binding.tvCancel)
        themeHelperImpl.setThemeColorForSecretBackground(binding.txtFinish)
    }
}
