package com.netacom.full.ui.main.chat

import androidx.fragment.app.FragmentManager
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.ViewSetTimePopupBinding

class TimerLocationDialog(private val onTimeValue: (Int) -> Unit) : BaseSDKBottomDialog<ViewSetTimePopupBinding, ChatViewModel>(
    R.layout.view_set_time_popup,
    ChatViewModel::class.java
) {
    companion object {
        private val TAG: String = this::class.java.simpleName
    }

    fun show(manager: FragmentManager) {
        if (isVisible) return
        super.show(manager, TimerLocationDialog.TAG)
    }

    override fun setViewModel(): Int = BR.viewModel

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_WRAP_CONTENT

    override fun initViews() {
        binding.tvTitle.text = StringUtils.getString(R.string.timer_location_title)
        val listTime: Array<Int> = arrayOf(15, 1, 8)
        val listTimeString = listTime.map {
            if (it == 15) "$it ${StringUtils.getString(R.string.popup_set_time_minutes)}"
            else "$it ${StringUtils.getString(R.string.popup_set_time_hours)}"
        }.toTypedArray()

        binding.numberPicker.maxValue = listTime.size - 1
        binding.numberPicker.minValue = 0
        binding.numberPicker.wrapSelectorWheel = false
        binding.numberPicker.displayedValues = listTimeString
        binding.numberPicker.setFormatter { p0 -> listTimeString[p0] }
        binding.txtFinish.clickDebounce {
            onTimeValue.invoke(listTime[binding.numberPicker.value])
            dismiss()
        }

        binding.tvCancel.clickDebounce { dismiss() }
    }

    override fun initData() {
    }

    override fun setupTheme() {
    }
}
