package com.netacom.full.ui.main.chat.adapter

import android.graphics.Color
import android.view.View
import com.netacom.base.chat.adapter.BaseSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.R
import com.netacom.full.databinding.ItemChangeBackgroundBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.network.model.response.ImageBackgroundResponse

class ChangeBackgroundAdapter(
    itemClick: ((ImageBackgroundResponse.ImageBackground, View, Int) -> Unit)?,
    private var selectedBackgroundUrl: String?,
    private val themeHelperImpl: ThemeHelperImpl
) : BaseSimpleAdapter<ImageBackgroundResponse.ImageBackground, ItemChangeBackgroundBinding>(itemClick) {
    companion object {
        const val DEFAULT_BACKGROUND = -1
    }
    override fun bind(
        item: ImageBackgroundResponse.ImageBackground,
        holder: BaseViewHolder<ItemChangeBackgroundBinding>,
        position: Int
    ) {
        if (item.backgroundId == DEFAULT_BACKGROUND) {
            holder.binding.ivBackground.setImageResource(R.color.color_background)
            if (selectedBackgroundUrl.isNullOrEmpty()) {
                holder.binding.llContain.setBackgroundResource(R.drawable.bg_item_change_background)
            }
        } else {
            holder.binding.ivBackground.loadImage(item.backgroundUrl)
        }

        selectedBackgroundUrl?.let { selectedUrl ->
            if (selectedUrl == item.backgroundUrl) {
                holder.binding.llContain.setBackgroundResource(R.drawable.bg_item_change_background)
                themeHelperImpl.setThemeColorForBorder(holder.binding.llContain.background)
            } else {
                holder.binding.llContain.setBackgroundColor(Color.TRANSPARENT)
            }
        }
    }

    fun setSelectedBackgroundUrl(url: String) {
        selectedBackgroundUrl = url
        notifyDataSetChanged()
    }

    override val layout: Int
        get() = R.layout.item_change_background
}
