package com.netacom.full.ui.main.chat.adapter

import android.view.View
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.full.R
import com.netacom.full.databinding.ItemRcvMentionBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.user.NeUser

/**
 * Clone this class from old project, will be replace it with MentionAdapter
 */
class ChatMentionAdapter(itemClick: ((NeUser, View, Int) -> Unit)?, private val themeHelperImpl: ThemeHelperImpl) :
    BaseListSimpleAdapter<NeUser, ItemRcvMentionBinding>(itemClick, diff = DiffUtilCallback()) {

    override fun bind(item: NeUser, holder: BaseViewHolder<ItemRcvMentionBinding>, position: Int) {
        with(holder.binding) {
            this.item = item
            item.id?.let { id ->
                if (id == 1L) {
                    this.ivAvatar.isGone = true
                    this.ivAvatarIcon.isVisible = true
                    this.ivAvatarIcon.setImageResource(R.drawable.ic_create_group_chat)
                } else {
                    this.ivAvatarIcon.isGone = true
                    this.ivAvatar.isVisible = true
                }
            }
            themeHelperImpl.setThemeColorForViews(this.ivAvatarIcon)
            themeHelperImpl.setThemeColorForSubBackground(this.ivAvatarIcon)
        }
    }

    override val layout: Int = R.layout.item_rcv_mention

    private class DiffUtilCallback : DiffUtil.ItemCallback<NeUser>() {

        override fun areItemsTheSame(oldItem: NeUser, newItem: NeUser): Boolean {
            return oldItem.id == newItem.id
        }

        override fun areContentsTheSame(oldItem: NeUser, newItem: NeUser): Boolean {
            return oldItem.getDisplayName == newItem.getDisplayName
        }
    }
}
