/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.chat.adapter

import android.content.Context
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.widget.AppCompatImageView
import androidx.databinding.ViewDataBinding
import androidx.lifecycle.LifecycleCoroutineScope
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseMultiTypeSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.ThreadUtils.runOnUiThread
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.DateTimeUtils
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.databinding.ItemChatTimeBinding
import com.netacom.full.databinding.ItemFirstMessageBinding
import com.netacom.full.databinding.RowForwardMessageReceiverBinding
import com.netacom.full.databinding.RowForwardMessageSenderBinding
import com.netacom.full.databinding.RowMessageAudioReceiverBinding
import com.netacom.full.databinding.RowMessageAudioSenderBinding
import com.netacom.full.databinding.RowMessageCallIncomeBinding
import com.netacom.full.databinding.RowMessageCallOutcomeBinding
import com.netacom.full.databinding.RowMessageFileReceiverBinding
import com.netacom.full.databinding.RowMessageFileSenderBinding
import com.netacom.full.databinding.RowMessageImageRecevierBinding
import com.netacom.full.databinding.RowMessageImageSenderBinding
import com.netacom.full.databinding.RowMessageReceiverBinding
import com.netacom.full.databinding.RowMessageSenderBinding
import com.netacom.full.databinding.RowMessageStickerReceiverBinding
import com.netacom.full.databinding.RowMessageStickerSenderBinding
import com.netacom.full.databinding.RowMessageVideoReceiverBinding
import com.netacom.full.databinding.RowMessageVideoSenderBinding
import com.netacom.full.databinding.RowReplyMessageReceiverBinding
import com.netacom.full.databinding.RowReplyMessageSenderBinding
import com.netacom.full.define.ChatMessageType.FIRST_MESSAGE
import com.netacom.full.define.ChatMessageType.LEAVE_GROUP
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_AUDIO
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_CALL
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_FILE
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_FORWARD
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_IMAGE
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_LOCATION
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_REPLY
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_STICKER
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_TEXT
import com.netacom.full.define.ChatMessageType.MY_MESSAGE_VIDEO
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_AUDIO
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_CALL
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_FILE
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_FORWARD
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_IMAGE
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_LOCATION
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_REPLY
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_STICKER
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_TEXT
import com.netacom.full.define.ChatMessageType.PARTNER_MESSAGE_VIDEO
import com.netacom.full.define.ChatMessageType.TIME_MESSAGE
import com.netacom.full.define.ChatMessageType.UPDATE_GROUP
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.chat.viewholder.MessageAudioReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageAudioSenderViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageCallInComeViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageCallOutComeViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageFileReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageFileSenderViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageFirstViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageForwardReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageForwardSenderViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageImageReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageImageSenderViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageLocationReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageLocationSenderViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageReplyReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageReplySenderViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageStickerReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageStickerSenderViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageTextReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageTextSenderViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageVideoReceiverViewHolder
import com.netacom.full.ui.main.chat.viewholder.MessageVideoSenderViewHolder
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.utils.AudioSupport
import com.netacom.full.utils.ItemClickListener
import com.netacom.full.widget.video.PlayerExoHelper
import com.netacom.lite.define.CallDefine
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.define.MessageType
import com.netacom.lite.entity.database.attachment.NeDocument
import com.netacom.lite.entity.database.attachment.NeLocation
import com.netacom.lite.entity.database.attachment.NeVideo
import com.netacom.lite.entity.ui.message.NeAudio
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.message.NeRetryMessage
import com.netacom.lite.entity.ui.message.NeSubMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.local.db.DbManager
import com.netacom.lite.local.prefs.PreferencesHelperImpl
import com.netacom.lite.repository.DownloadRepository
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.repository.StickerRepository
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
Created by vantoan on 20/Aug/2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

/**
 * Please keep this class as backup for ListChatDiffUtilAdapter.
 */
class ListChatAdapter(
    private val groupType: Int,
    private val preferencesHelperImpl: PreferencesHelperImpl,
    private val groupRepository: GroupRepository,
    private val downloadRepository: DownloadRepository,
    private val stickerRepository: StickerRepository,
    private val dbManager: DbManager,
    private var members: List<NeUser>?,
    itemClick: ((NeSubMessage, View, Int) -> Unit)? = { _, _, _ -> },
    private val moreClick: ((NeMessage) -> Unit) = {},
    private val hideClick: ((NeMessage) -> Unit) = {},
    private val removeClick: ((NeMessage) -> Unit) = {},
    private val themeHelperImpl: ThemeHelperImpl,
    private val playerExoHelper: PlayerExoHelper
) : BaseMultiTypeSimpleAdapter<NeSubMessage, ViewDataBinding>(itemClick), AbstractItemClickListener {

    private var listener: ItemClickListener? = null
    private var isSingle = false

    private var context: Context? = null
    private val userID = preferencesHelperImpl.getUserId

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder<ViewDataBinding> {
        isSingle = groupType == GroupType.GROUP_TYPE_PUBLIC || groupType == GroupType.GROUP_TYPE_PRIVATE || groupType == GroupType.GROUP_TYPE_OFFICIAL
        context = parent.context
        return when (viewType) {
            TIME_MESSAGE -> BaseViewHolder(inflateView(parent, R.layout.item_chat_time) as ItemChatTimeBinding)
            // FIRST_MESSAGE, UPDATE_GROUP, LEAVE_GROUP -> BaseViewHolder(inflateView(parent, R.layout.item_first_message) as ItemFirstMessageBinding)
            FIRST_MESSAGE, UPDATE_GROUP, LEAVE_GROUP -> MessageFirstViewHolder(
                inflateView(parent, R.layout.item_first_message) as ItemFirstMessageBinding,
                groupType,
                userID
            )
            /*TEXT MESSAGE*/
            MY_MESSAGE_TEXT -> MessageTextSenderViewHolder(
                inflateView(parent, R.layout.row_message_sender) as RowMessageSenderBinding,
                contentClickListener = listener,
                themeHelperImpl = themeHelperImpl,
                groupType = groupType,
                groupRepository = groupRepository
            )
            PARTNER_MESSAGE_TEXT -> MessageTextReceiverViewHolder(
                inflateView(parent, R.layout.row_message_receiver) as RowMessageReceiverBinding,
                contentClickListener = listener,
                themeHelperImpl = themeHelperImpl,
                groupRepository = groupRepository
            )

            /*PHOTO MESSAGE*/
            MY_MESSAGE_IMAGE -> MessageImageSenderViewHolder(
                _binding = inflateView(parent, R.layout.row_message_image_sender) as RowMessageImageSenderBinding,
                contentClickListener = this,
                themeHelperImpl = themeHelperImpl,
                groupType = groupType
            )
            MY_MESSAGE_LOCATION -> MessageLocationSenderViewHolder(
                context = parent.context,
                _binding = inflateView(parent, R.layout.row_message_image_sender) as RowMessageImageSenderBinding,
                contentClickListener = this,
                themeHelperImpl = themeHelperImpl,
                groupType = groupType,
                groupRepository = groupRepository
            )

            PARTNER_MESSAGE_IMAGE -> MessageImageReceiverViewHolder(
                _binding = inflateView(parent, R.layout.row_message_image_recevier) as RowMessageImageRecevierBinding,
                context = parent.context,
                contentClickListener = this,
                themeHelperImpl = themeHelperImpl,
                groupType = groupType,
                downloadRepository = downloadRepository
            )

            PARTNER_MESSAGE_LOCATION -> MessageLocationReceiverViewHolder(
                _binding = inflateView(parent, R.layout.row_message_image_recevier) as RowMessageImageRecevierBinding,
                context = parent.context,
                contentClickListener = this
            )

            /*AUDIO MESSAGE*/
            MY_MESSAGE_AUDIO -> MessageAudioSenderViewHolder(
                inflateView(parent, R.layout.row_message_audio_sender) as RowMessageAudioSenderBinding,
                themeHelperImpl = themeHelperImpl,
                this,
                groupType = groupType
            )
            PARTNER_MESSAGE_AUDIO -> MessageAudioReceiverViewHolder(
                inflateView(parent, R.layout.row_message_audio_receiver) as RowMessageAudioReceiverBinding,
                themeHelperImpl,
                groupType
            )

            /*CALL(VOICE - VIDEO)*/
            MY_MESSAGE_CALL -> MessageCallOutComeViewHolder(
                (inflateView(parent, R.layout.row_message_call_outcome) as RowMessageCallOutcomeBinding),
                this,
                themeHelperImpl = themeHelperImpl,
                groupType = groupType
            )
            PARTNER_MESSAGE_CALL -> MessageCallInComeViewHolder(
                inflateView(parent, R.layout.row_message_call_income) as RowMessageCallIncomeBinding,
                this,
                themeHelperImpl,
                groupType = groupType
            )

            /*VIDEO MESSAGE*/
            MY_MESSAGE_VIDEO -> MessageVideoSenderViewHolder(
                inflateView(parent, R.layout.row_message_video_sender) as RowMessageVideoSenderBinding,
                this,
                themeHelperImpl = themeHelperImpl,
                token = preferencesHelperImpl.token ?: "",
                groupType = groupType,
                playerExoHelper = playerExoHelper
            )
            PARTNER_MESSAGE_VIDEO -> MessageVideoReceiverViewHolder(
                inflateView(parent, R.layout.row_message_video_receiver) as RowMessageVideoReceiverBinding,
                this,
                themeHelperImpl = themeHelperImpl,
                token = preferencesHelperImpl.token ?: "",
                groupType = groupType,
                downloadRepository = downloadRepository,
                playerExoHelper = playerExoHelper
            )

            /*REPLY MESSAGE(TEXT - PHOTO - VIDEO - STICKER)*/
            MY_MESSAGE_REPLY -> MessageReplySenderViewHolder(
                inflateView(parent, R.layout.row_reply_message_sender) as RowReplyMessageSenderBinding,
                contentClickListener = listener,
                this,
                themeHelperImpl = themeHelperImpl,
                groupType = groupType,
                groupRepository = groupRepository
            )
            PARTNER_MESSAGE_REPLY -> MessageReplyReceiverViewHolder(
                inflateView(parent, R.layout.row_reply_message_receiver) as RowReplyMessageReceiverBinding,
                listener,
                this,
                themeHelperImpl,
                groupType = groupType,
                groupRepository = groupRepository
            )

            /*FORWARD MESSAGE(TEXT - PHOTO)*/
            MY_MESSAGE_FORWARD -> MessageForwardSenderViewHolder(
                inflateView(parent, R.layout.row_forward_message_sender) as RowForwardMessageSenderBinding,
                contentClickListener = listener,
                this,
                themeHelperImpl = themeHelperImpl,
                groupType = groupType,
                groupRepository = groupRepository
            )
            PARTNER_MESSAGE_FORWARD -> MessageForwardReceiverViewHolder(
                inflateView(parent, R.layout.row_forward_message_receiver) as RowForwardMessageReceiverBinding,
                contentClickListener = listener,
                abstractClickListener = this,
                themeHelperImpl = themeHelperImpl,
                groupRepository = groupRepository
            )

            /*STICKER MESSAGE*/
            MY_MESSAGE_STICKER -> MessageStickerSenderViewHolder(
                inflateView(parent, R.layout.row_message_sticker_sender) as RowMessageStickerSenderBinding,
                themeHelperImpl,
                groupType = groupType,
                downloadRepository,
                stickerRepository,
                dbManager,
                this
            )
            PARTNER_MESSAGE_STICKER -> MessageStickerReceiverViewHolder(
                inflateView(parent, R.layout.row_message_sticker_receiver) as RowMessageStickerReceiverBinding,
                themeHelperImpl,
                downloadRepository,
                stickerRepository,
                dbManager,
                this
            )

            /*FILE MESSAGE (PDF - WORD,EXCEL,POWERPOINT)*/
            MY_MESSAGE_FILE -> MessageFileSenderViewHolder(
                _binding = inflateView(parent, R.layout.row_message_file_sender) as RowMessageFileSenderBinding,
                contentClickListener = this,
                themeHelperImpl,
                groupType = groupType
            )
            PARTNER_MESSAGE_FILE -> MessageFileReceiverViewHolder(
                _binding = inflateView(parent, R.layout.row_message_file_receiver) as RowMessageFileReceiverBinding,
                contentClickListener = this,
                themeHelperImpl,
                groupType = groupType
            )

            else -> BaseViewHolder(inflateView(parent, R.layout.row_message_sender) as RowMessageSenderBinding)
        }
    }

    override fun bindMultiType(position: Int): Int {
        getAll()[position].apply {
            return when {
                neTime != null -> TIME_MESSAGE
                this.neMessage?.type == MessageType.MESSAGE_TYPE_FIRST_MESSAGE -> FIRST_MESSAGE
                this.neMessage?.type == MessageType.MESSAGE_TYPE_GROUP_UPDATE -> UPDATE_GROUP
                this.neMessage?.type == MessageType.MESSAGE_TYPE_LEAVE_GROUP -> LEAVE_GROUP
                this.neMessage?.owner?.id == preferencesHelperImpl.getUserId -> {
                    if (data[position].neMessage?.status == MessageStatusType.MESSAGE_DELETED) {
                        MY_MESSAGE_TEXT
                    } else when (this.neMessage?.type) {
                        MessageType.MESSAGE_TYPE_TEXT -> MY_MESSAGE_TEXT
                        MessageType.MESSAGE_TYPE_IMAGE -> MY_MESSAGE_IMAGE
                        MessageType.MESSAGE_TYPE_AUDIO -> MY_MESSAGE_AUDIO
                        MessageType.MESSAGE_TYPE_CALL -> MY_MESSAGE_CALL
                        MessageType.MESSAGE_TYPE_VIDEO -> MY_MESSAGE_VIDEO
                        MessageType.MESSAGE_TYPE_REPLY -> MY_MESSAGE_REPLY
                        MessageType.MESSAGE_TYPE_FORWARD -> MY_MESSAGE_FORWARD
                        MessageType.MESSAGE_TYPE_FILE -> MY_MESSAGE_FILE
                        MessageType.MESSAGE_TYPE_STICKER -> MY_MESSAGE_STICKER
                        MessageType.MESSAGE_TYPE_LOCATION -> MY_MESSAGE_LOCATION
                        else -> MY_MESSAGE_TEXT
                    }
                }
                else -> {
                    if (data[position].neMessage?.status == MessageStatusType.MESSAGE_DELETED) {
                        PARTNER_MESSAGE_TEXT
                    } else when (this.neMessage?.type) {
                        MessageType.MESSAGE_TYPE_TEXT -> PARTNER_MESSAGE_TEXT
                        MessageType.MESSAGE_TYPE_IMAGE -> PARTNER_MESSAGE_IMAGE
                        MessageType.MESSAGE_TYPE_AUDIO -> PARTNER_MESSAGE_AUDIO
                        MessageType.MESSAGE_TYPE_CALL -> PARTNER_MESSAGE_CALL
                        MessageType.MESSAGE_TYPE_VIDEO -> PARTNER_MESSAGE_VIDEO
                        MessageType.MESSAGE_TYPE_REPLY -> PARTNER_MESSAGE_REPLY
                        MessageType.MESSAGE_TYPE_FORWARD -> PARTNER_MESSAGE_FORWARD
                        MessageType.MESSAGE_TYPE_FILE -> PARTNER_MESSAGE_FILE
                        MessageType.MESSAGE_TYPE_STICKER -> PARTNER_MESSAGE_STICKER
                        MessageType.MESSAGE_TYPE_LOCATION -> PARTNER_MESSAGE_LOCATION
                        else -> PARTNER_MESSAGE_TEXT
                    }
                }
            }
        }
    }

    override fun onBindViewHolder(holder: BaseViewHolder<ViewDataBinding>, position: Int) {
        if (data[position].isInValid) return
        val item = data[position].neMessage
        with(holder) {
            binding.setVariable(BR.item, item)
            val messagePosition = getMessagePosition(position = position, neMessage = item)
            when (getItemViewType(position)) {
                TIME_MESSAGE -> messageTextTimeBind(this, data[position].neTime)
                FIRST_MESSAGE, UPDATE_GROUP, LEAVE_GROUP -> messageFirstBind(this, item)

                MY_MESSAGE_TEXT -> messageTextSenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_TEXT -> messageTextReceiverBind(this, item, messagePosition)

                MY_MESSAGE_IMAGE -> messageImageSenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_IMAGE -> messageImageReceiverBind(this, item, messagePosition)

                MY_MESSAGE_LOCATION -> messageLocationSenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_LOCATION -> messageLocationReceiverBind(this, item, messagePosition)

                MY_MESSAGE_AUDIO -> messageAudioSenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_AUDIO -> messageAudioReceiverBind(this, item, messagePosition)

                MY_MESSAGE_CALL -> messageCallOutComeBind(this, item, messagePosition)
                PARTNER_MESSAGE_CALL -> messageCallInComeBind(this, item, messagePosition)

                MY_MESSAGE_VIDEO -> messageVideoSenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_VIDEO -> messageVideoReceiverBind(this, item, messagePosition)

                MY_MESSAGE_REPLY -> messageReplySenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_REPLY -> messageReplyReceiverBind(this, item, messagePosition)

                MY_MESSAGE_FORWARD -> messageForwardSenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_FORWARD -> messageForwardReceiverBind(this, item, messagePosition)

                MY_MESSAGE_FILE -> messageFileSenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_FILE -> messageFileReceiverBind(this, item, messagePosition)

                MY_MESSAGE_STICKER -> messageStickerSenderBind(this, item, messagePosition)
                PARTNER_MESSAGE_STICKER -> messageStickerReceiverBind(this, item, messagePosition)
            }
            binding.executePendingBindings()
        }
    }

    private fun checkOwner(firstNeMessage: NeMessage?, secondNeMessage: NeMessage?) = firstNeMessage?.owner?.id == secondNeMessage?.owner?.id

    private fun checkSpecialType(pos: Int): Boolean {
        return when (getItemViewType(pos)) {
            TIME_MESSAGE, FIRST_MESSAGE, UPDATE_GROUP, LEAVE_GROUP -> true
            else -> false
        }
    }

    @Suppress("SpellCheckingInspection")
    private fun messageTextTimeBind(holder: BaseViewHolder<ViewDataBinding>, timeCreated: Long?) {
        timeCreated ?: return
        (holder.binding as ItemChatTimeBinding).apply {
            txtTime.text = DateTimeUtils.ParseDateTimeToString.parse(
                timeCreated.run {
                    if (timeCreated.toString().length > 10) {
                        timeCreated.toString().substring(0, 10).toLongOrNull()?.let {
                            it * 1000
                        } ?: 0L
                    } else {
                        timeCreated * 1000
                    }
                },
                DateTimeUtils.ParseDateTimeToString.FULL_DATE_TIME_FORMAT_PATTERN
            )
        }
    }

    private fun messageFirstBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?) {
        item ?: return
        (holder as MessageFirstViewHolder).apply {
            bind(item, isOneToOne = isSingle, members = members)
        }
    }

    private fun messageTextSenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageTextSenderViewHolder).apply {
            bind(
                item = item,
                messagePosition = messagePosition,
                members = members,
                context = context
            )

            holder._binding.txtTitle.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            retryMessage(holder._binding.imgSend, item)
        }
    }

    private fun messageTextReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageTextReceiverViewHolder).apply {
            bind(
                item = item,
                messagePosition = messagePosition,
                members = members,
                avatarCallback = {
                    listener?.onAvatarClicked(item.owner)
                },
                isSingle = isSingle,
                context = context
            )
        }

        holder._binding.txtTitle.setOnLongClickListener {
            listener?.onLongItemClick(item)
            false
        }
    }

    private fun messageImageSenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as? MessageImageSenderViewHolder)?.apply {
            holder.bind(message = item, messagePosition = messagePosition)
            listener?.let {
                holder.setItemLongClickAction(it)
            }
            holder._binding.ivPhoto.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            retryMessage(holder._binding.imgSend, item)
        }
    }

    private fun messageImageReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as? MessageImageReceiverViewHolder)?.apply {
            holder.bind(
                message = item,
                messagePosition = messagePosition,
                members = members ?: mutableListOf(),
                isSingle = isSingle,
                avatarCallback = {
                    // todo: action click in receiver avatar
                    listener?.onAvatarClicked(item.owner)
                }
            )
            listener?.let {
                holder.setItemLongClickAction(it)
            }
            holder._binding.ivPhoto.setOnLongClickListener {
                listener?.onLongItemClick(item)
                false
            }
        }
    }

    private fun messageLocationSenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as? MessageLocationSenderViewHolder)?.apply {
            holder.bind(message = item, messagePosition = messagePosition)

            holder._binding.ivPhoto.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            retryMessage(holder._binding.imgSend, item)
        }
    }

    private fun messageLocationReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as? MessageLocationReceiverViewHolder)?.apply {
            holder.bind(
                message = item,
                messagePosition = messagePosition,
                members = members ?: mutableListOf(),
                isSingle = isSingle,
                avatarCallback = {
                    // todo: action click in receiver avatar
                    listener?.onAvatarClicked(item.owner)
                }
            )

            holder._binding.ivPhoto.setOnLongClickListener {
                listener?.onLongItemClick(item)
                false
            }
        }
    }

    private fun messageForwardSenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageForwardSenderViewHolder).apply {
            bind(
                messagePosition = messagePosition,
                item = item,
                members = members
            )
            holder._binding.textReply.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            retryMessage(holder._binding.imgSend, item)
        }
    }

    private fun messageForwardReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageForwardReceiverViewHolder).apply {
            bind(
                messagePosition = messagePosition,
                item = item,
                members = members,
                groupType = groupType,
                avatarCallback = {
                    listener?.onAvatarClicked(item.owner)
                }
            )
            holder._binding.textReply.setOnLongClickListener {
                listener?.onLongItemClick(item)
                false
            }
        }
    }

    private fun messageStickerSenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageStickerSenderViewHolder).apply {
            bind(
                item = item,
                messagePosition = messagePosition
            )
        }
    }

    private fun messageStickerReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageStickerReceiverViewHolder).apply {
            bind(
                item = item,
                messagePosition = messagePosition,
                avatarCallback = {
                    listener?.onAvatarClicked(item.owner)
                },
                isSingle = isSingle
            )
        }
    }

    private fun messageAudioSenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as? MessageAudioSenderViewHolder)?.apply {
            bind(message = item, messagePosition = messagePosition, userToken = preferencesHelperImpl.token ?: "")
            holder._binding.ctlContainer.setOnLongClickListener {
                listener?.onLongItemClick(item)
                false
            }
            retryMessage(holder._binding.imgSend, item)
        }
    }

    private fun messageAudioReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as? MessageAudioReceiverViewHolder)?.apply {
            bind(
                message = item,
                userToken = preferencesHelperImpl.token ?: "",
                messagePosition = messagePosition,
                isSingle = isSingle,
                downloadRepository = downloadRepository,
                avatarCallback = {
                    // todo: action click in receiver avatar
                    listener?.onAvatarClicked(item?.owner)
                }
            )
            holder._binding.ctlContainer.setOnLongClickListener {
                listener?.onLongItemClick(item)
                false
            }
        }
    }

    private fun messageCallOutComeBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageCallOutComeViewHolder).apply {
            val isVoice = if (item.attachment?.call?.mediaType == CallDefine.MEDIA_TYPE_AUDIO) true
            else item.attachment?.call?.mediaType != CallDefine.MEDIA_TYPE_VIDEO
            val callFailed = item.attachment?.call?.acceptedUins?.size == 1 &&
                item.attachment?.call?.acceptedUins?.contains(preferencesHelperImpl.getUserId.toString()) == true

            bind(
                isVoice = isVoice,
                isCallSuccess = !callFailed,
                messagePosition = messagePosition,
                item = item,
                members = members
            )
        }
    }

    private fun messageCallInComeBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageCallInComeViewHolder).apply {
            val isVoice = if (item.attachment?.call?.mediaType == CallDefine.MEDIA_TYPE_AUDIO) true
            else item.attachment?.call?.mediaType == CallDefine.MEDIA_TYPE_VIDEO

            val isCallSuccess = item.attachment?.call?.acceptedUins?.contains(preferencesHelperImpl.getUserId.toString()) == true

            bind(
                isVoice = isVoice,
                isCallSuccess = isCallSuccess,
                messagePosition = messagePosition,
                item = item,
                members = members
            )
        }
    }

    private fun messageReplySenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageReplySenderViewHolder).apply {
            bind(
                item = item,
                messagePosition = messagePosition,
                members = members
            )
            holder._binding.textReply.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            retryMessage(holder._binding.imgSend, item)
        }
    }

    private fun messageReplyReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as MessageReplyReceiverViewHolder).apply {
            bind(
                item = item,
                position = messagePosition,
                members = members ?: mutableListOf(),
                isSingle = isSingle,
                avatarCallback = {
                    // todo: action click in receiver avatar
                    listener?.onAvatarClicked(item.owner)
                }
            )

            holder._binding.textReply.setOnLongClickListener {
                listener?.onLongItemClick(item)
                false
            }
        }
    }

    private fun messageVideoSenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        // For video
        item ?: return
        (holder as? MessageVideoSenderViewHolder)?.apply {
            bind(item, messagePosition)

            holder._binding.videoPlayer.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            holder._binding.ivThumbnail.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            retryMessage(holder._binding.imgSend, item)
        }
    }

    private fun messageVideoReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        // For video
        item ?: return
        (holder as? MessageVideoReceiverViewHolder)?.apply {
            bind(
                item,
                messagePosition,
                members ?: mutableListOf(),
                isSingle = isSingle,
                avatarCallback = {
                    listener?.onAvatarClicked(item.owner)
                }
            )

            holder._binding.videoPlayer.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            holder._binding.ivThumbnail.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }
        }
    }

    private fun messageFileSenderBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as? MessageFileSenderViewHolder)?.apply {
            bind(item, messagePosition)

            holder._binding.rlDocumentContainer.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }

            retryMessage(holder._binding.imgSend, item)
        }
    }

    private fun messageFileReceiverBind(holder: BaseViewHolder<ViewDataBinding>, item: NeMessage?, messagePosition: MessagePosition) {
        item ?: return
        (holder as? MessageFileReceiverViewHolder)?.apply {
            bind(
                message = item,
                messagePosition = messagePosition,
                members = members,
                isSingle = isSingle,
                avatarCallback = {
                    listener?.onAvatarClicked(item.owner)
                }
            )

            holder._binding.rlDocumentContainer.setOnLongClickListener {
                if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                    listener?.onLongItemClick(item)
                }
                false
            }
        }
    }

    fun getLastMessage(): NeMessage? {
        return data.firstOrNull {
            it.neMessage != null && itemCount > 0
        }?.neMessage
    }

    class MessageDiff(
        private val oldList: List<NeSubMessage>,
        private val newList: List<NeSubMessage>
    ) : DiffUtil.Callback() {
        override fun areItemsTheSame(oldItemPosition: Int, newItemPosition: Int): Boolean {
            return if (oldList[oldItemPosition].isMessage && newList[newItemPosition].isMessage) {
                true
            } else !oldList[oldItemPosition].isMessage && !newList[newItemPosition].isMessage
        }

        override fun getOldListSize(): Int {
            return oldList.size
        }

        override fun getNewListSize(): Int {
            return newList.size
        }

        override fun areContentsTheSame(oldItemPosition: Int, newItemPosition: Int): Boolean {
            return if (oldList[oldItemPosition].neTime != null && newList[newItemPosition].neTime != null &&
                oldList[oldItemPosition].neTime == newList[newItemPosition].neTime
            ) {
                true
            } else {
                oldList[oldItemPosition].isMessage && newList[newItemPosition].isMessage &&
                    oldList[oldItemPosition].neMessage?.createAt == newList[newItemPosition].neMessage?.createAt &&
                    oldList[oldItemPosition].neMessage?.status == newList[newItemPosition].neMessage?.status
            }
        }
    }
    private fun getMessagePosition(position: Int, neMessage: NeMessage?): MessagePosition {
        neMessage ?: return MessagePosition.SINGLE
        return when (getItemViewType(position)) {
            TIME_MESSAGE, FIRST_MESSAGE, UPDATE_GROUP, LEAVE_GROUP -> {
                MessagePosition.SINGLE
            }
            else -> {
                if (position == 0) {
                    if ((position + 1) < data.size && checkOwner(neMessage, data[position + 1].neMessage) && !checkSpecialType(position + 1)) {
                        MessagePosition.TOP
                    } else {
                        MessagePosition.SINGLE
                    }
                } else if (position > 0 && checkOwner(neMessage, data[position - 1].neMessage)) {
                    if ((position + 1) < data.size && checkOwner(neMessage, data[position + 1].neMessage) && !checkSpecialType(position + 1)) {
                        MessagePosition.MID
                    } else {
                        MessagePosition.BOTTOM
                    }
                } else if ((position + 1) < data.size && checkOwner(neMessage, data[position + 1].neMessage) && !checkSpecialType(position + 1)) {
                    MessagePosition.TOP
                } else {
                    MessagePosition.SINGLE
                }
            }
        }
    }

    fun addNewMessage(neMessages: List<NeSubMessage>, isNewMessage: Boolean = true) {
        addLatestMessage(neMessages, isNewMessage)
    }

    private fun addLatestMessage(neMessages: List<NeSubMessage>, isNewMessage: Boolean = false) {
        val latestMessages = compareTwoListData(oldList = data.toMutableList(), newList = neMessages)
        if (isNewMessage) {
            data.addAll(latestMessages)
            notifyItemRangeInserted(itemCount - neMessages.size, itemCount)
        } else {
            data.addAll(0, latestMessages)
            notifyItemRangeInserted(0, neMessages.size)
        }
    }

    /**
     * Quick fix to resolve issue duplicate data & load more
     * Will be replace it by DiffUtil
     */
    private fun compareTwoListData(oldList: List<NeSubMessage>, newList: List<NeSubMessage>): List<NeSubMessage> {
        return newList.minus(oldList.toHashSet()).toMutableList()
    }

    fun createMessageSuccess(tempMessageId: String?, neMessage: NeMessage?, lifecycleScope: LifecycleCoroutineScope) {
        /**
         * For audio
         * */
        if (AudioSupport.messageId == tempMessageId?.toLongOrNull()) {
            AudioSupport.messageId = neMessage?.id?.toLongOrNull()
        }
        CoroutineScope(Dispatchers.Main).launch {
            for ((i, entry) in data.withIndex()) {
                if (entry.isMessage && entry.neMessage?.id == tempMessageId) {
                    entry.neMessage?.id = neMessage?.id
                    entry.neMessage?.status = neMessage?.status ?: MessageStatusType.MESSAGE_SENT
                    if (neMessage?.type == MessageType.MESSAGE_TYPE_IMAGE || neMessage?.type == MessageType.MESSAGE_TYPE_AUDIO) {
                        lifecycleScope.launch {
                            delay(500)
                            // Logger.e("message update attacthment before= ${entry.neMessage?.attachment}")
                            entry.neMessage?.attachment = neMessage.attachment
                            // Logger.e("message update attacthment after= ${entry.neMessage?.attachment}")

                            // Logger.e("message update attacthment list = $data")
                        }
                    }
                    notifyItemChanged(i, entry)
                    if (i - 1 >= 0) {
                        notifyItemChanged(i - 1)
                    }
                    break
                }
            }
        }
    }

    fun createMessageFail(tempMessageId: String?) {
        for ((i, entry) in data.withIndex()) {
            if (entry.isMessage && entry.neMessage?.id == tempMessageId) {
                entry.neMessage?.status = MessageStatusType.MESSAGE_FAILED
                runOnUiThread {
                    notifyItemChanged(i, entry)
                }
                break
            }
        }
    }

    fun deleteMessage(messageId: String?) {
        if (data.isEmpty()) return

        for (i in data.size - 1 downTo 0) {
            val entry = data[i]
            if (entry.isMessage && entry.neMessage?.id == messageId) {
                data.removeAt(i)
                runOnUiThread {
                    notifyItemRemoved(i)
                }
                break
            }
        }
    }

    fun setItemClickListener(listener: ItemClickListener) {
        this.listener = listener
    }

    private fun retryMessage(imgSend: AppCompatImageView, neMessage: NeMessage) {
        imgSend.clickDebounce {
            if (neMessage.status == MessageStatusType.MESSAGE_FAILED) {
                listener?.onRetryMessage(neMessage)
            }
        }
    }

    override fun onDisplayImage(imageUrls: List<String>, imageClickedPos: Int, isLocalLink: Boolean, messageId: String?) {
        val message = data.find {
            it.neMessage?.id == messageId
        }
        val listUrl = when {
            message?.neMessage?.attachment?.images?.isNotEmpty() ?: false -> {
                message?.neMessage?.attachment?.images?.mapNotNull {
                    it.url
                }
            }
            message?.neMessage?.attachment?.forwardMessage?.attachment?.images?.isNotEmpty() ?: false -> {
                message?.neMessage?.attachment?.forwardMessage?.attachment?.images?.mapNotNull {
                    it.url
                }
            }
            message?.neMessage?.attachment?.replyMessage?.attachment?.images?.isNotEmpty() ?: false -> {
                message?.neMessage?.attachment?.replyMessage?.attachment?.images?.mapNotNull {
                    it.url
                }
            }
            else -> emptyList()
        }

        this.listener?.onDisplayImage(position = imageClickedPos, listUrl, messageId)
    }

    override fun onViewVideo(neVideo: NeVideo, itemClickedPos: Int) {
        this.listener?.onViewVideo(position = itemClickedPos, neVideo)
    }

    override fun onDocumentAction(messageId: String?, docItem: NeDocument, itemClickedPos: Int, isDownload: Boolean) {
        this.listener?.onDocumentAction(messageId, docItem, itemClickedPos, isDownload)
    }

    override fun onLocationClick(neLocation: NeLocation, neMessage: NeMessage) {
        this.listener?.onLocationClick(neLocation, neMessage)
    }

    override fun onLongItemClick(neMessage: NeMessage) {
        listener?.onLongItemClick(neMessage)
    }

    override fun onAudioClick(messageId: String?, relatedMessageId: String?, audio: NeAudio, itemClickedPos: Int) {
        data.firstOrNull { neSubMessage -> neSubMessage.neMessage?.id == relatedMessageId }.apply {
            if (this != null) {
                data.indexOf(this).apply {
                    listener?.onScrollToPosition(this)
                }
            }
        }
    }

    fun updateRetryMessage(neRetryMessage: NeRetryMessage) {
        for (i in data.size - 1 downTo 0) {
            val entry = data[i]
            if (entry.isMessage && entry.neMessage?.id == neRetryMessage.messageTempId) {
                data.removeAt(i)
                notifyItemRemoved(i)

                neRetryMessage.neSubMessages?.let {
                    addNewMessage(neMessages = it, isNewMessage = true)
                }
                break
            }
        }
    }

    fun updateMembers(members: List<NeUser>?) {
        this.members = members
    }

    override fun onCallClicked(messageInfo: NeMessage?, isVoice: Boolean) {
        this.listener?.onCallVoiceOrVideo(messageInfo, isVoice)
    }

    val getData
        get() = getAll()
}
