package com.netacom.full.ui.main.chat.adapter

import android.view.View
import com.netacom.base.chat.adapter.BaseSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.full.R
import com.netacom.full.databinding.ItemRcvMemberBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.local.prefs.PreferencesHelperImpl

class MemberChatInfoAdapter(
    itemClick: ((NeUser, View, Int) -> Unit)?,
    private val clickMine: ((Boolean) -> Unit)?,
    private val leaderId: Long,
    private val themeHelperImpl: ThemeHelperImpl? = null,
    private val onRemoveMember: ((NeUser) -> Unit),
    private val preferencesHelperImpl: PreferencesHelperImpl,
    private val isChannel: Boolean = false
) : BaseSimpleAdapter<NeUser, ItemRcvMemberBinding>(itemClick) {

    override val layout: Int
        get() = R.layout.item_rcv_member

    override fun bind(item: NeUser, holder: BaseViewHolder<ItemRcvMemberBinding>, position: Int) {
        val isMineItem = preferencesHelperImpl.getUserId == item.id
        val isLeaderItem = item.id == leaderId
        with(holder.binding) {
            ivMemberAvatar.setImageDrawable(null)
            this.item = item
            isLeader = isLeaderItem
            isMine = isMineItem
            isChannel = this@MemberChatInfoAdapter.isChannel
            hasDivider = true
            if (isMineItem && isLeaderItem) {
                var accountName = preferencesHelperImpl.user?.username ?: item.getDisplayName
                if (accountName.length > 24) {
                    accountName = accountName.substring(0, 18) + StringUtils.getString(R.string.string_3_dot)
                }
                myLeaderName = String.format(StringUtils.getString(R.string.text_message_user_is_you), accountName)
            }
            hasDivider = true
            swipeLayout.setNoSwipe((preferencesHelperImpl.getUserId == leaderId && !isMineItem))
            layoutItemCheckOwner.clickDebounce {
                if (isMineItem) {
                    clickMine?.invoke(true)
                } else {
                    itemClick?.invoke(item, holder.itemView, position)
                }
            }

            ivRemoveMember.clickDebounce {
                if (swipeLayout.isOpen()) {
                    onRemoveMember.invoke(item)
                }
            }
            themeHelperImpl?.setThemeColorForViews(tvMemberLeader)
        }
    }
}
